Name:           gujin
Version:        2.8.7
Release:        1%{?dist}
Summary:        A PC (i386/x86_64) graphic boot-loader with mouse

Group:          System Environment/Base
License:        GPLv2
URL:            http://gujin.org
Source0:        http://sourceforge.net/projects/%{name}/files/%{name}/%{version}/%{name}-%{version}.tar.gz 
BuildRoot:      %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

#BuildRequires:  just GCC, gawk
#Requires:       bash?

%description

This is a PC (IA32/x86_64) boot-loader which, like Lilo and unlike Grub, run
completely in IA32 real mode (easier to chain-boot other O.S. which expect
real-mode entry point, or chain-load El-Torito CD/DVDROM, reply natively
to unknown BIOS interrupts), but like Grub and unlike Lilo, understand
file-systems and can load kernel/initrd files by their file name, instead of
needing to be configured with the position/size of the file to load.

Moreover, unlike any other boot-loader, Gujin is fully graphic (selection of
the kernel to boot with the mouse), and do not need any configuration
(but maybe per-distribution /boot/gujin.cmd) because it auto-detects
BIOS disk order and kernels in the file-systems it understands (FAT12/16/32,
EXT2/3/4, ISO9660). Standalone/tiny versions are also available, they
do not display a menu but load the newest kernel found.

Installing this package will not only install the Gujin installer named
"gujin", but also install Gujin in the file /boot/gujin.ebios, modifying
the MBR of the disk. If for whatever reason Gujin do not work for you,
you can uninstall it from the boot-loader itself, and it will restore the
previously installed boot-loader.

The installer can be used to initialize and make boot-able floppy disks,
USB sticks/SD cards, CD/DVD-ROMs, and to query which boot-loader is
currently installed.

Removing this package will also replace the MBR with the one saved at
installation time, so your disk should remain boot-able.

Because Gujin runs natively in real mode, two implementations (with
and without menu) can be run from DOS, see the man page.
Unlike some other DOS Linux loaders, Gujin enters the Linux kernel by the
officially documented entry point.

This package do not need any external libraries, so can be compiled
indifferently on IA32 hosts or on x86_64 hosts.

%prep
%setup -q -n %{name}

%build
make %{?_smp_mflags}

%pre
# If gujin is already installed (upgrade or re-install), try to remove the
# previous install if possible (impossible if installed in B.E.E.R. area),
# so next uninstall of current package will re-install the initial boot-loader:
# Do not remove anything if /boot/gujin.[bios|idechs|idelba|idel48] is installed.
if [ -x /sbin/gujin -a -f /boot/gujin.ebios ] ; then \
        if /sbin/gujin --force --remove /boot/gujin.ebios ; \
                then echo "Previous Gujin removed"; \
                else echo "Remove manually files /boot/gujin.*" ; fi ; fi
# if failed, move away /boot/gujin.ebios, it may be linked to the partition
# boot record, or /boot reside on a partition not on the first disk:
# (then, two uninstall are needed to get back to Grub)
if [ -f /boot/gujin.ebios ] ; then /bin/mv -f /boot/gujin.ebios /boot/gujin-`date -u +%Y-%m-%d-%0k-%0M`.ebios ; fi

%install
/bin/rm -rf %{buildroot}
make install DESTDIR=%{buildroot}

%post
# The gujin installer will verify the disk content after installation,
# unless --check=writeonly parameter is given, a sync() is done
# internally before reading back the device, but do it also before
# installation, in case the hard disk subsystem is loaded.
sync ; sync
/sbin/gujin /boot/gujin.ebios

%preun
if [ -x /sbin/gujin -a -f /boot/gujin.ebios ] ; then \
        if /sbin/gujin --force --remove /boot/gujin.ebios ; then echo "Current Gujin removed"; fi ; fi

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root,-)
%doc install.txt README.htm gpg_sign.txt 
/sbin/gujin
%{_mandir}/man8/*

%changelog
* Wed Nov 28 2012 Etienne Lorrain <etienne.lorrain at, gujin.org> 2.8.7-1
initial version 
* Wed Oct 10 2012 Etienne Lorrain <etienne.lorrain at, gujin.org> 2.8.6-1
initial version 
* Wed Feb 8 2012 Etienne Lorrain <etienne.lorrain at, gujin.org> 2.8.5-1
initial version
* Wed Jun 29 2011 Etienne Lorrain <etienne.lorrain at, gujin.org> 2.8.4-1
initial version
* Wed Dec 8 2010 Etienne Lorrain <etienne.lorrain at, gujin.org> 2.8.3-1
initial version
* Wed Jun 16 2010 Etienne Lorrain <etienne.lorrain at, gujin.org> 2.8.2-1
initial version
* Wed Mar 3 2010 Etienne Lorrain <etienne.lorrain at, gujin.org> 2.8.1-1
initial version
* Sun Jan 10 2010 Etienne Lorrain <etienne.lorrain at, gujin.org> 2.8-1
initial version
* Sun Aug 23 2009 Etienne Lorrain <etienne.lorrain at, gujin.org> 2.7-1
initial version
