/* $Id: mdichild.h,v 1.6 2011/03/03 19:12:57 arif Exp $Revision: */
/* vim:set shiftwidth=4 ts=8: */

/*************************************************************************
 * Copyright (c) 2011 AT&T Intellectual Property
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors: See CVS logs. Details at http://www.graphviz.org/
 *************************************************************************/


#ifndef MDICHILD_H
#define MDICHILD_H

#include <QTextEdit>
#include "imageviewer.h"
class CMainWindow;

class MdiChild : public QTextEdit
{
    Q_OBJECT

public:
    MdiChild();

    void newFile();
    bool loadFile(const QString &fileName);
    bool save();
    bool saveAs();
    bool saveFile(const QString &fileName);
    QString userFriendlyCurrentFile();
    QString currentFile() { return curFile; }
    int layoutIdx;
    int renderIdx;
    QString outputFile;
    bool preview;
    bool applyCairo;
    QString attributes;
    ImageViewer* previewFrm;
    CMainWindow* parentFrm;
    bool loadPreview(QString fileName);
    bool firstTime();
    bool settingsSet;
protected:
    void closeEvent(QCloseEvent *event);

private slots:
    void documentWasModified();

private:
    bool maybeSave();
    void setCurrentFile(const QString &fileName);
    QString strippedName(const QString &fullFileName);

    QString curFile;
    bool isUntitled;
};

#endif
