# Release notes for Gluster 10.0

This is a major release that includes a range of features, code improvements and stability fixes as noted below.

A selection of the key features and changes are documented in this page.
A full list of bugs that have been addressed is included further below.

- [Announcements](#announcements)
- [Highlights](#highlights)
- [Bugs addressed in the release](#bugs-addressed)

## Announcements

1. Releases that receive maintenance updates post release 10 is 9
([reference](https://www.gluster.org/release-schedule/))
2. Release 10 will receive maintenance updates around the 15th of every alternative month, and the release 9 will recieve maintainance updates around 15th every three months. 




## Highlights

- Major performance improvement of ~20% w.r.t small files
  as well as large files testing in controlled lab environments [#2771](https://github.com/gluster/glusterfs/issues/2771)
- Randomized port selection for bricks, improves startup time [#786](https://github.com/gluster/glusterfs/issues/786)
- Performance improvement with use of readdir instead of readdirp in fix-layout [#2241](https://github.com/gluster/glusterfs/issues/2241)
- Heal time improvement with bigger window size [#2067](https://github.com/gluster/glusterfs/issues/2067)

## Bugs addressed

Bugs addressed since release-9 are listed below.

[#504](https://github.com/gluster/glusterfs/issues/504)  AFR: remove memcpy() + ntoh32() pattern
[#705](https://github.com/gluster/glusterfs/issues/705)  gf_backtrace_save inefficiencies
[#782](https://github.com/gluster/glusterfs/issues/782)  Do not explicitly call strerror(errnum) when logging
[#786](https://github.com/gluster/glusterfs/issues/786)  glusterd-pmap binds to 10K ports on startup (using IPv4)
[#904](https://github.com/gluster/glusterfs/issues/904)  [bug:1649037] Translators allocate too much memory in their xlator_
[#1000](https://github.com/gluster/glusterfs/issues/1000) [bug:1193929] GlusterFS can be improved
[#1002](https://github.com/gluster/glusterfs/issues/1002) [bug:1679998] GlusterFS can be improved
[#1052](https://github.com/gluster/glusterfs/issues/1052) [bug:1693692] Increase code coverage from regression tests
[#1060](https://github.com/gluster/glusterfs/issues/1060) [bug:789278] Issues reported by Coverity static analysis tool
[#1096](https://github.com/gluster/glusterfs/issues/1096) [bug:1622665] clang-scan report: glusterfs issues
[#1101](https://github.com/gluster/glusterfs/issues/1101) [bug:1813029] volume brick fails to come online because other proce
[#1251](https://github.com/gluster/glusterfs/issues/1251) performance: improve __afr_fd_ctx_get() function
[#1339](https://github.com/gluster/glusterfs/issues/1339) Rebalance status is not shown correctly after node reboot
[#1358](https://github.com/gluster/glusterfs/issues/1358) features/shard: wrong "inode->ref" leading to ASSERT in inode_unref
[#1359](https://github.com/gluster/glusterfs/issues/1359) Cleanup --disable-mempool
[#1380](https://github.com/gluster/glusterfs/issues/1380) fd_unref() optimization - do an atomic decrement outside the lock a
[#1384](https://github.com/gluster/glusterfs/issues/1384) mount glusterfs volume, files larger than 64Mb only show 64Mb
[#1406](https://github.com/gluster/glusterfs/issues/1406) shared storage volume fails to mount in ipv6 environment
[#1415](https://github.com/gluster/glusterfs/issues/1415) Removing problematic language in geo-replication
[#1423](https://github.com/gluster/glusterfs/issues/1423) shard_make_block_abspath() should be called with a string of of the
[#1536](https://github.com/gluster/glusterfs/issues/1536) Improve dict_reset() efficiency
[#1545](https://github.com/gluster/glusterfs/issues/1545) fuse_invalidate_entry() - too many repetitive calls to uuid_utoa()
[#1583](https://github.com/gluster/glusterfs/issues/1583) Rework stats structure (xl->stats.total.metrics[fop_idx] and friend
[#1584](https://github.com/gluster/glusterfs/issues/1584) MAINTAINERS file needs to be revisited and updated
[#1596](https://github.com/gluster/glusterfs/issues/1596) 'this' NULL check relies on 'THIS' not being NULL
[#1600](https://github.com/gluster/glusterfs/issues/1600) Save and re-use MYUUID
[#1678](https://github.com/gluster/glusterfs/issues/1678) Improve gf_error_to_errno() and gf_errno_to_error() positive flow
[#1695](https://github.com/gluster/glusterfs/issues/1695) Rebalance has a redundant lookup operation
[#1702](https://github.com/gluster/glusterfs/issues/1702) Move GF_CLIENT_PID_GSYNCD check to start of the function.
[#1703](https://github.com/gluster/glusterfs/issues/1703) Remove trivial check for GF_XATTR_SHARD_FILE_SIZE before calling sh
[#1707](https://github.com/gluster/glusterfs/issues/1707) PL_LOCAL_GET_REQUESTS access the dictionary twice for the same info
[#1717](https://github.com/gluster/glusterfs/issues/1717) glusterd: sequence of rebalance and replace/reset-brick presents re
[#1723](https://github.com/gluster/glusterfs/issues/1723) DHT: further investigation for treating an ongoing mknod's linkto file
[#1749](https://github.com/gluster/glusterfs/issues/1749) brick-process: call 'notify()' and 'fini()' of brick xlators in a p
[#1755](https://github.com/gluster/glusterfs/issues/1755) Reduce calls to 'THIS' in fd_destroy() and others, where 'THIS' is
[#1761](https://github.com/gluster/glusterfs/issues/1761) CONTRIBUTING.md regression can only be run by maintainers
[#1764](https://github.com/gluster/glusterfs/issues/1764) Slow write on ZFS bricks after healing millions of files due to add
[#1772](https://github.com/gluster/glusterfs/issues/1772) build: add LTO as a configure option
[#1773](https://github.com/gluster/glusterfs/issues/1773) DHT/Rebalance - Remove unused variable dht_migrate_file
[#1779](https://github.com/gluster/glusterfs/issues/1779) Add-brick command should check hostnames with bricks present in vol
[#1825](https://github.com/gluster/glusterfs/issues/1825) Latency in io-stats should be in nanoseconds resolution, not micros
[#1872](https://github.com/gluster/glusterfs/issues/1872) Question: How to check heal info without glusterd management layer
[#1885](https://github.com/gluster/glusterfs/issues/1885) __posix_writev() - reduce memory copies and unneeded zeroing
[#1888](https://github.com/gluster/glusterfs/issues/1888) GD_OP_VERSION needs to be updated for release-10
[#1898](https://github.com/gluster/glusterfs/issues/1898) schedule_georep.py resulting in failure when used with python3
[#1909](https://github.com/gluster/glusterfs/issues/1909) core: Avoid several dict OR key is NULL message in brick logs
[#1925](https://github.com/gluster/glusterfs/issues/1925) dht_pt_getxattr does not seem to handle virtual xattrs.
[#1935](https://github.com/gluster/glusterfs/issues/1935) logging to syslog instead of any glusterfs logs
[#1943](https://github.com/gluster/glusterfs/issues/1943) glusterd-volgen: Add functionality to accept any custom xlator
[#1952](https://github.com/gluster/glusterfs/issues/1952) posix-aio: implement GF_FOP_FSYNC
[#1959](https://github.com/gluster/glusterfs/issues/1959) Broken links in the 2 replicas split-brain-issue - [Bug][Enhancemen
[#1960](https://github.com/gluster/glusterfs/issues/1960) Add missing LOCK_DESTROY() calls
[#1966](https://github.com/gluster/glusterfs/issues/1966) Can't print trace details due to memory allocation issues
[#1977](https://github.com/gluster/glusterfs/issues/1977) Inconsistent locking in presence of disconnects
[#1978](https://github.com/gluster/glusterfs/issues/1978) test case ./tests/bugs/core/bug-1432542-mpx-restart-crash.t is gett
[#1981](https://github.com/gluster/glusterfs/issues/1981) Reduce posix_fdstat() calls in IO paths
[#1991](https://github.com/gluster/glusterfs/issues/1991) mdcache: bug causes getxattr() to report ENODATA when fetching samb
[#1992](https://github.com/gluster/glusterfs/issues/1992) dht: var decommission_subvols_cnt becomes invalid when config is up
[#1996](https://github.com/gluster/glusterfs/issues/1996) Analyze if spinlocks have any benefit and remove them if not
[#2001](https://github.com/gluster/glusterfs/issues/2001) Error handling in /usr/sbin/gluster-eventsapi produces AttributeErr
[#2005](https://github.com/gluster/glusterfs/issues/2005) ./tests/bugs/replicate/bug-921231.t is continuously failing
[#2013](https://github.com/gluster/glusterfs/issues/2013) dict_t hash-calculation can be removed when hash_size=1
[#2024](https://github.com/gluster/glusterfs/issues/2024) Remove gfs_id variable or at least set to appropriate value
[#2025](https://github.com/gluster/glusterfs/issues/2025) list_del() should not set prev and next
[#2033](https://github.com/gluster/glusterfs/issues/2033) tests/bugs/nfs/bug-1053579.t fails on CentOS 8
[#2038](https://github.com/gluster/glusterfs/issues/2038) shard_unlink() fails due to no space to create marker file
[#2039](https://github.com/gluster/glusterfs/issues/2039) Do not allow POSIX IO backend switch when the volume is running
[#2042](https://github.com/gluster/glusterfs/issues/2042) mount ipv6 gluster volume with serveral backup-volfile-servers,use
[#2052](https://github.com/gluster/glusterfs/issues/2052) Revert the commit 50e953e2450b5183988c12e87bdfbc997e0ad8a8
[#2054](https://github.com/gluster/glusterfs/issues/2054) cleanup call_stub_t from unused variables
[#2063](https://github.com/gluster/glusterfs/issues/2063) Provide autoconf option to enable/disable storage.linux-io_uring du
[#2067](https://github.com/gluster/glusterfs/issues/2067) Change self-heal-window-size to 1MB by default
[#2075](https://github.com/gluster/glusterfs/issues/2075) Annotate synctasks with valgrind API if --enable-valgrind[=memcheck
[#2080](https://github.com/gluster/glusterfs/issues/2080) Glustereventsd default port
[#2083](https://github.com/gluster/glusterfs/issues/2083) GD_MSG_DICT_GET_FAILED should not include 'errno' but 'ret'
[#2086](https://github.com/gluster/glusterfs/issues/2086) Move tests/00-geo-rep/00-georep-verify-non-root-setup.t to tests/00
[#2096](https://github.com/gluster/glusterfs/issues/2096) iobuf_arena structure doesn't need passive and active iobufs, but l
[#2099](https://github.com/gluster/glusterfs/issues/2099) 'force' option does not work in the replicated volume snapshot crea
[#2101](https://github.com/gluster/glusterfs/issues/2101) Move 00-georep-verify-non-root-setup.t back to tests/00-geo-rep/
[#2107](https://github.com/gluster/glusterfs/issues/2107) mount crashes when setfattr -n distribute.fix.layout -v "yes" is ex
[#2116](https://github.com/gluster/glusterfs/issues/2116) enable quota for multiple volumes take more time
[#2117](https://github.com/gluster/glusterfs/issues/2117) Concurrent quota enable causes glusterd deadlock
[#2123](https://github.com/gluster/glusterfs/issues/2123) Implement an I/O framework
[#2129](https://github.com/gluster/glusterfs/issues/2129) CID 1445996 Null pointer dereferences (FORWARD_NULL) /xlators/mgmt/
[#2130](https://github.com/gluster/glusterfs/issues/2130) stack.h/c: remove unused variable and reorder struct
[#2133](https://github.com/gluster/glusterfs/issues/2133) Changelog History Crawl failed after resuming stopped geo-replicati
[#2134](https://github.com/gluster/glusterfs/issues/2134) Fix spurious failures caused by change in profile info duration to
[#2138](https://github.com/gluster/glusterfs/issues/2138) glfs_write() dumps a core file file when buffer size is 1GB
[#2154](https://github.com/gluster/glusterfs/issues/2154) "Operation not supported" doing a chmod on a symlink
[#2159](https://github.com/gluster/glusterfs/issues/2159) Remove unused component tests
[#2161](https://github.com/gluster/glusterfs/issues/2161) Crash caused by memory corruption
[#2169](https://github.com/gluster/glusterfs/issues/2169) Stack overflow when parallel-readdir is enabled
[#2180](https://github.com/gluster/glusterfs/issues/2180) CID 1446716: Memory - illegal accesses (USE_AFTER_FREE) /xlators/mg
[#2187](https://github.com/gluster/glusterfs/issues/2187) [Input/output error] IO failure while performing shrink operation w
[#2190](https://github.com/gluster/glusterfs/issues/2190) Move a test case tests/basic/glusterd-restart-shd-mux.t to flaky
[#2192](https://github.com/gluster/glusterfs/issues/2192) 4+1 arbiter setup is broken
[#2198](https://github.com/gluster/glusterfs/issues/2198) There are blocked inodelks for a long time
[#2216](https://github.com/gluster/glusterfs/issues/2216) Fix coverity issues
[#2232](https://github.com/gluster/glusterfs/issues/2232) "Invalid argument" when reading a directory with gfapi
[#2234](https://github.com/gluster/glusterfs/issues/2234) Segmentation fault in directory quota daemon for replicated volume
[#2239](https://github.com/gluster/glusterfs/issues/2239) rebalance crashes in dht on master
[#2241](https://github.com/gluster/glusterfs/issues/2241) Using readdir instead of readdirp for fix-layout increases performa
[#2253](https://github.com/gluster/glusterfs/issues/2253) Disable lookup-optimize by default in the virt group
[#2258](https://github.com/gluster/glusterfs/issues/2258) Provide option to disable fsync in data migration
[#2260](https://github.com/gluster/glusterfs/issues/2260) failed to list quota info after setting limit-usage
[#2268](https://github.com/gluster/glusterfs/issues/2268) dht_layout_unref() only uses 'this' to check that 'this->private' i
[#2278](https://github.com/gluster/glusterfs/issues/2278) nfs-ganesha does not start due to shared storage not ready, but ret
[#2287](https://github.com/gluster/glusterfs/issues/2287) runner infrastructure fails to provide platfrom independent error c
[#2294](https://github.com/gluster/glusterfs/issues/2294) dict.c: remove some strlen() calls if using DICT_LIST_IMP
[#2308](https://github.com/gluster/glusterfs/issues/2308) Developer sessions for glusterfs
[#2313](https://github.com/gluster/glusterfs/issues/2313) Long setting names mess up the columns and break parsing
[#2317](https://github.com/gluster/glusterfs/issues/2317) Rebalance doesn't migrate some sparse files
[#2328](https://github.com/gluster/glusterfs/issues/2328) "gluster volume set <volname> group samba" needs to include write-b
[#2330](https://github.com/gluster/glusterfs/issues/2330) gf_msg can cause relock deadlock
[#2334](https://github.com/gluster/glusterfs/issues/2334) posix_handle_soft() is doing an unnecessary stat
[#2337](https://github.com/gluster/glusterfs/issues/2337) memory leak observed in lock fop
[#2348](https://github.com/gluster/glusterfs/issues/2348) Gluster's test suite on RHEL 8 runs slower than on RHEL 7
[#2351](https://github.com/gluster/glusterfs/issues/2351) glusterd: After upgrade on release 9.1 glusterd protocol is broken
[#2353](https://github.com/gluster/glusterfs/issues/2353) Permission issue after upgrading to Gluster v9.1
[#2360](https://github.com/gluster/glusterfs/issues/2360) extras: postscript fails on logrotation of snapd logs
[#2364](https://github.com/gluster/glusterfs/issues/2364) After the service is restarted, a large number of handles are not r
[#2370](https://github.com/gluster/glusterfs/issues/2370) glusterd: Issues with custom xlator changes
[#2378](https://github.com/gluster/glusterfs/issues/2378) Remove sys_fstatat() from posix_handle_unset_gfid() function - not
[#2380](https://github.com/gluster/glusterfs/issues/2380) Remove sys_lstat() from posix_acl_xattr_set() - not needed
[#2388](https://github.com/gluster/glusterfs/issues/2388) Geo-replication gets delayed when there are many renames on primary
[#2394](https://github.com/gluster/glusterfs/issues/2394) Spurious failure in tests/basic/fencing/afr-lock-heal-basic.t
[#2398](https://github.com/gluster/glusterfs/issues/2398) Bitrot and scrub process showed like unknown in the gluster volume
[#2404](https://github.com/gluster/glusterfs/issues/2404) Spurious failure of tests/bugs/ec/bug-1236065.t
[#2407](https://github.com/gluster/glusterfs/issues/2407) configure glitch with CC=clang
[#2410](https://github.com/gluster/glusterfs/issues/2410) dict_xxx_sizen variant compilation should fail on passing a variabl
[#2414](https://github.com/gluster/glusterfs/issues/2414) Prefer mallinfo2() to mallinfo() if available
[#2421](https://github.com/gluster/glusterfs/issues/2421) rsync should not try to sync internal xattrs.
[#2429](https://github.com/gluster/glusterfs/issues/2429) Use file timestamps with nanosecond precision
[#2431](https://github.com/gluster/glusterfs/issues/2431) Drop --disable-syslog configuration option
[#2440](https://github.com/gluster/glusterfs/issues/2440) Geo-replication not working on Ubuntu 21.04
[#2443](https://github.com/gluster/glusterfs/issues/2443) Core dumps on Gluster 9 - 3 replicas
[#2446](https://github.com/gluster/glusterfs/issues/2446) client_add_lock_for_recovery() - new_client_lock() should be called
[#2467](https://github.com/gluster/glusterfs/issues/2467) failed to open /proc/0/status: No such file or directory
[#2470](https://github.com/gluster/glusterfs/issues/2470) sharding: [inode.c:1255:__inode_unlink] 0-inode: dentry not found
[#2480](https://github.com/gluster/glusterfs/issues/2480) Brick going offline on another host as well as the host which reboo
[#2502](https://github.com/gluster/glusterfs/issues/2502) xlator/features/locks/src/common.c has code duplication
[#2507](https://github.com/gluster/glusterfs/issues/2507) Use appropriate msgid in gf_msg()
[#2515](https://github.com/gluster/glusterfs/issues/2515) Unable to mount the gluster volume using fuse unless iptables is fl
[#2522](https://github.com/gluster/glusterfs/issues/2522) ganesha_ha (extras/ganesha/ocf): ganesha_grace RA fails in start()
[#2540](https://github.com/gluster/glusterfs/issues/2540) delay-gen doesn't work correctly for delays longer than 2 seconds
[#2551](https://github.com/gluster/glusterfs/issues/2551) Sometimes the lock notification feature doesn't work
[#2581](https://github.com/gluster/glusterfs/issues/2581) With strict-locks enabled clients which are holding posix locks sti
[#2590](https://github.com/gluster/glusterfs/issues/2590) trusted.io-stats-dump extended attribute usage description error
[#2611](https://github.com/gluster/glusterfs/issues/2611) Granular entry self-heal is taking more time than full entry self h
[#2617](https://github.com/gluster/glusterfs/issues/2617) High CPU utilization of thread glfs_fusenoti and huge delays in som
[#2620](https://github.com/gluster/glusterfs/issues/2620) Granular entry heal purging of index name trigger two lookups in th
[#2625](https://github.com/gluster/glusterfs/issues/2625) auth.allow value is corrupted after add-brick operation
[#2626](https://github.com/gluster/glusterfs/issues/2626) entry self-heal does xattrops unnecessarily in many cases
[#2649](https://github.com/gluster/glusterfs/issues/2649) glustershd failed in bind with error "Address already in use"
[#2652](https://github.com/gluster/glusterfs/issues/2652) Removal of deadcode: Pump
[#2659](https://github.com/gluster/glusterfs/issues/2659) tests/basic/afr/afr-anon-inode.t crashed
[#2664](https://github.com/gluster/glusterfs/issues/2664) Test suite produce uncompressed logs
[#2693](https://github.com/gluster/glusterfs/issues/2693) dht: dht_local_wipe is crashed while running rename operation
[#2771](https://github.com/gluster/glusterfs/issues/2771) Smallfile improvement in glusterfs
[#2782](https://github.com/gluster/glusterfs/issues/2782) Glustereventsd does not listen on IPv4 when IPv6 is not available
[#2789](https://github.com/gluster/glusterfs/issues/2789) An improper locking bug(e.g., deadlock) on the lock up_inode_ctx->c
[#2798](https://github.com/gluster/glusterfs/issues/2798) FUSE mount option for localtime-logging is not exposed
[#2816](https://github.com/gluster/glusterfs/issues/2816) Glusterfsd memory leak when subdir_mounting a volume
[#2835](https://github.com/gluster/glusterfs/issues/2835) dht: found anomalies in dht_layout after commit c4cbdbcb3d02fb56a62
[#2857](https://github.com/gluster/glusterfs/issues/2857) variable twice initialization.
[#2862](https://github.com/gluster/glusterfs/issues/2862) The test case ./tests/bugs/bug-1702299.t is failing the regression
[#2865](https://github.com/gluster/glusterfs/issues/2865) The test case tests/basic/0symbol-check.t is failing the regression
