#ifndef USERPARAMS_H
#define USERPARAMS_H

#include <glib.h>

#include "datatypes.h"
#include "fractal_settings.h"
#include "autolayer.h"

/*
    struct: user_params
    -------------------
    holds sets of parameters and operators, for drawing methods.
    example:
      params[0][0] operas[0][0] params[0][1] operas[0][1] params[0][2]
    may translate to: a = iter * n1 + sin(real)

    Parts of the user_params are set dependant of the usage of the
    parameter sets. That is, how the param_used arrays are set, is
    depandant on the usage of the parameter sets by the fractal settings
    or autolayer settings.
*/

typedef struct {
    dr_par   params         [MAX_PAR_SETS][USER_MAX_PARS];
    dr_op    operas         [MAX_PAR_SETS][USER_MAX_OPS];
    int      params_count   [MAX_PAR_SETS];
    gboolean param_used_frs [MAX_PAR_SETS];
    gboolean param_used_als [MAX_PAR_SETS];
    double   numbers        [MAX_NUMS];
}user_params;

void init_user_params(user_params* up);
void copy_user_params(user_params* src, user_params* dest);

/*
    function: int get_param_set_used(dr_par)
    ----------------------------------------
    param_set_used deduces from dr_par passed, the reference, if any,
    to one of the param sets.
    examples:
        PAR_ITER   ref none      > returns -1
        PAR_A      ref params[0] > returns 0
        PAR_SIN(B) ref params[1] > returns 1
        PAR_LOG(C) ref params[2] > returns 2
*/

int get_param_set_used(dr_par param);

void update_frs_used(fractal_settings* frs, user_params* ups);
void update_als_used(auto_layer* als, user_params* ups);

#endif
