#ifndef USERPARAMS_H
#include "userparams.h"

void init_user_params(user_params* up)
{
    int i,j;
    dr_par* p_par;
    dr_op*  p_op;
    for (i = 0; i < MAX_PAR_SETS; i++) {
        up->params_count  [i] = 0;
        up->param_used_frs[i] = FALSE;
        up->param_used_als[i] = FALSE;
        p_par = up->params[i];
        p_op  = up->operas[i];
        for (j = 0; j < USER_MAX_PARS; j++) {
            p_par[j] = PAR_OFF;
            if (j < USER_MAX_OPS)
                p_op[j] = OP_OFF;
        }
    }
    for (i = 0; i < MAX_NUMS; i++)
        up->numbers[i] = 0.0;
}

void copy_user_params(user_params* src, user_params* dest)
{
    int i,j;
    dr_par* dp_par;
    dr_par* sp_par;
    dr_op* dp_op;
    dr_op* sp_op;
    for (i = 0; i < MAX_PAR_SETS; i++) {
        dest->params_count  [i] = src->params_count  [i];
        dest->param_used_frs[i] = src->param_used_frs[i];
        dest->param_used_als[i] = src->param_used_als[i];
        dp_par = dest->params[i];
        dp_op  = dest->operas[i];
        sp_par = src->params[i];
        sp_op  = src->operas[i];
        for (j = 0; j < USER_MAX_PARS; j++) {
            dp_par[j] = sp_par[j];
            if (j < USER_MAX_OPS)
                dp_op[j] = sp_op[j];
        }
    }
    for (i = 0; i < MAX_NUMS; i++)
        dest->numbers[i] = src->numbers[i];
}

int get_param_set_used(dr_par param)
{
    int ps;

    if (param >= PAR_A && param < PAR_SIN_A)
        ps = param - PAR_A;
    else if (param >= PAR_SIN_A && param < PAR_LOG_A)
        ps = (param - PAR_SIN_A) / 2;
    else if (param >= PAR_LOG_A && param < PAR_N1)
        ps = (param - PAR_LOG_A);
    else 
        ps = -1;

    return ps;
}

/*
    The following two functions duplicate code from user_dlg.c.
    I had not taken into account that not everything set within
    user_params was dependant on the user parameters dialog.
*/

void update_frs_used(fractal_settings* frs, user_params* ups)
{
    gboolean stop_frs_check = TRUE;
    int i, j;
    int pset;
    dr_par par1, par2;
    dr_par* p_par;
    dr_op* p_ope;
    for (i = 0; i < MAX_PAR_SETS; i++)
        ups->param_used_frs[i] = FALSE;
    par1 = frs->in_par;
    par2 = frs->out_par;
    pset = get_param_set_used(par1);
    if (pset >= 0) {
        ups->param_used_frs[pset] = TRUE;
        stop_frs_check = FALSE;
    }
    pset = get_param_set_used(par2);
    if (pset >= 0) {
        ups->param_used_frs[pset] = TRUE;
        stop_frs_check = FALSE;
    }
    /* check params for usage of user params */
    while (stop_frs_check == FALSE) {
        stop_frs_check = TRUE;
        for (i = 0; i < MAX_PAR_SETS; i++) {
            par1 = PAR_A + i;
            p_par = ups->params[i];
            p_ope = ups->operas[i];
            if (ups->param_used_frs[i] == TRUE) {
                /* found a param set in use, does it use another? */
                for (j = 0; j < ups->params_count[i]; j++) {
                    par2 = p_par[j];
                    pset = get_param_set_used(par2);
                    if (pset >= 0 
                        && ups->param_used_frs[pset] == FALSE)
                    {
                        ups->param_used_frs[pset] = TRUE;
                        if (pset < i)
                            stop_frs_check = FALSE;
                    }
                }
            }
        }
    }
}

void update_als_used(auto_layer* als, user_params* ups)
{
    gboolean stop_als_check = TRUE;
    int i, j;
    int pset;
    dr_par par1, par2;
    dr_par* p_par;
    dr_op* p_ope;
    for (i = 0; i < MAX_PAR_SETS; i++)
        ups->param_used_als[i] = FALSE;
    par1 = als->in_par;
    par2 = als->out_par;
    pset = get_param_set_used(par1);
    if (pset >= 0) {
        ups->param_used_als[pset] = TRUE;
        stop_als_check = FALSE;
    }
    pset = get_param_set_used(par2);
    if (pset >= 0) {
        ups->param_used_als[pset] = TRUE;
        stop_als_check = FALSE;
    }
    /* check params for usage of user params */
    while (stop_als_check == FALSE) {
        stop_als_check = TRUE;
        for (i = 0; i < MAX_PAR_SETS; i++) {
            par1 = PAR_A + i;
            p_par = ups->params[i];
            p_ope = ups->operas[i];
            if (ups->param_used_als[i] == TRUE) {
                /* found a param set in use, does it use another? */
                for (j = 0; j < ups->params_count[i]; j++) {
                    par2 = p_par[j];
                    pset = get_param_set_used(par2);
                    if (pset >= 0 
                        && ups->param_used_als[pset] == FALSE)
                    {
                        ups->param_used_als[pset] = TRUE;
                        if (pset < i)
                            stop_als_check = FALSE;
                    }
                }
            }
        }
    }
}


#endif
