#ifndef USER_DLG_H
#define USER_DLG_H

#include "gtk/gtk.h"

#include "userparams.h"

#include "fractal_types.h"

typedef struct {
    GtkWidget* dialog;

    GtkWidget* params       [MAX_PAR_SETS][USER_MAX_PARS];
    GtkWidget* operas       [MAX_PAR_SETS][USER_MAX_OPS];

    GtkWidget* numbers      [MAX_NUMS];

    int       params_count  [MAX_PAR_SETS];
    gboolean  param_used_frs[MAX_PAR_SETS];
    gboolean  param_used_als[MAX_PAR_SETS];
    gboolean  num_used      [MAX_NUMS];

    GtkWidget* pars_frame   [MAX_PAR_SETS];
    GtkWidget* nums_frame   [MAX_NUMS];

    GtkWidget* par_frame;
    GtkWidget* num_frame;

    GtkWidget* ok_button;
    GtkWidget* apply_button;

    /* aid with dialog update */
    user_params*      user_ptr;
    fractal_settings* frac_ptr;
    auto_layer*       auto_ptr;

} user_attr_dialog;

/* create user parameters dialog */
void user_dlg_new(user_attr_dialog** ptr, image_info* img);

/* get user params from ups, and put into dialog */
void user_dlg_set(user_params* ups, user_attr_dialog* dl);

/* update dialog to reflect changes to fractal/autolayer settings */
void user_dlg_update(user_attr_dialog* dl);

/* get user params from dialog dl, and put into ups */
void get_user_params(user_params* ups, user_attr_dialog* dl);

#endif
