#ifndef USER_DLG_H
#include "user_dlg.h"

#include <stdlib.h>
#include <stdio.h>

#define MAX_LABEL_LEN 12
/*#define DRAW_HEIGHT (USER_MAX_PARS * 2)*/

#define NUM_ROWS 2
#define NUM_COLS (MAX_NUMS / NUM_ROWS)

enum {
    NO_COLUMN,
    NAME_COLUMN,
    N_COLUMNS
};

static void user_attr_destroy(GtkWidget* widget, user_attr_dialog* dl);
static void create_param_table(int pset, GtkTable* table, 
                               user_attr_dialog* dl, 
                               GtkListStore* plist, 
                               GtkListStore* olist);
static void update_user_dialog(GtkWidget* widget, user_attr_dialog* dl);
static void update_param_counts(GtkWidget* widget, user_attr_dialog* dl);
static void set_user_dialog_sens(int pset, user_attr_dialog * dl);

void user_dlg_new(user_attr_dialog** ptr, image_info* img)
{
    user_attr_dialog* dl;
    /* dialog layout */
    GtkWidget* vbox = 0;
    /* user parameters (vbox_r) */
    GtkWidget* par_frame = 0;
    GtkWidget* par_hbox  = 0;
    GtkWidget* pars_frame[MAX_PAR_SETS];
    GtkWidget* pars_table[MAX_PAR_SETS];
    /* numbers - (vbox) */    
    GtkWidget* num_frame= 0;
    GtkWidget* num_table = 0;
    GtkWidget* nums_frame[MAX_NUMS];
    /* list stores for combo boxes */
    GtkListStore* par_list = 0;
    GtkListStore* op_list  = 0;
    GtkTreeIter   par_iter;
    GtkTreeIter   op_iter;
    /* misc */
    GtkWidget* tmp = 0;
    GtkObject* adj = 0;
    guint i, x = 0, y = 0;
    char buf[MAX_LABEL_LEN];

    dl = g_malloc(sizeof(user_attr_dialog));
    *ptr = dl;
    dl->frac_ptr = &img->frac_settings;
    dl->user_ptr = &img->user_settings;
    dl->auto_ptr = &img->auto_settings;

    /* create a list store containing the parameter + operator names */
    par_list = gtk_list_store_new(N_COLUMNS,G_TYPE_INT, G_TYPE_STRING);
    op_list = gtk_list_store_new(N_COLUMNS, G_TYPE_INT, G_TYPE_STRING);
    for (i = 0; i < PAR_COUNT; i++) {
        gtk_list_store_append(par_list, &par_iter);
        gtk_list_store_set(par_list, &par_iter, NO_COLUMN, i,
                            NAME_COLUMN, draw_par_names[i], -1);
    }
    for (i = 0; i < OP_COUNT; i++) {
        gtk_list_store_append(op_list, &op_iter);
        gtk_list_store_set(op_list, &op_iter, NO_COLUMN, i,
                            NAME_COLUMN, draw_op_names[i], -1);
    }
    /* DIALOGOOREA */
    dl->dialog = gtk_dialog_new();
    g_signal_connect(GTK_OBJECT(dl->dialog), "destroy",
                            G_CALLBACK(user_attr_destroy), dl);
    g_signal_connect(GTK_OBJECT(dl->dialog), "destroy",
                            G_CALLBACK(gtk_widget_destroyed), ptr);
    gtk_window_set_title(GTK_WINDOW(dl->dialog), "User Parameters");
    gtk_window_set_resizable(GTK_WINDOW(dl->dialog), FALSE);
    gtk_window_set_position(GTK_WINDOW(dl->dialog), GTK_WIN_POS_MOUSE);

    /* BUTTONS */
    dl->ok_button = gtk_button_new_with_label("OK");
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dl->dialog)->action_area),
                            dl->ok_button,   TRUE, TRUE, 0);
    dl->apply_button = gtk_button_new_with_label("Apply");
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dl->dialog)->action_area),
                            dl->apply_button,TRUE, TRUE, 0);
    tmp = gtk_button_new_with_label("Dismiss");
    g_signal_connect_object(GTK_OBJECT(tmp), "clicked",
                            G_CALLBACK(gtk_widget_destroy),
                            GTK_OBJECT(dl->dialog), G_CONNECT_SWAPPED);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dl->dialog)->action_area), 
                            tmp, TRUE, TRUE, 0);

    /* big top level main box, needs super-gun to defeat */

    vbox   = gtk_vbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dl->dialog)->vbox),
                            vbox,   TRUE, TRUE, 0);

    /* I need more coffee! */

    par_frame = gtk_frame_new("User Parameters");
    num_frame = gtk_frame_new("User Constants");
    gtk_container_set_border_width(GTK_CONTAINER(par_frame), 4);
    gtk_container_set_border_width(GTK_CONTAINER(num_frame), 4);
    gtk_container_add(GTK_CONTAINER(vbox), par_frame);
    gtk_container_add(GTK_CONTAINER(vbox), num_frame);
    dl->par_frame = par_frame;
    dl->num_frame = num_frame;

    par_hbox = gtk_hbox_new(FALSE, 0);
    gtk_container_add(GTK_CONTAINER(par_frame), par_hbox);

    /* user params - bottom level frame + table * n */
    for (i = 0; i < MAX_PAR_SETS; i++) {
        snprintf(buf, MAX_LABEL_LEN, "%s", draw_par_names[PAR_A + i]);
        pars_frame[i] = gtk_frame_new(buf);
        pars_table[i] = gtk_table_new(1, 1, FALSE);
        gtk_container_set_border_width(GTK_CONTAINER(pars_frame[i]),4);
        gtk_container_set_border_width(GTK_CONTAINER(pars_table[i]), 4);
        gtk_table_set_row_spacings(GTK_TABLE(pars_table[i]), 4);
        gtk_table_set_col_spacings(GTK_TABLE(pars_table[i]), 4);
        gtk_box_pack_start(GTK_BOX(par_hbox),pars_frame[i],TRUE,TRUE,0);
        gtk_container_add(GTK_CONTAINER(pars_frame[i]), pars_table[i]);
        dl->pars_frame[i] = pars_frame[i];
    }

    /* numb tab */
    num_table = gtk_table_new(NUM_ROWS, NUM_COLS, FALSE);
    gtk_container_set_border_width(GTK_CONTAINER(num_table), 4);
    gtk_table_set_row_spacings(GTK_TABLE(num_table), 4);
    gtk_table_set_col_spacings(GTK_TABLE(num_table), 4);
    gtk_container_add(GTK_CONTAINER(num_frame), num_table);

    /* user constants */
    x = 0; y = 0;
    for (i = 0; i < MAX_NUMS; i++) {
        snprintf(buf, MAX_LABEL_LEN, "%s", draw_par_names[PAR_N1 + i]);
        nums_frame[i] = gtk_frame_new(buf);
        gtk_table_attach_defaults(GTK_TABLE(num_table), nums_frame[i],
                                  x, x + 1, y, y + 1);
        adj = gtk_adjustment_new(dl->user_ptr->numbers[i],
                                 -999999.0, 999999.0,
                                 0.0078125, 0.0078125, 0.0);
        tmp = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 0.0, 12.0);
        gtk_container_add(GTK_CONTAINER(nums_frame[i]), tmp);
        dl->numbers[i] = tmp;
        dl->nums_frame[i] = nums_frame[i];
        x++;
        if (x >= NUM_COLS) {
            x = 0;
            y++;
        }
    }

    /* user param sets */
    for (i = 0; i < MAX_PAR_SETS; i++)
        create_param_table(i, GTK_TABLE(pars_table[i]),
                           dl, par_list, op_list);

    /* The beginning of the end... */
    update_user_dialog(NULL, dl);
    gtk_widget_show_all(dl->dialog);
}

void user_dlg_set(user_params* ups, user_attr_dialog* dl)
{
    int i, j;
    dr_par* p_par;
    dr_op* p_ope;
    GtkWidget** p_dpar;
    GtkWidget** p_dope;
    /* set combo boxes to user params and operators */
    for (i = 0; i < MAX_PAR_SETS; i++) {
        dl->params_count[i] = ups->params_count[i];
        dl->param_used_frs[i] = ups->param_used_frs[i];
        dl->param_used_als[i] = ups->param_used_als[i];
        p_par  = ups->params[i];
        p_ope  = ups->operas[i];
        p_dpar = dl->params[i];
        p_dope = dl->operas[i];
        for (j = 0; j < USER_MAX_PARS; j++) {
            gtk_combo_box_set_active(GTK_COMBO_BOX(p_dpar[j]), p_par[j]);
            if (j < USER_MAX_OPS) 
                gtk_combo_box_set_active(GTK_COMBO_BOX(p_dope[j]),
                                                               p_ope[j]);
        }
    }
    /* set combo boxes to numerical constants */
    for (i = 0; i < MAX_NUMS; i++)
        gtk_spin_button_set_value(GTK_SPIN_BUTTON(dl->numbers[i]),
                                                        ups->numbers[i]);
}

void user_dlg_update(user_attr_dialog* dl)
{
    update_user_dialog(NULL, dl);
}

void get_user_params(user_params* ups, user_attr_dialog* dl)
{
    int i, j;
    dr_par* p_par;
    dr_op* p_ope;
    GtkWidget** p_dpar;
    GtkWidget** p_dope;
    /* get user params and operators */
    for (i = 0; i < MAX_PAR_SETS; i++) {
        ups->params_count  [i] = dl->params_count  [i];
        ups->param_used_frs[i] = dl->param_used_frs[i];
        ups->param_used_als[i] = dl->param_used_als[i];
        #ifdef DEBUG_PAR
        printf("\nparams_count[%d] = %d", i, ups->params_count[i]);
        printf("\n\tparam_used_by_fractal[%d] - ", i);
        if (ups->param_used_frs[i] == TRUE) 
            printf("Yes"); else printf("No");
        printf("\n\tparam_used_by_auto_layer[%d] - ", i);
        if (ups->param_used_als[i] == TRUE) 
            printf("Yes"); else printf("No");
        #endif
        p_par  = ups->params[i];
        p_dpar = dl->params [i];
        p_ope  = ups->operas[i];
        p_dope = dl->operas [i];
        #ifdef DEBUG_PAR
        printf("\nGetting params from param_set %d...", i);
        #endif
        for (j = 0; j < USER_MAX_PARS; j++) {
            p_par[j] = gtk_combo_box_get_active(GTK_COMBO_BOX(p_dpar[j]));
            if (j < USER_MAX_OPS) p_ope[j] = 
                gtk_combo_box_get_active(GTK_COMBO_BOX(p_dope[j]));
            #ifdef DEBUG_PAR
            printf("\n\t ..[%d] > %s", j, draw_par_names[p_par[j]]);
            if (j < USER_MAX_OPS)
                printf("\t%s", draw_op_names[p_ope[j]]);
            #endif
        }
    }
    /* get numerical constants */
    for (i = 0; i < MAX_NUMS; i++)
        ups->numbers[i] = gtk_spin_button_get_value(
                        GTK_SPIN_BUTTON(dl->numbers[i]));
}

static void user_attr_destroy(GtkWidget* widget, user_attr_dialog* dl)
{
    g_free(dl);
}

static void create_param_table(int pset, GtkTable* table, 
                               user_attr_dialog* dl, 
                               GtkListStore* plist, 
                               GtkListStore* olist)
{
    GtkCellRenderer* renderer = 0;
    GtkWidget** p_dpar = dl->params[pset];
    GtkWidget** p_dope = dl->operas[pset];
    GtkWidget* combo = 0;
    dr_par* p_par = dl->user_ptr->params[pset];
    dr_op*  p_ope = dl->user_ptr->operas[pset];
    guint i, y = 0;
    
    for (i = 0; i < USER_MAX_PARS; i++) {
        y++;
        combo = gtk_combo_box_new_with_model(GTK_TREE_MODEL(plist));
        gtk_combo_box_set_active(GTK_COMBO_BOX(combo), p_par[i]);
        renderer = gtk_cell_renderer_text_new();
        gtk_cell_layout_pack_start(GTK_CELL_LAYOUT(combo),renderer,FALSE);
        gtk_cell_layout_set_attributes(GTK_CELL_LAYOUT(combo), 
                                       renderer, "text", 1, NULL);
        gtk_table_attach_defaults(GTK_TABLE(table), combo, 
                                        0, 1, y, y + 1);
        g_signal_connect(GTK_OBJECT(combo), "changed",
                       G_CALLBACK(update_user_dialog), dl);
        p_dpar[i] = combo;
        y++;
        if (i < USER_MAX_OPS) {
            /* operator combo boxes */
            combo = gtk_combo_box_new_with_model
                        (GTK_TREE_MODEL(olist));
            gtk_combo_box_set_active(GTK_COMBO_BOX(combo),p_ope[i]);
            renderer = gtk_cell_renderer_text_new();
            gtk_cell_layout_pack_start(GTK_CELL_LAYOUT(combo), 
                                       renderer, FALSE);
            gtk_cell_layout_set_attributes(GTK_CELL_LAYOUT(combo), 
                                           renderer, "text", 1, NULL);
            gtk_table_attach_defaults(GTK_TABLE(table), combo,
                                        0, 1, y, y + 1);
            g_signal_connect(GTK_OBJECT(combo), "changed",
                           G_CALLBACK(update_user_dialog), dl);
            p_dope[i] = combo;
        }
    }
}

static void update_user_dialog(GtkWidget* widget, user_attr_dialog* dl)
{
    gboolean pframe = FALSE;
    gboolean nframe = FALSE;
    gboolean stop_frs_check = TRUE;
    gboolean stop_als_check = TRUE;
    int i, j, nn, n[4];
    int pset;
    dr_par par1, par2;
    GtkWidget** p_par;
    GtkWidget** p_ope;

    /* reset ???_is_used[?] */
    for (i = 0; i < MAX_PAR_SETS; i++) {
        dl->param_used_frs[i] = FALSE;
        dl->param_used_als[i] = FALSE;
    }
    for (i = 0; i < MAX_NUMS; i++) dl->num_used[i] = FALSE;

    /* check if auto layer settings are in use... */
    par1 = dl->auto_ptr->in_par;
    par2 = dl->auto_ptr->out_par;
    pset = get_param_set_used(par1);
    if (pset >= 0) {
        dl->param_used_als[pset] = TRUE;
        pframe = TRUE;
        stop_als_check = FALSE;
    }
    pset = get_param_set_used(par2);
    if (pset >= 0) {
        dl->param_used_als[pset] = TRUE;
        pframe = TRUE;
        stop_als_check = FALSE;
    }

    n[0] = par1 - PAR_N1;
    n[1] = par2 - PAR_N1;

    /* check for usage of param set */
    par1 = dl->frac_ptr->in_par;
    par2 = dl->frac_ptr->out_par;
    pset = get_param_set_used(par1);
    if (pset >= 0) {
        dl->param_used_frs[pset] = TRUE;
        pframe = TRUE;
        stop_frs_check = FALSE;
    }
    pset = get_param_set_used(par2);
    if (pset >= 0) {
        dl->param_used_frs[pset] = TRUE;
        pframe = TRUE;
        stop_frs_check = FALSE;
    }

/*  (Un)comment this is you think it's really important that the user
    should not be able to mess about with the params without them
    being used by anything ... */

/*  gtk_widget_set_sensitive(dl->param_frame, pframe);  */

/* what's all that about then ? -jwm 17/11/2006 */

    /* check for number usage */
    n[2] = par1 - PAR_N1;
    n[3] = par2 - PAR_N1;
    for (i = 0; i < 4; i++) {
        if (n[i] >= 0) {
            nframe = TRUE;
            dl->num_used[n[i]] = TRUE;
        }
    }
    update_param_counts(widget, dl);
    /* check params used by std for usage of user params */
    while (stop_frs_check == FALSE) {
        stop_frs_check = TRUE;
        for (i = 0; i < MAX_PAR_SETS; i++) {
            par1 = PAR_A + i;
            p_par = dl->params[i];
            p_ope = dl->operas[i];
            if (dl->param_used_frs[i] == TRUE) {
                /* found a param set in use, does it use another? */
                for (j = 0; j < dl->params_count[i]; j++) {
                    par2 = gtk_combo_box_get_active(
                            GTK_COMBO_BOX(p_par[j]));
                    pset = get_param_set_used(par2);
                    if (pset >= 0 
                        && dl->param_used_frs[pset] == FALSE)
                    {
                        dl->param_used_frs[pset] = TRUE;
                        if (pset < i)
                            stop_frs_check = FALSE;
                    }
                    nn = par2 - PAR_N1;
                    if (nn >= 0) {
                        nframe = TRUE;
                        dl->num_used[nn] = TRUE;
                    }
                }
            }
        }
    }
    /* check params used by autolayer for usage of user params */
    while (stop_als_check == FALSE) {
        stop_als_check = TRUE;
        for (i = 0; i < MAX_PAR_SETS; i++) {
            par1 = PAR_A + i;
            p_par = dl->params[i];
            p_ope = dl->operas[i];
            if (dl->param_used_als[i] == TRUE) {
                /* found a param set in use, does it use another? */
                for (j = 0; j < dl->params_count[i]; j++) {
                    par2 = gtk_combo_box_get_active(
                            GTK_COMBO_BOX(p_par[j]));
                    pset = get_param_set_used(par2);
                    if (pset >= 0
                        && dl->param_used_als[pset] == FALSE)
                    {
                        dl->param_used_als[pset] = TRUE;
                        if (pset < i)
                            stop_als_check = FALSE;
                    }
                    nn = par2 - PAR_N1;
                    if (nn >= 0) {
                        nframe = TRUE;
                        dl->num_used[nn] = TRUE;
                    }
                }
            }
        }
    }
    /* now make sensitive or not, that which we now know is in use... */
    gtk_widget_set_sensitive(dl->num_frame, nframe);
    for (i = 0; i < MAX_PAR_SETS; i++) {
        if (dl->param_used_frs[i] == TRUE
            || dl->param_used_als[i] == TRUE)
        {
            gtk_widget_set_sensitive(dl->pars_frame[i], TRUE);
            set_user_dialog_sens(i, dl);
        }
        else
            gtk_widget_set_sensitive(dl->pars_frame[i], FALSE);
    }
    for (i = 0; i < MAX_NUMS; i++) {
        if (dl->num_used[i] == TRUE)
            gtk_widget_set_sensitive(dl->nums_frame[i], TRUE);
        else
            gtk_widget_set_sensitive(dl->nums_frame[i], FALSE);
    }
}

static void update_param_counts(GtkWidget* widget, user_attr_dialog* dl)
{
    GtkWidget* tmp = 0;
    gboolean nomore;
    GtkWidget** p_par = 0;
    GtkWidget** p_ope = 0;

    int i, j;
    for (i = 0; i < MAX_PAR_SETS; i++) {
        p_par = dl->params[i];
        p_ope = dl->operas[i];
        nomore = FALSE;
        for (j = 0; j < USER_MAX_PARS; j++) {
            if (nomore == FALSE) {
                if (gtk_combo_box_get_active(
                    GTK_COMBO_BOX(p_par[j])) == PAR_OFF) {
                    nomore = TRUE;
                    dl->params_count[i] = j;
                }
                else { /* param is not off */
                    if (j < USER_MAX_OPS) {
                        if (gtk_combo_box_get_active(
                            GTK_COMBO_BOX(p_ope[j])) == OP_OFF) {
                            /* operator is off */
                            nomore = TRUE;
                            dl->params_count[i] = j + 1;
                        }
                        else if (widget != NULL){
                            /* (operator is not off) */
                            tmp = p_par[j + 1];
                            if (gtk_combo_box_get_active(
                                GTK_COMBO_BOX(tmp)) == PAR_OFF)
                            {   /* next parameter (tmp) is off */
                                if (widget == tmp) {
                                /* user turned next parameter off. */
                                    gtk_combo_box_set_active(
                                            GTK_COMBO_BOX(p_ope[j]), 
                                            OP_OFF);
                                } 
                                else if (widget == p_ope[j]) {
                                    gtk_combo_box_set_active(
                                        GTK_COMBO_BOX(tmp), PAR_Z);
                                }
                            }
                        }
                    }
                    else {
                        nomore = TRUE;
                        dl->params_count[i] = USER_MAX_PARS;
                    }
                }
            }
        }
    }
}

static void set_user_dialog_sens(int pset, user_attr_dialog * dl)
{
    GtkWidget** p_par = 0;
    GtkWidget** p_ope = 0;
    int i;
    #ifdef DEBUG_PAR
    printf("\nset_draw_dialog_sens(%d)", pset);
    printf("\nparam count is %d", dl->params_count[pset]);
    #endif
    p_par = dl->params[pset];
    p_ope = dl->operas[pset];
    for (i = 0; i < USER_MAX_PARS; i++) {
        #ifdef DEBUG_PAR
        printf("\n(in)sensitive i = %d",i);
        #endif
        if (i < dl->params_count[pset]) {
            gtk_widget_set_sensitive(p_par[i], TRUE);
            if (i < USER_MAX_OPS) {
                gtk_widget_set_sensitive(p_ope[i], TRUE);
            }
        }
        else {
            gtk_widget_set_sensitive(p_par[i], FALSE);
            if (i < USER_MAX_OPS) {
                gtk_widget_set_sensitive(p_ope[i], FALSE);
            }
        }
    }
    gtk_widget_set_sensitive(p_par[0], TRUE);
}

#endif
