#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <gtk/gtk.h>
#include "externs.h"
#include "palette.h"
#include "gkIIfile.h"
#include "misc.h"

extern GtkWidget* window;

int gkII_open_file(image_info* img, char* filename)
{
    FILE* fp;
    imginfo fstr;
    char gkIIid[9];
    guint32* newpal = 0;
    printf("\n\t[debug] Reading gkII file...");
    fp = fopen(filename, "r");
    if (fp == NULL) {
        fprintf(stderr, "Can't open file %s: %s\n", filename,
                strerror(errno));
        return -1;
    }
    fread(&fstr, sizeof(imginfo), 1, fp);
    strncpy(gkIIid, fstr.gkIIid, 8);
    gkIIid[8] = 0;
    if (!strcmp(gkIIid, "gkIIdata") == 0) {
        fprintf(stderr, "File: %s is not a gkII data file.", filename);
        return -2;
    }
    printf("\n\t[debug] Read image info portion...");
    fread(&img->frac_settings, sizeof(fractal_settings), 1, fp);
    printf("\n\t[debug] Read fractal settings...");
    fread(&img->auto_settings, sizeof(auto_layer), 1, fp);
    printf("\n\t[debug] Read auto layer portion...");
    fread(&img->user_settings, sizeof(user_params), 1, fp);
    printf("\n\t[debug] Read user parameters...\n");
    
    if (!(newpal = g_malloc(256* sizeof(guint32))))
        fprintf(stderr, "Out of memory to load colour palette from file %s what a crying shame!", filename);
    else {
        int cip;
        if ((cip = fread(newpal, sizeof(guint32), 256, fp)) < 256)
        {
            fprintf(stderr, "Failed to read entire colour palette from file %s, we got %d instead of 256", filename, cip);
        }
        else {
            g_free(palette);
            palette = newpal;
            printf("\n\t[debug] Read colour palette...\n");
        }
    }
    if (!fread(img->rnd_pal, sizeof(random_palette), 1, fp)) {
        fprintf(stderr, "Failed to read random palette info, could be older gkII-0.4 in which this was not available.");
    }
    fclose(fp);
    set_image_info(img,
        fstr.user_width, fstr.user_height, fstr.aa_factor);
    filestr_to_imagestr(&fstr, img);
    return 0;
}

int gkII_save_file(image_info* img, char* filename)
{
    FILE* fp;
    imginfo fstr;
    strncpy(fstr.gkIIid, "gkIIdata", 8);
    printf("\n\t[debug] Saving gkII file...");
    fp = fopen(filename, "w");
    if (fp == NULL) {
        fprintf(stderr, "Can't open file %s: %s\n", filename,
                strerror(errno));
        return -1;
    }
    imagestr_to_filestr(img, &fstr);
    fwrite(&fstr, sizeof(imginfo), 1, fp);
        printf("\n\t[debug] Written image info portion...");
    fwrite(&img->frac_settings, sizeof(fractal_settings), 1, fp);
        printf("\n\t[debug] Written fractal settings...");
    fwrite(&img->auto_settings, sizeof(auto_layer), 1, fp);
        printf("\n\t[debug] Written auto layer portion...");
    fwrite(&img->user_settings, sizeof(user_params), 1, fp);
        printf("\n\t[debug] Written user parameters...\n");
    fwrite(palette, sizeof(guint32), 256, fp);
        printf("\n\t[debug] Written colour palette...\n");
    fwrite(img->rnd_pal, sizeof(random_palette), 1, fp);
        printf("\n\t[debug] Written random palette info...\n");
    fclose(fp);
    return 0;
}

/* write palette */
/*
    if (pal) {
        png_pal = g_malloc(sizeof(png_color)*pal_indexes);
        for (i=0; i < pal_indexes; i++) {
            png_pal[i].red = RED(palette[i]);
            png_pal[i].green = GREEN(palette[i]);
            png_pal[i].blue = BLUE(palette[i]);
        }
        png_set_PLTE(png_ptr, info_ptr, png_pal, pal_indexes);
    }

    png_write_info(png_ptr, info_ptr);
    if (!pal)
        png_set_filler(png_ptr, 0, PNG_FILLER_AFTER);
*/

/* convert data to palette index format */
/*
    if (pal) {
        int pixels = img->user_width * img->user_height;
        guchar* dst;
        double* src;
        pal_data = g_malloc(pixels);
        dst = pal_data;
        src = img->raw_data;
        for (i=0; i < pixels; i++) {
            if ((*src) >= UINT_MAX)
                *dst = 0;
            else
                *dst = (guint32)(*src) % (pal_indexes-1);
            src++;
            dst++;
        }
    }
*/

void do_gkII_save(image_info* img)
{
    GtkWidget* dialog =
        gtk_file_chooser_dialog_new("Save as gkII File",
                        (GtkWindow*)window,
                        GTK_FILE_CHOOSER_ACTION_SAVE,
                        GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
                        GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT,
                        NULL);
    gtk_file_chooser_set_do_overwrite_confirmation (
                        GTK_FILE_CHOOSER (dialog), TRUE);
    if (gtk_dialog_run(GTK_DIALOG(dialog)) == GTK_RESPONSE_ACCEPT)
    {
        char *filename;
        filename = gtk_file_chooser_get_filename(
                        GTK_FILE_CHOOSER(dialog));
        gkII_save_file(img, filename);
        g_free(filename);
    }
    gtk_widget_destroy (dialog); 
}
