#ifndef __FRACTAL_TYPES_H
#define __FRACTAL_TYPES_H

#include <stdlib.h>
#include <gtk/gtk.h>

#include "fractal_settings.h"
#include "autolayer.h"
#include "userparams.h"
#include "random_palette.h"

typedef struct {
    long double c_re;
    long double c_im;
} julia_info;

typedef enum {
    MANDELBROT, JULIA
} fractal_type;

typedef struct {
    long double xmin,xmax,ymax; /* <-coordinates    */
    /* saved mandel coords.                         */
    /* we need these when  switching back from      */
    /* julia mode                                   */
    long double old_xmin, old_xmax, old_ymax;
    int depth;                  /* <-recursion depth */
    int lines_done;
    int idle_id;                /* <-our idle callback function id */
    double* raw_data;           /* <-actual data pointers */
    guint32* rgb_data;
    gboolean j_pre;             /* TRUE if we're a julia preview */
    GtkWidget* drawing_area;    /* it's handy to keep this around */
    GtkWidget* filesel;         /* handy andy doge the bodge */
    random_palette* rnd_pal;    /* again... it's handy */
    int real_width;             /* real size. differs from user_size */ 
    int real_height;            /* if anti-aliasing is used */
    int user_width;
    int user_height;
    double ratio;               /* width/height ratio */
    int aa_factor;
    fractal_type fr_type;       /* mandelbrot || julia */
    /* fractal and auto layer settings */
    fractal_settings    frac_settings;
    auto_layer          auto_settings;
    user_params         user_settings;
    gboolean method;    /* true = draw std mandy/julia regardless */
                        /* false = do as user say */
    union {             /* different fractal types' parameters */
        julia_info julia;
    } u;
    gboolean palette_ip;
    gboolean zoom_new_win;
} image_info;

typedef struct {
    char gkIIid[8];
    long double xmin,xmax,ymax;
    long double old_xmin, old_xmax, old_ymax;
    int depth;
    gboolean j_pre;
    int real_width;
    int real_height;
    int user_width;
    int user_height;
    double ratio;
    int aa_factor;
    fractal_type fr_type;
    gboolean method; 
    union {
        julia_info julia;
    } u;
    gboolean palette_ip;
/*  gboolean zoom_new_win; */
} imginfo;

void fractal_next_line(image_info* img);
void filestr_to_imagestr(imginfo* fstr, image_info* istr);
void imagestr_to_filestr(image_info* istr, imginfo* fstr);

#endif /* __FRACTAL_TYPES_H */
