#ifndef FRACTAL_SETTINGS_H
#define FRACTAL_SETTINGS_H

#include "datatypes.h"

typedef struct
{
    dr_par  in_par;
    dr_par  out_par;
    double  in_scale;
    double  out_scale;
    kunge_type  kunge;
    bail_type   bail;
    double bail_value;
    double re_pert;
    double im_pert;
} fractal_settings;

void init_fractal_settings(fractal_settings* fs);
void copy_fractal_settings(fractal_settings* src, fractal_settings* dest);

#endif
