#ifndef FRACTAL_SETTINGS_H
#include "fractal_settings.h"

void init_fractal_settings(fractal_settings* fs)
{
    if (fs == NULL)
        return;
    fs->in_par = PAR_OFF;
    fs->out_par = PAR_Z;
/*    fs->out_par = PAR_KZ;*/
    fs->in_scale = 1.0;
    fs->out_scale = 1.0;
    fs->kunge = KT_OFF;
    fs->bail = BT_MAND;
/*    fs->kunge = KT_XR2;  */
/*    fs->bail = BT_KUNGE; */
    fs->bail_value = 4.0;
    fs->re_pert = 0.0;
    fs->im_pert = 0.0;
}

void copy_fractal_settings(fractal_settings* src, fractal_settings* dest)
{
    if (src == NULL || dest == NULL)
        return;
    dest->in_par = src->in_par;
    dest->out_par = src->out_par;
    dest->in_scale = src->in_scale;
    dest->out_scale = src->out_scale;
    dest->kunge = src->kunge;
    dest->bail = src->bail;
    dest->bail_value = src->bail_value;
    dest->re_pert = src->re_pert;
    dest->im_pert = src->im_pert;
}

#endif
