#ifndef __FRACTAL_TYPES_H
#include "fractal_types.h"

#include <math.h>
#include "externs.h"

/* just for printf which will be removed */
#include <stdio.h>

/* calculate next line of the fractal */

/*  It potentially could be calculating a huge number of fractals.
    With exception of pure m-set plotting, it will at minimum always 
    calculate two fractals - the m-set, and the klunged m-set.  Unless
    you turn them both off in which case it will do sweet jack.

    To do this it uses several sets of the mandelbrot variable set:
        z, im, re, im2, re2

    working set     -   w
    mandelbrot set  -   m
    klunge set      -   k
    working klunge  -   wk      (w/o m of im, w/o e of re)

    int dobail == 

         2  - neither mandel or munge have bailed
         1  - either mandel or munge have bailed
         0  - both mandel and munge have bailed

    mbail == TRUE - mandelbrot bailed
    kbail == TRUE - kungelbrot bailed
-------------------------------------------------------------------*/

void fractal_next_line(image_info* img)
{
    int ix;
    long double x,y;
    long double x2, y2;
    long double c_re = 0, c_im = 0;

    /* Working */
    int wz;  
    long double wre,  wim;
    long double wre2, wim2;
    /* ... working klunge */
    long double wkr,  wki;
    long double wkr2, wki2;
    long double wkf,  wkf2;

    /* Mandelbrot */
    double mz;
    long double mre = 0,    mim = 0;
    long double mre2 = 0,   mim2 = 0;

    /*  Kunge usually bails before mandelbrot,
        these capture the mandelbrots real & imaginary
        values at that point */
    long double lre = 0,    lim = 0;
    long double lre2 = 0,   lim2 = 0;

    /* Kunge */
    long double tmp1, tmp2;
    double kz;
    long double kre = 0,    kim = 0;
    long double kre2 = 0,   kim2 = 0;
    long double krf = 0,    krf2 = 0; /* aux */

    long double als_col = 0; /* keep 'em pedantic warnings */
    long double frs_col = 0;

    long double val;
    long double frs_result[MAX_PAR_SETS];
    long double als_result[MAX_PAR_SETS];

    int pset;
    dr_par par;

    int bstep;
    dr_par frs_par   = 0;
    double frs_scale = 0;
    dr_par als_par   = 0;
    double als_scale = 0;
    dr_par* p_par;
    dr_op* p_ope;
    int dobail;
    gboolean mbail;
    gboolean kbail;

    auto_layer*       als = &img->auto_settings;
    fractal_settings* frs = &img->frac_settings;
    user_params*      ups = &img->user_settings;

    double rt, rti;
    int layers;
    double bail_st,    bail_sz;
    double pert_re_st, pert_re_sz;
    double pert_im_st, pert_im_sz;

    int czmax = als->count_max_iter;
    int czmin = als->count_min_iter;
    int czrad = czmax - czmin;
    int bzmax = als->bail_max_iter;
    int bzmin = als->bail_min_iter;
    int bzrad = bzmax - bzmin;
    int pzmax = als->pert_max_iter;
    int pzmin = als->pert_min_iter;
    int pzrad = pzmax - pzmin;
    double crtmax   = als->count_max_rt;
    double crtmin   = als->count_min_rt;
    double crtrad   = crtmax - crtmin;
    double brtmax   = als->bail_max_rt;
    double brtmin   = als->bail_min_rt;
    double brtrad   = brtmax - brtmin;
    double prertmax = als->pert_re_max_rt;
    double prertmin = als->pert_re_min_rt;
    double prertrad = prertmax - prertmin;
    double pimrtmax = als->pert_im_max_rt;
    double pimrtmin = als->pert_im_min_rt;
    double pimrtrad = pimrtmax - pimrtmin;

    gboolean fractal =
        (frs->in_par!=PAR_OFF || frs->out_par!=PAR_OFF) ? TRUE : FALSE;

    gboolean autolayer =  
        (als->in_par!=PAR_OFF || als->out_par!=PAR_OFF) ? TRUE : FALSE;

    int z_auto = 0;

    /*  quick switch method for flipping between straight 
        Mandy or Kunged Mandy..                      */
    kunge_type frs_kt = (img->method) ? KT_OFF  : frs->kunge;
    kunge_type als_kt = (img->method) ? KT_OFF  : als->kunge;
    bail_type  frs_bt = (img->method) ? BT_MAND : frs->bail;
    bail_type  als_bt = (img->method) ? BT_MAND : als->bail;

    double  frs_bail = frs->bail_value;

    long double f_re = frs->re_pert;
    long double f_im = frs->im_pert;

    y = img->ymax - ((img->xmax - img->xmin) 
                / (long double)img->real_width)
                * (long double)img->lines_done;

    for (ix=0; ix < img->real_width; ix++) {
        x = ((long double)ix / (long double)img->real_width)
            * (img->xmax - img->xmin) + img->xmin;

    x2 = x * x;
    y2 = y * y;
if (fractal == TRUE) {
        wre = wkf = wkr = x;
        wim = wki = y;
        wre2 = wkr2 = x2;
        wim2 = wki2 = y2;

        /* do the bog standard fractal stuff  */
        switch (img->fr_type) {
        case MANDELBROT:
            c_re = x;
            c_im = y;
            break;
        case JULIA:
            c_re = img->u.julia.c_re;
            c_im = img->u.julia.c_im;
            break;
        }
        mz = -1;
        kz = -1;
        mbail = FALSE;
        kbail = FALSE;
        dobail = 2;

    /* calculate fractal */
    switch (frs_kt)
    {
    case KT_XR2:
        for (wz=0; wz < img->depth; wz++) {
            wim = 2.0 * wre * wim + c_im - f_im;
            wre = wre2 - wim2 + c_re - f_re;
            wim2 = wim * wim;
            wre2 = wre * wre;
            wki = 2 * (wkr - wre) * (wki - wim) + c_im;
            wkr = ((wre2 - wkr) - (wim2 - wki)) + c_re;
            wki2 = wki * wki; 
            wkr2 = wkr * wkr;
            if (mz < 0) { if ((wim2 + wre2) > frs_bail) {
                    if (frs_bt == BT_MAND || frs_bt == BT_FIRST)
                        dobail = 0; else dobail--;
                    mbail = TRUE;
                    mz = wz;
                    mre = wre;      mim = wim;
                    mre2 = wre2;    mim2 = wim2; }
            }
            if (kz < 0) { if ((wkr2 + wki2) > frs_bail) {
                    if (frs_bt == BT_KUNGE || frs_bt == BT_FIRST)
                        dobail = 0; else dobail--;
                    kbail = TRUE;
                    lre = wre;      lim = wim;
                    lre2 = wre2;    lim2 = wim2;
                    kz = wz;
                    kre = wkr;      kim = wki;
                    kre2 = wkr2;    kim2 = wki2; }
            }
            if (dobail == 0) break;
        }
        break;
        case KT_GTI:
        for (wz=0; wz < img->depth; wz++) {
            wim = 2.0 * wre * wim + c_im - f_im;
            wre = wre2 - wim2 + c_re - f_re;
            wim2 = wim * wim;
            wre2 = wre * wre;
            wki = 2 * (wkr - wre) * (wki - wim) + c_im;
            wkr = ((wre2 - wkf) - (wim2 - wki)) + c_re;
            wkf = ((wre2 * wkr) - (wim2 * wki)) + c_re;
            wki2 = wki * wki; 
            wkr2 = wkr * wkr;
            wkf2 = wkf * wkf;
            if (mz < 0) { if ((wim2 + wre2) > frs_bail) {
                    if (frs_bt == BT_MAND || frs_bt == BT_FIRST)
                        dobail = 0; else dobail--;
                    mbail = TRUE;
                    mz = wz;
                    mre = wre;      mim = wim;
                    mre2 = wre2;    mim2 = wim2; }
            }
            if (kz < 0) { if ((wkf2 + wki2) > frs_bail) {
                    if (frs_bt == BT_KUNGE || frs_bt == BT_FIRST)
                        dobail = 0; else dobail--;
                    kbail = TRUE;
                    lre = wre;      lim = wim;
                    lre2 = wre2;    lim2 = wim2;
                    kz = wz;
                    kre = wkr;      kim = wki;
                    kre2 = wkr2;    kim2 = wki2;
                    krf = wkf;      krf2 = wkf2; }
            }
            if (dobail == 0) break;
        }
        break;
        case KT_AFX:
        for (wz=0; wz < img->depth; wz++) {
            wim = 2.0 * wre * wim + c_im - f_im;
            wre = wre2 - wim2 + c_re - f_re;
            wim2 = wim * wim;
            wre2 = wre * wre;
            wki = 2 * (wkr - wre) * (wki - wim) + c_im;
            wkr = powl(wre2, wkf) - powl(wim2, wki) + c_re;
            wkf = wre2 * wkr - wim2 * wki + c_re;
            wki2 = wki * wki; 
            wkr2 = wkr * wkr;
            wkf2 = wkf * wkf;
            if (mz < 0) { if ((wim2 + wre2) > frs_bail) {
                    if (frs_bt == BT_MAND || frs_bt == BT_FIRST)
                        dobail = 0; else dobail--;
                    mbail = TRUE;
                    mz = wz;
                    mre = wre;      mim = wim;
                    mre2 = wre2;    mim2 = wim2; }
            }
            if (kz < 0) { if ((wkf2 + wki2) > frs_bail) {
                    if (frs_bt == BT_KUNGE || frs_bt == BT_FIRST)
                        dobail = 0; else dobail--;
                    kbail = TRUE;
                    lre = wre;      lim = wim;
                    lre2 = wre2;    lim2 = wim2;
                    kz = wz;
                    kre = wkr;      kim = wki;
                    kre2 = wkr2;    kim2 = wki2;
                    krf = wkf;      krf2 = wkf2; }
            }
            if (dobail == 0) break;
        }
        break;
        case KT_NSX:
        for (wz=0; wz < img->depth; wz++) {
            wim = 2.0 * wre * wim + c_im - f_im;
            wre = wre2 - wim2 + c_re - f_re;
            wim2 = wim * wim;
            wre2 = wre * wre;
            wki = 2 * (wkr - wre) * (wki - wim) + c_im;
            wkr = powl(wre2, wkf) * powl(wim2, wki) + c_re;
            wkf = (wre2 + wkr) - wim2 * wki + c_re;
            wki2 = wki * wki;
            wkr2 = wkr * wkr;
            wkf2 = wkf * wkf;
            if (mz < 0) { if ((wim2 + wre2) > frs_bail) {
                    if (frs_bt == BT_MAND || frs_bt == BT_FIRST)
                        dobail = 0; else dobail--;
                    mbail = TRUE;
                    mz = wz;
                    mre = wre;      mim = wim;
                    mre2 = wre2;    mim2 = wim2; }
            }
            if (kz < 0) { if ((wkf2 + wki2) > frs_bail) {
                    if (frs_bt == BT_KUNGE || frs_bt == BT_FIRST)
                        dobail = 0; else dobail--;
                    kbail = TRUE;
                    lre = wre;      lim = wim;
                    lre2 = wre2;    lim2 = wim2;
                    kz = wz;
                    kre = wkr;      kim = wki;
                    kre2 = wkr2;    kim2 = wki2;
                    krf = wkf;      krf2 = wkf2; }
            }
            if (dobail == 0) break;
        }
        break;
        case KT_RPM:
        for (wz=0; wz < img->depth; wz++) {
            wim = 2.0 * wre * wim + c_im - f_im;
            wre = wre2 - wim2 + c_re - f_re;
            wim2 = wim * wim;
            wre2 = wre * wre;
            wki = 2 * (wkr - wre) * (wki - wim) + c_im;
            wkr = powl(wre2, wkf) * powl(wim2, wki) + c_re;
            wkf = (wre2 + wkr) * (wim2 + wki) + c_re;
            wki2 = wki * wki; 
            wkr2 = wkr * wkr;
            wkf2 = wkf * wkf;
            if (mz < 0) { if ((wim2 + wre2) > frs_bail) {
                    if (frs_bt == BT_MAND || frs_bt == BT_FIRST)
                        dobail = 0; else dobail--;
                    mbail = TRUE;
                    mz = wz;
                    mre = wre;      mim = wim;
                    mre2 = wre2;    mim2 = wim2; }
            }
            if (kz < 0) { if ((wkf2 + wki2) > frs_bail) {
                    if (frs_bt == BT_KUNGE || frs_bt == BT_FIRST)
                        dobail = 0; else dobail--;
                    kbail = TRUE;
                    lre = wre;      lim = wim;
                    lre2 = wre2;    lim2 = wim2;
                    kz = wz;
                    kre = wkr;      kim = wki;
                    kre2 = wkr2;    kim2 = wki2;
                    krf = wkf;      krf2 = wkf2; }
            }
            if (dobail == 0) break;
        }
        break;
    case KT_XR2MKII:
        for (wz=0; wz < img->depth; wz++) {
            wim = 2.0 * wre * wim + c_im - f_im;
            wre = wre2 - wim2 + c_re - f_re;
            wim2 = wim * wim;
            wre2 = wre * wre;
            wki = 2 * (wre - wkr) * (wim - wki) + c_im;
            tmp1 = wre - wkr;
            tmp2 = wim - wki;
            wkr = tmp1 * tmp1 - tmp2 * tmp2 + c_re;
            wki2 = wki * wki; 
            wkr2 = wkr * wkr;
            if (mz < 0) { if ((wim2 + wre2) > frs_bail) {
                    if (frs_bt == BT_MAND || frs_bt == BT_FIRST)
                        dobail = 0; else dobail--;
                    mbail = TRUE;
                    mz = wz;
                    mre = wre;      mim = wim;
                    mre2 = wre2;    mim2 = wim2; }
            }
            if (kz < 0) { if ((wkr2 + wki2) > frs_bail) {
                    if (frs_bt == BT_KUNGE || frs_bt == BT_FIRST)
                        dobail = 0; else dobail--;
                    kbail = TRUE;
                    lre = wre;      lim = wim;
                    lre2 = wre2;    lim2 = wim2;
                    kz = wz;
                    kre = wkr;      kim = wki;
                    kre2 = wkr2;    kim2 = wki2; }
            }
            if (dobail == 0) break;
        }
        break;
    case KT_XR2MKIII:
        for (wz=0; wz < img->depth; wz++) {
            wim = 2.0 * wre * wim + c_im - f_im;
            wre = wre2 - wim2 + c_re - f_re;
            wim2 = wim * wim;
            wre2 = wre * wre;
            tmp1 = wkr - wre;
            tmp2 = wki - wim;
            wki = 2 * tmp1 * tmp2 + c_im;
            wkr = tmp1 * tmp1 - tmp2 * tmp2 + c_re;
            wki2 = wki * wki; 
            wkr2 = wkr * wkr;
            if (mz < 0) { if ((wim2 + wre2) > frs_bail) {
                    if (frs_bt == BT_MAND || frs_bt == BT_FIRST)
                        dobail = 0; else dobail--;
                    mbail = TRUE;
                    mz = wz;
                    mre = wre;      mim = wim;
                    mre2 = wre2;    mim2 = wim2; }
            }
            if (kz < 0) { if ((wkr2 + wki2) > frs_bail) {
                    if (frs_bt == BT_KUNGE || frs_bt == BT_FIRST)
                        dobail = 0; else dobail--;
                    kbail = TRUE;
                    lre = wre;      lim = wim;
                    lre2 = wre2;    lim2 = wim2;
                    kz = wz;
                    kre = wkr;      kim = wki;
                    kre2 = wkr2;    kim2 = wki2; }
            }
            if (dobail == 0) break;
        }
        break;
        case KT_GTIMKII:
        for (wz=0; wz < img->depth; wz++) {
            wim = 2.0 * wre * wim + c_im - f_im;
            wre = wre2 - wim2 + c_re - f_re;
            wim2 = wim * wim;
            wre2 = wre * wre;
            wki = 2 * (wkr - wre) * (wki - wim) + c_im;
            tmp1 = wre - wkf;
            tmp2 = wim - wki;
            wkr = tmp1 * tmp1 - tmp2 * tmp2 + c_re;
            wkf = wre*wkr*wre*wkr - wim*wki*wim*wki + c_re;
            wki2 = wki * wki; 
            wkr2 = wkr * wkr;
            wkf2 = wkf * wkf;
            if (mz < 0) { if ((wim2 + wre2) > frs_bail) {
                    if (frs_bt == BT_MAND || frs_bt == BT_FIRST)
                        dobail = 0; else dobail--;
                    mbail = TRUE;
                    mz = wz;
                    mre = wre;      mim = wim;
                    mre2 = wre2;    mim2 = wim2; }
            }
            if (kz < 0) { if ((wkf2 + wki2) > frs_bail) {
                    if (frs_bt == BT_KUNGE || frs_bt == BT_FIRST)
                        dobail = 0; else dobail--;
                    kbail = TRUE;
                    lre = wre;      lim = wim;
                    lre2 = wre2;    lim2 = wim2;
                    kz = wz;
                    kre = wkr;      kim = wki;
                    kre2 = wkr2;    kim2 = wki2;
                    krf = wkf;      krf2 = wkf2; }
            }
            if (dobail == 0) break;
        }
        break;
    case KT_MTB:
        for (wz=0; wz < img->depth; wz++) {
            wim = 2.0 * wre * wim + c_im - f_im;
            wre = wre2 - wim2 + c_re - f_re;
            wim2 = wim * wim;
            wre2 = wre * wre;
            tmp1 = wkr2 - wre2;
            tmp2 = wki2 - wim2;
            wki = 2.0 * (wki-wim) * (wkr-wre) + c_im;
            wkr = tmp1 * tmp2 + c_re;
            wki2 = wki * wki; 
            wkr2 = wkr * wkr;
            if (mz < 0) { if ((wim2 + wre2) > frs_bail) {
                    if (frs_bt == BT_MAND || frs_bt == BT_FIRST)
                        dobail = 0; else dobail--;
                    mbail = TRUE;
                    mz = wz;
                    mre = wre;      mim = wim;
                    mre2 = wre2;    mim2 = wim2; }
            }
            if (kz < 0) { if ((wkr2 + wki2) > frs_bail) {
                    if (frs_bt == BT_KUNGE || frs_bt == BT_FIRST)
                        dobail = 0; else dobail--;
                    kbail = TRUE;
                    lre = wre;      lim = wim;
                    lre2 = wre2;    lim2 = wim2;
                    kz = wz;
                    kre = wkr;      kim = wki;
                    kre2 = wkr2;    kim2 = wki2; }
            }
            if (dobail == 0) break;
        }
        break;
        default: /* mandelbrot! */
        for (wz=0; wz < img->depth; wz++) {
            wim = 2.0 * wre * wim+ c_im - f_im;
            wre = wre2 - wim2 + c_re - f_re;
            wim2 = wim * wim;
            wre2 = wre * wre;
            if ((wim2 + wre2) > frs_bail) {
                mz = kz = wz;
                mre = lre = kre = krf = wre;
                mim = lim = kim = wim;
                mre2 = lre2 = kre2 = wre2;
                mim2 = lim2 = kim2 = wim2;
                mbail = TRUE;
                break;
            }
        }
    } /* end switch(method) */

    if (mbail == FALSE) {
        mz = wz;
        mre = wre;      mim = wim;
        mre2 = wre2;    mim2 = wim2;
    }
    if (kbail == FALSE) {
        kz = wz;
        lre = wre;      lim = wim;
        lre2 = wre2;    lim2 = wim2;
        kre = wkr;      kim = wki;
        kre2 = wkr2;    kim2 = wki2; 
        krf = wkf;      krf2 = wkf2;
    }
    /* calculate any used parameter sets first ... */
        for (pset = 0; pset < MAX_PAR_SETS; pset++) {
            frs_result[pset] = 0;
            if (ups->param_used_frs[pset] == TRUE) {
                p_par = ups->params[pset];
                p_ope = ups->operas[pset];
                for (par = 0; par < ups->params_count[pset]; par++) {
                    switch(p_par[par]) {
                        case PAR_Z:         val = mz;       break;
                        case PAR_RE:        val = mre;      break;
                        case PAR_IM:        val = mim;      break;
                        case PAR_RE2:       val = mre2;     break;
                        case PAR_IM2:       val = mim2;     break;
                        case PAR_LRE:       val = lre;      break;
                        case PAR_LIM:       val = lim;      break;
                        case PAR_LRE2:      val = lre2;     break;
                        case PAR_LIM2:      val = lim2;     break;
                        case PAR_KZ:        val = kz;       break;
                        case PAR_KRE:       val = kre;      break;
                        case PAR_KIM:       val = kim;      break;
                        case PAR_KRE2:      val = kre2;     break;
                        case PAR_KIM2:      val = kim2;     break;
                        case PAR_SIN_Z:     val = sin(mz);  break;
                        case PAR_COS_Z:     val = cos(mz);  break;
                        case PAR_SIN_RE:    val = sin(mre); break;
                        case PAR_COS_RE:    val = cos(mre); break;
                        case PAR_SIN_IM:    val = sin(mim); break;
                        case PAR_COS_IM:    val = cos(mim); break;
                        case PAR_SIN_RE2:   val = sin(mre2);break;
                        case PAR_COS_RE2:   val = cos(mre2);break;
                        case PAR_SIN_IM2:   val = sin(mim2);break;
                        case PAR_COS_IM2:   val = cos(mim2);break;
                        case PAR_SIN_LRE:   val = sin(lre); break;
                        case PAR_COS_LRE:   val = cos(lre); break;
                        case PAR_SIN_LIM:   val = sin(lim); break;
                        case PAR_COS_LIM:   val = cos(lim); break;
                        case PAR_SIN_LRE2:  val = sin(lre2);break;
                        case PAR_COS_LRE2:  val = cos(lre2);break;
                        case PAR_SIN_LIM2:  val = sin(lim2);break;
                        case PAR_COS_LIM2:  val = cos(lim2);break;
                        case PAR_SIN_KZ:    val = sin(kz);  break;
                        case PAR_COS_KZ:    val = cos(kz);  break;
                        case PAR_SIN_KRE:   val = sin(kre); break;
                        case PAR_COS_KRE:   val = cos(kre); break;
                        case PAR_SIN_KIM:   val = sin(kim); break;
                        case PAR_COS_KIM:   val = cos(kim); break;
                        case PAR_SIN_KRE2:  val = sin(kre2);break;
                        case PAR_COS_KRE2:  val = cos(kre2);break;
                        case PAR_SIN_KIM2:  val = sin(kim2);break;
                        case PAR_COS_KIM2:  val = cos(kim2);break;
                        case PAR_LOG_Z:     val = log(mz);  break;
                        case PAR_LOG_RE:    val = log(mre); break;
                        case PAR_LOG_IM:    val = log(mim); break;
                        case PAR_LOG_RE2:   val = log(mre2);break;
                        case PAR_LOG_IM2:   val = log(mim2);break;
                        case PAR_LOG_LRE:   val = log(lre); break;
                        case PAR_LOG_LIM:   val = log(lim); break;
                        case PAR_LOG_LRE2:  val = log(lre2);break;
                        case PAR_LOG_LIM2:  val = log(lim2);break;
                        case PAR_LOG_KZ:    val = log(kz);  break;
                        case PAR_LOG_KRE:   val = log(kre); break;
                        case PAR_LOG_KIM:   val = log(kim); break;
                        case PAR_LOG_KRE2:  val = log(kre2);break;
                        case PAR_LOG_KIM2:  val = log(kim2);break;
                        case PAR_A:     val = frs_result[0];break;
                        case PAR_B:     val = frs_result[1];break;
                        case PAR_C:     val = frs_result[2];break;
                        case PAR_D:     val = frs_result[3];break;
                        case PAR_E:     val = frs_result[4];break;
                        case PAR_F:     val = frs_result[5];break;
                        case PAR_SIN_A: val = sin(frs_result[0]); break;
                        case PAR_COS_A: val = cos(frs_result[0]); break;
                        case PAR_SIN_B: val = sin(frs_result[1]); break;
                        case PAR_COS_B: val = cos(frs_result[1]); break;
                        case PAR_SIN_C: val = sin(frs_result[2]); break;
                        case PAR_COS_C: val = cos(frs_result[2]); break;
                        case PAR_SIN_D: val = sin(frs_result[3]); break;
                        case PAR_COS_D: val = cos(frs_result[3]); break;
                        case PAR_SIN_E: val = sin(frs_result[4]); break;
                        case PAR_COS_E: val = cos(frs_result[4]); break;
                        case PAR_SIN_F: val = sin(frs_result[5]); break;
                        case PAR_COS_F: val = cos(frs_result[5]); break;
                        case PAR_LOG_A: val = log(frs_result[0]); break;
                        case PAR_LOG_B: val = log(frs_result[1]); break;
                        case PAR_LOG_C: val = log(frs_result[2]); break;
                        case PAR_LOG_D: val = log(frs_result[3]); break;
                        case PAR_LOG_E: val = log(frs_result[4]); break;
                        case PAR_LOG_F: val = log(frs_result[5]); break;
                        case PAR_N1:    val = ups->numbers[0];    break;
                        case PAR_N2:    val = ups->numbers[1];    break;
                        case PAR_N3:    val = ups->numbers[2];    break;
                        case PAR_N4:    val = ups->numbers[3];    break;
                        case PAR_N5:    val = ups->numbers[4];    break;
                        case PAR_N6:    val = ups->numbers[5];    break;
                        default:
                            val = 0; 
    printf("\nBUG - switch default for colmode.in_param[%d]", pset);
                            exit(-1);
                    }
                    if (par == 0)
                        frs_result[pset] = val;
                    else {
                        switch(p_ope[par - 1]) {
                            case OP_OFF: break;
                            case OP_ADD: frs_result[pset] += val; break;
                            case OP_SUB: frs_result[pset] -= val; break;
                            case OP_MUL: frs_result[pset] *= val; break;
                            case OP_DIV: frs_result[pset] /= val; break;
                            case OP_MIN: frs_result[pset] =
                                    (val < frs_result[pset])
                                    ? val : frs_result[pset];
                                    break;
                            case OP_MAX: frs_result[pset] =
                                    (val > frs_result[pset])
                                    ? val : frs_result[pset];
                                    break;
                            default:
    printf("\nBUG - hit switch default for colmode.opera[%d]", pset-1);
                            exit(-1);
                        }
                    }
                }
            }
        }

        /* workout if inside or outside */
        switch(frs_bt) {
            case BT_MAND:
                z_auto = mz;
                if (mbail == TRUE) {
                    frs_par   = frs->out_par;
                    frs_scale = frs->out_scale;
                }
                else {
                    frs_par   = frs->in_par;
                    frs_scale = frs->in_scale;
                }
                break;
            case BT_KUNGE:
                z_auto = kz;
                if (kbail == TRUE) {
                    frs_par   = frs->out_par;
                    frs_scale = frs->out_scale;
                }
                else {
                    frs_par   = frs->in_par;
                    frs_scale = frs->in_scale;
                }
                break;
            case BT_FIRST:
                z_auto = wz;
                if (mbail == TRUE || kbail == TRUE) {
                    frs_par   = frs->out_par;
                    frs_scale = frs->out_scale;
                }
                else {
                    frs_par   = frs->in_par;
                    frs_scale = frs->in_scale;
                }
                break;
            case BT_BOTH:
                z_auto = wz;
                if (mbail == TRUE && kbail == TRUE) {
                    frs_par   = frs->out_par;
                    frs_scale = frs->out_scale;
                }
                else {
                    frs_par   = frs->in_par;
                    frs_scale = frs->in_scale;
                }
                break;
            default: printf("\nfan shit");
        }
        switch(frs_par) {
            case PAR_Z:         frs_col = mz;       break;
            case PAR_RE:        frs_col = mre;      break;
            case PAR_IM:        frs_col = mim;      break;
            case PAR_RE2:       frs_col = mre2;     break;
            case PAR_IM2:       frs_col = mim2;     break;
            case PAR_LRE:       frs_col = lre;      break;
            case PAR_LIM:       frs_col = lim;      break;
            case PAR_LRE2:      frs_col = lre2;     break;
            case PAR_LIM2:      frs_col = lim2;     break;
            case PAR_KZ:        frs_col = kz;       break;
            case PAR_KRE:       frs_col = kre;      break;
            case PAR_KIM:       frs_col = kim;      break;
            case PAR_KRE2:      frs_col = kre2;     break;
            case PAR_KIM2:      frs_col = kim2;     break;
            case PAR_SIN_Z:     frs_col = sin(mz);  break;
            case PAR_COS_Z:     frs_col = cos(mz);  break;
            case PAR_SIN_RE:    frs_col = sin(mre); break;
            case PAR_COS_RE:    frs_col = cos(mre); break;
            case PAR_SIN_IM:    frs_col = sin(mim); break;
            case PAR_COS_IM:    frs_col = cos(mim); break;
            case PAR_SIN_RE2:   frs_col = sin(mre2);break;
            case PAR_COS_RE2:   frs_col = cos(mre2);break;
            case PAR_SIN_IM2:   frs_col = sin(mim2);break;
            case PAR_COS_IM2:   frs_col = cos(mim2);break;
            case PAR_SIN_LRE:   frs_col = sin(lre); break;
            case PAR_COS_LRE:   frs_col = cos(lre); break;
            case PAR_SIN_LIM:   frs_col = sin(lim); break;
            case PAR_COS_LIM:   frs_col = cos(lim); break;
            case PAR_SIN_LRE2:  frs_col = sin(lre2);break;
            case PAR_COS_LRE2:  frs_col = cos(lre2);break;
            case PAR_SIN_LIM2:  frs_col = sin(lim2);break;
            case PAR_COS_LIM2:  frs_col = cos(lim2);break;
            case PAR_SIN_KZ:    frs_col = sin(kz);  break;
            case PAR_COS_KZ:    frs_col = cos(kz);  break;
            case PAR_SIN_KRE:   frs_col = sin(kre); break;
            case PAR_COS_KRE:   frs_col = cos(kre); break;
            case PAR_SIN_KIM:   frs_col = sin(kim); break;
            case PAR_COS_KIM:   frs_col = cos(kim); break;
            case PAR_SIN_KRE2:  frs_col = sin(kre2);break;
            case PAR_COS_KRE2:  frs_col = cos(kre2);break;
            case PAR_SIN_KIM2:  frs_col = sin(kim2);break;
            case PAR_COS_KIM2:  frs_col = cos(kim2);break;
            case PAR_LOG_Z:     frs_col = log(mz);  break;
            case PAR_LOG_RE:    frs_col = log(mre); break;
            case PAR_LOG_IM:    frs_col = log(mim); break;
            case PAR_LOG_RE2:   frs_col = log(mre2);break;
            case PAR_LOG_IM2:   frs_col = log(mim2);break;
            case PAR_LOG_LRE:   frs_col = log(lre); break;
            case PAR_LOG_LIM:   frs_col = log(lim); break;
            case PAR_LOG_LRE2:  frs_col = log(lre2);break;
            case PAR_LOG_LIM2:  frs_col = log(lim2);break;
            case PAR_LOG_KZ:    frs_col = log(kz);  break;
            case PAR_LOG_KRE:   frs_col = log(kre); break;
            case PAR_LOG_KIM:   frs_col = log(kim); break;
            case PAR_LOG_KRE2:  frs_col = log(kre2);break;
            case PAR_LOG_KIM2:  frs_col = log(kim2);break;
            case PAR_A:         frs_col = frs_result[0];      break;
            case PAR_B:         frs_col = frs_result[1];      break;
            case PAR_C:         frs_col = frs_result[2];      break;
            case PAR_D:         frs_col = frs_result[3];      break;
            case PAR_E:         frs_col = frs_result[4];      break;
            case PAR_F:         frs_col = frs_result[5];      break;
            case PAR_SIN_A:     frs_col = sin(frs_result[0]); break;
            case PAR_COS_A:     frs_col = cos(frs_result[0]); break;
            case PAR_SIN_B:     frs_col = sin(frs_result[1]); break;
            case PAR_COS_B:     frs_col = cos(frs_result[1]); break;
            case PAR_SIN_C:     frs_col = sin(frs_result[2]); break;
            case PAR_COS_C:     frs_col = cos(frs_result[2]); break;
            case PAR_SIN_D:     frs_col = sin(frs_result[3]); break;
            case PAR_COS_D:     frs_col = cos(frs_result[3]); break;
            case PAR_SIN_E:     frs_col = sin(frs_result[4]); break;
            case PAR_COS_E:     frs_col = cos(frs_result[4]); break;
            case PAR_SIN_F:     frs_col = sin(frs_result[5]); break;
            case PAR_COS_F:     frs_col = cos(frs_result[5]); break;
            case PAR_LOG_A:     frs_col = log(frs_result[0]); break;
            case PAR_LOG_B:     frs_col = log(frs_result[1]); break;
            case PAR_LOG_C:     frs_col = log(frs_result[2]); break;
            case PAR_LOG_D:     frs_col = log(frs_result[3]); break;
            case PAR_LOG_E:     frs_col = log(frs_result[4]); break;
            case PAR_LOG_F:     frs_col = log(frs_result[5]); break;
            case PAR_N1:        frs_col = ups->numbers[0];    break;
            case PAR_N2:        frs_col = ups->numbers[1];    break;
            case PAR_N3:        frs_col = ups->numbers[2];    break;
            case PAR_N4:        frs_col = ups->numbers[3];    break;
            case PAR_N5:        frs_col = ups->numbers[4];    break;
            case PAR_N6:        frs_col = ups->numbers[5];    break;
            default:            frs_col = UINT_MAX;
        }
} /* end if (fractal == TRUE) */

/*---------------------------------------------*/
    /**************************************/
    /*OO000000000000000000000000000000OO00*/
    /*OO now do the autolayer colouring OO*/
    /*00OO00000000000000000000000000000OOO*/
    /**************************************/
/*---------------------------------------------*/

if (autolayer == TRUE) {
        /* work out how many layers from slope */
            if (z_auto < czmin)
                rt = crtmin;
            else if (z_auto > czmax)
                rt = crtmax;
            else 
                rt = crtmin + crtrad * ((z_auto - czmin) / (double)czrad);
            layers = als->layer_count * rt;

        /* work out first and last bail values from slope */
            if (z_auto < bzmin)
                rt = brtmin;
            else if (z_auto > bzmax)
                rt = brtmax;
            else
                rt = brtmin + brtrad * ((z_auto - bzmin) / (double)bzrad);
            bail_st = als->bail_start * rt;
            bail_sz = (als->bail_end * rt - bail_st) / (double)layers;

        /* work out that perturbation from slope */
            if (z_auto < pzmin) {
                rt = prertmin;
                rti= pimrtmin;
            }
            else if (z_auto > pzmax) {
                rt = prertmax;
                rti= pimrtmax;
            }
            else {
                rt = prertmin + prertrad * ((z_auto-pzmin)/(double)pzrad);
                rti= pimrtmin + pimrtrad * ((z_auto-pzmin)/(double)pzrad);
            }
            pert_re_st = als->pert_re_start * rt;
            pert_im_st = als->pert_im_start * rti;
            pert_re_sz = (als->pert_re_end * rt - pert_re_st) 
                                    / (double)layers;
            pert_im_sz = (als->pert_im_end * rti - pert_im_st) 
                                    / (double)layers;
        bstep = 0;
        als_col = 0;
        do
        {
            wre = wkf = wkr = x;
            wim = wki = y;
            wre2 = wkr2 = x2;
            wim2 = wki2 = y2;
         switch (img->fr_type) {
         case MANDELBROT:
            c_re = x;
            c_im = y;
            break;
         case JULIA:
            c_re = img->u.julia.c_re;
            c_im = img->u.julia.c_im;
            break;
         }
         mz = -1;
         kz = -1;
         mbail = FALSE;
         kbail = FALSE;
         dobail = 2;
     /* calculate fractal */
     switch (als_kt)
     {

 /* mandelbrat xr2 */
     case 1:
         for (wz=0; wz < img->depth; wz++) {
             wim = 2.0 * wre * wim + c_im - pert_im_st;
             wre = wre2 - wim2 + c_re - pert_re_st;
             wim2 = wim * wim;
             wre2 = wre * wre;
             if (mz < 0) { if ((wim2 + wre2) > bail_st) {
     if (als_bt == BT_MAND || als_bt == BT_FIRST)
                         dobail = 0; else dobail--;
                    mbail = TRUE;
                     mz = wz;
                     mre = wre;      mim = wim;
                     mre2 = wre2;    mim2 = wim2; }
             }
             wki = 2 * (wkr - wre) * (wki - wim) + c_im;
             wkr = ((wre2 - wkr) - (wim2 - wki)) + c_re;
             wki2 = wki * wki;
             wkr2 = wkr * wkr;
             if (kz < 0) { if ((wkr2 + wki2) > bail_st) {
     if (als_bt == BT_KUNGE || als_bt == BT_FIRST)
                         dobail = 0; else dobail--;
                    kbail = TRUE;
                     lre = wre;      lim = wim;
                     lre2 = wre2;    lim2 = wim2;
                     kz = wz;
                     kre = wkr;      kim = wki;
                     kre2 = wkr2;    kim2 = wki2; }
             }
             if (dobail == 0) break;
         }
         break;

 /* mandelbrat gti */
     case 2:
         for (wz=0; wz < img->depth; wz++) {
             wim = 2.0 * wre * wim + c_im - pert_im_st;
             wre = wre2 - wim2 + c_re - pert_re_st;
             wim2 = wim * wim;
             wre2 = wre * wre;
             if (mz < 0) { if ((wim2 + wre2) > bail_st) {
     if (als_bt == BT_MAND || als_bt == BT_FIRST)
                         dobail = 0; else dobail--;
                    mbail = TRUE;
                     mz = wz;
                     mre = wre;      mim = wim;
                     mre2 = wre2;    mim2 = wim2; }
             }
             wki = 2 * (wkr - wre) * (wki - wim) + c_im;
             wkr = ((wre2 - wkf) - (wim2 - wki)) + c_re;
             wkf = ((wre2 * wkr) - (wim2 * wki)) + c_re;
             wki2 = wki * wki;
             wkr2 = wkr * wkr;
             wkf2 = wkf * wkf;
             if (kz < 0) { if ((wkf2 + wki2) > bail_st) {
     if (als_bt == BT_KUNGE || als_bt == BT_FIRST)
                         dobail = 0; else dobail--;
                    kbail = TRUE;
                     lre = wre;      lim = wim;
                     lre2 = wre2;    lim2 = wim2;
                     kz = wz;
                     kre = wkr;      kim = wki;
                     kre2 = wkr2;    kim2 = wki2;
                     krf = wkf;      krf2 = wkf2; }
             }
             if (dobail == 0) break;
         }
         break;

 /* mandelbrat AFX */
      case 3:
         for (wz=0; wz < img->depth; wz++) {
             wim = 2.0 * wre * wim + c_im - pert_im_st;
             wre = wre2 - wim2 + c_re - pert_re_st;
             wim2 = wim * wim;
             wre2 = wre * wre;
             if (mz < 0) { if ((wim2 + wre2) > bail_st) {
     if (als_bt == BT_MAND || als_bt == BT_FIRST) 
                         dobail = 0; else dobail--;
                    mbail = TRUE;
                     mz = wz;
                     mre = wre;      mim = wim;
                     mre2 = wre2;    mim2 = wim2; }
             }
             wki = 2 * (wkr - wre) * (wki - wim) + c_im;
             wkr = powl(wre2, wkf) - powl(wim2, wki) + c_re;
             wkf = wre2 * wkr - wim2 * wki + c_re;
             wki2 = wki * wki; 
             wkr2 = wkr * wkr;
             wkf2 = wkf * wkf;
             if (kz < 0) { if ((wkf2 + wki2) > bail_st) {
     if (als_bt == BT_KUNGE || als_bt == BT_FIRST) 
                         dobail = 0; else dobail--;
                    kbail = TRUE;
                     lre = wre;      lim = wim;
                     lre2 = wre2;    lim2 = wim2;
                     kz = wz;
                     kre = wkr;      kim = wki;
                     kre2 = wkr2;    kim2 = wki2; 
                     krf = wkf;      krf2 = wkf2; }
             }
             if (dobail == 0) break;
         }
         break;
 /* mandelbrat AFXii */
     case 4:
         for (wz=0; wz < img->depth; wz++) {
             wim = 2.0 * wre * wim + c_im - pert_im_st;
             wre = wre2 - wim2 + c_re - pert_re_st;
             wim2 = wim * wim;
             wre2 = wre * wre;
             if (mz < 0) { if ((wim2 + wre2) > bail_st) {
     if (als_bt == BT_MAND || als_bt == BT_FIRST)
                         dobail = 0; else dobail--;
                    mbail = TRUE;
                     mz = wz;
                     mre = wre;      mim = wim;
                     mre2 = wre2;    mim2 = wim2; }
             }
             wki = 2 * (wkr - wre) * (wki - wim) + c_im;
             wkr = powl(wre2, wkf) * powl(wim2, wki) + c_re;
             wkf = (wre2 + wkr) - wim2 * wki + c_re;
             wki2 = wki * wki;
             wkr2 = wkr * wkr;
             wkf2 = wkf * wkf;
             if (kz < 0) { if ((wkf2 + wki2) > bail_st) {
     if (als_bt == BT_KUNGE || als_bt == BT_FIRST)
                         dobail = 0; else dobail--;
                    kbail = TRUE;
                     lre = wre;      lim = wim;
                     lre2 = wre2;    lim2 = wim2;
                     kz = wz;
                     kre = wkr;      kim = wki;
                     kre2 = wkr2;    kim2 = wki2;
                     krf = wkf;      krf2 = wkf2; }
             }
             if (dobail == 0) break;
         }
     break;

 /* mandelbrat 45rpm */
     case 5: 
         for (wz=0; wz < img->depth; wz++) {
             wim = 2.0 * wre * wim + c_im - pert_im_st;
             wre = wre2 - wim2 + c_re - pert_re_st;
             wim2 = wim * wim;
             wre2 = wre * wre;
             if (mz < 0) { if ((wim2 + wre2) > bail_st) {
     if (als_bt == BT_MAND || als_bt == BT_FIRST)
                         dobail = 0; else dobail--;
                    mbail = TRUE;
                     mz = wz;
                     mre = wre;      mim = wim;
                     mre2 = wre2;    mim2 = wim2; }
             }
             wki = 2 * (wkr - wre) * (wki - wim) + c_im;
             wkr = powl(wre2, wkf) - powl(wim2, wki) + c_re;
             wkf = (wre2 + wkr) * (wim2 + wki) + c_re;
             wki2 = wki * wki;
             wkr2 = wkr * wkr;
             wkf2 = wkf * wkf;
             if (kz < 0) { if ((wkf2 + wki2) > bail_st) {
     if (als_bt == BT_KUNGE || als_bt == BT_FIRST)
                         dobail = 0; else dobail--;
                    kbail = TRUE;
                     lre = wre;      lim = wim;
                     lre2 = wre2;    lim2 = wim2;
                     kz = wz;
                     kre = wkr;      kim = wki;
                     kre2 = wkr2;    kim2 = wki2;
                     krf = wkf;      krf2 = wkf2; }
             }
             if (dobail == 0) break;
         }
         break;

    case KT_XR2MKII:
        for (wz=0; wz < img->depth; wz++) {
            wim = 2.0 * wre * wim + c_im - pert_im_st;
            wre = wre2 - wim2 + c_re - pert_re_st;
            wim2 = wim * wim;
            wre2 = wre * wre;
            wki = 2 * (wkr - wre) * (wki - wim) + c_im;
            tmp1 = wre - wkr;
            tmp2 = wim - wki;
            wkr = tmp1 * tmp1 - tmp2 * tmp2 + c_re;
            wki2 = wki * wki; 
            wkr2 = wkr * wkr;
            if (mz < 0) { if ((wim2 + wre2) > bail_st) {
                    if (als_bt == BT_MAND || als_bt == BT_FIRST)
                        dobail = 0; else dobail--;
                    mbail = TRUE;
                    mz = wz;
                    mre = wre;      mim = wim;
                    mre2 = wre2;    mim2 = wim2; }
            }
            if (kz < 0) { if ((wkr2 + wki2) > bail_st) {
                    if (als_bt == BT_KUNGE || als_bt == BT_FIRST)
                        dobail = 0; else dobail--;
                    kbail = TRUE;
                    lre = wre;      lim = wim;
                    lre2 = wre2;    lim2 = wim2;
                    kz = wz;
                    kre = wkr;      kim = wki;
                    kre2 = wkr2;    kim2 = wki2; }
            }
            if (dobail == 0) break;
        }
        break;
    case KT_XR2MKIII:
        for (wz=0; wz < img->depth; wz++) {
            wim = 2.0 * wre * wim + c_im - pert_im_st;
            wre = wre2 - wim2 + c_re - pert_re_st;
            wim2 = wim * wim;
            wre2 = wre * wre;
            tmp1 = wre - wkr;
            tmp2 = wim - wki;
            wki = 2 * (wkr - wre) * (wki - wim) + c_im;
            wkr = tmp1 * tmp1 - tmp2 * tmp2 + c_re;
            wki2 = wki * wki; 
            wkr2 = wkr * wkr;
            if (mz < 0) { if ((wim2 + wre2) > bail_st) {
                    if (als_bt == BT_MAND || als_bt == BT_FIRST)
                        dobail = 0; else dobail--;
                    mbail = TRUE;
                    mz = wz;
                    mre = wre;      mim = wim;
                    mre2 = wre2;    mim2 = wim2; }
            }
            if (kz < 0) { if ((wkr2 + wki2) > bail_st) {
                    if (als_bt == BT_KUNGE || als_bt == BT_FIRST)
                        dobail = 0; else dobail--;
                    kbail = TRUE;
                    lre = wre;      lim = wim;
                    lre2 = wre2;    lim2 = wim2;
                    kz = wz;
                    kre = wkr;      kim = wki;
                    kre2 = wkr2;    kim2 = wki2; }
            }
            if (dobail == 0) break;
        }
        break;
        case KT_GTIMKII:
        for (wz=0; wz < img->depth; wz++) {
            wim = 2.0 * wre * wim + c_im - pert_im_st;
            wre = wre2 - wim2 + c_re - pert_re_st;
            wim2 = wim * wim;
            wre2 = wre * wre;
            wki = 2 * (wkr - wre) * (wki - wim) + c_im;
            tmp1 = wre - wkf;
            tmp2 = wim - wki;
            wkr = tmp1 * tmp1 - tmp2 * tmp2 + c_re;
            wkf = wre*wkr*wre*wkr - wim*wki*wim*wki + c_re;
            wki2 = wki * wki; 
            wkr2 = wkr * wkr;
            wkf2 = wkf * wkf;
            if (mz < 0) { if ((wim2 + wre2) > bail_st) {
                    if (als_bt == BT_MAND || als_bt == BT_FIRST)
                        dobail = 0; else dobail--;
                    mbail = TRUE;
                    mz = wz;
                    mre = wre;      mim = wim;
                    mre2 = wre2;    mim2 = wim2; }
            }
            if (kz < 0) { if ((wkf2 + wki2) > bail_st) {
                    if (als_bt == BT_KUNGE || als_bt == BT_FIRST)
                        dobail = 0; else dobail--;
                    kbail = TRUE;
                    lre = wre;      lim = wim;
                    lre2 = wre2;    lim2 = wim2;
                    kz = wz;
                    kre = wkr;      kim = wki;
                    kre2 = wkr2;    kim2 = wki2;
                    krf = wkf;      krf2 = wkf2; }
            }
            if (dobail == 0) break;
        }
        break;
        case KT_MTB:
        for (wz=0; wz < img->depth; wz++) {
            wim = 2.0 * wre * wim + c_im - pert_im_st;
            wre = wre2 - wim2 + c_re - pert_re_st;
            wim2 = wim * wim;
            wre2 = wre * wre;
            tmp1 = wkr2 - wre2;
            tmp2 = wki2 - wim2;
            wki = 2 * (wki-wim) * (wkr-wre) + c_im;
            wkr = tmp1 * tmp2 + c_re;
            wki2 = wki * wki; 
            wkr2 = wkr * wkr;
            if (mz < 0) { if ((wim2 + wre2) > bail_st) {
                    if (als_bt == BT_MAND || als_bt == BT_FIRST)
                        dobail = 0; else dobail--;
                    mbail = TRUE;
                    mz = wz;
                    mre = wre;      mim = wim;
                    mre2 = wre2;    mim2 = wim2; }
            }
            if (kz < 0) { if ((wkr2 + wki2) > bail_st) {
                    if (als_bt == BT_KUNGE || als_bt == BT_FIRST)
                        dobail = 0; else dobail--;
                    kbail = TRUE;
                    lre = wre;      lim = wim;
                    lre2 = wre2;    lim2 = wim2;
                    kz = wz;
                    kre = wkr;      kim = wki;
                    kre2 = wkr2;    kim2 = wki2; }
            }
            if (dobail == 0) break;
        }
        break;

 /* mandelbrot! */
     default:
         for (wz=0; wz < img->depth; wz++) {
             wim = 2.0 * wre * wim + c_im - pert_im_st;
             wre = wre2 - wim2 + c_re - pert_re_st;
             wim2 = wim * wim;
             wre2 = wre * wre;
             if ((wim2 + wre2) > bail_st) {
                 mz = kz = wz;
                 mre = lre = kre = krf = wre;
                 mim = lim = kim = wim;
                 mre2 = lre2 = kre2 = wre2;
                 mim2 = lim2 = kim2 = wim2;
                 mbail = TRUE;
                 break;
             }
         }
     } /* end switch(method) */
    if (mbail == FALSE) {
        mz = wz;
        mre = wre;      mim = wim;
        mre2 = wre2;    mim2 = wim2;
    }
    if (kbail == FALSE) {
        kz = wz;
        lre = wre;      lim = wim;
        lre2 = wre2;    lim2 = wim2;
        kre = wkr;      kim = wki;
        kre2 = wkr2;    kim2 = wki2; 
        krf = wkf;      krf2 = wkf2;
    }
     /* calculate any used parameter sets first ... */
         for (pset = 0; pset < MAX_PAR_SETS; pset++) {
             als_result[pset] = 0;
             if (ups->param_used_als[pset] == TRUE) {
                 p_par = ups->params[pset];
                 p_ope = ups->operas[pset];
                 for (par = 0; par < ups->params_count[pset]; par++) {
                     switch(p_par[par]) {
                        case PAR_Z:         val = mz;       break;
                        case PAR_RE:        val = mre;      break;
                        case PAR_IM:        val = mim;      break;
                        case PAR_RE2:       val = mre2;     break;
                        case PAR_IM2:       val = mim2;     break;
                        case PAR_LRE:       val = lre;      break;
                        case PAR_LIM:       val = lim;      break;
                        case PAR_LRE2:      val = lre2;     break;
                        case PAR_LIM2:      val = lim2;     break;
                        case PAR_KZ:        val = kz;       break;
                        case PAR_KRE:       val = kre;      break;
                        case PAR_KIM:       val = kim;      break;
                        case PAR_KRE2:      val = kre2;     break;
                        case PAR_KIM2:      val = kim2;     break;
                        case PAR_SIN_Z:     val = sin(mz);  break;
                        case PAR_COS_Z:     val = cos(mz);  break;
                        case PAR_SIN_RE:    val = sin(mre); break;
                        case PAR_COS_RE:    val = cos(mre); break;
                        case PAR_SIN_IM:    val = sin(mim); break;
                        case PAR_COS_IM:    val = cos(mim); break;
                        case PAR_SIN_RE2:   val = sin(mre2);break;
                        case PAR_COS_RE2:   val = cos(mre2);break;
                        case PAR_SIN_IM2:   val = sin(mim2);break;
                        case PAR_COS_IM2:   val = cos(mim2);break;
                        case PAR_SIN_LRE:   val = sin(lre); break;
                        case PAR_COS_LRE:   val = cos(lre); break;
                        case PAR_SIN_LIM:   val = sin(lim); break;
                        case PAR_COS_LIM:   val = cos(lim); break;
                        case PAR_SIN_LRE2:  val = sin(lre2);break;
                        case PAR_COS_LRE2:  val = cos(lre2);break;
                        case PAR_SIN_LIM2:  val = sin(lim2);break;
                        case PAR_COS_LIM2:  val = cos(lim2);break;
                        case PAR_SIN_KZ:    val = sin(kz);  break;
                        case PAR_COS_KZ:    val = cos(kz);  break;
                        case PAR_SIN_KRE:   val = sin(kre); break;
                        case PAR_COS_KRE:   val = cos(kre); break;
                        case PAR_SIN_KIM:   val = sin(kim); break;
                        case PAR_COS_KIM:   val = cos(kim); break;
                        case PAR_SIN_KRE2:  val = sin(kre2);break;
                        case PAR_COS_KRE2:  val = cos(kre2);break;
                        case PAR_SIN_KIM2:  val = sin(kim2);break;
                        case PAR_COS_KIM2:  val = cos(kim2);break;
                        case PAR_LOG_Z:     val = log(mz);  break;
                        case PAR_LOG_RE:    val = log(mre); break;
                        case PAR_LOG_IM:    val = log(mim); break;
                        case PAR_LOG_RE2:   val = log(mre2);break;
                        case PAR_LOG_IM2:   val = log(mim2);break;
                        case PAR_LOG_LRE:   val = log(lre); break;
                        case PAR_LOG_LIM:   val = log(lim); break;
                        case PAR_LOG_LRE2:  val = log(lre2);break;
                        case PAR_LOG_LIM2:  val = log(lim2);break;
                        case PAR_LOG_KZ:    val = log(kz);  break;
                        case PAR_LOG_KRE:   val = log(kre); break;
                        case PAR_LOG_KIM:   val = log(kim); break;
                        case PAR_LOG_KRE2:  val = log(kre2);break;
                        case PAR_LOG_KIM2:  val = log(kim2);break;
                        case PAR_A:     val = als_result[0];      break;
                        case PAR_B:     val = als_result[1];      break;
                        case PAR_C:     val = als_result[2];      break;
                        case PAR_D:     val = als_result[3];      break;
                        case PAR_E:     val = als_result[4];      break;
                        case PAR_F:     val = als_result[5];      break;
                        case PAR_SIN_A: val = sin(als_result[0]); break;
                        case PAR_COS_A: val = cos(als_result[0]); break;
                        case PAR_SIN_B: val = sin(als_result[1]); break;
                        case PAR_COS_B: val = cos(als_result[1]); break;
                        case PAR_SIN_C: val = sin(als_result[2]); break;
                        case PAR_COS_C: val = cos(als_result[2]); break;
                        case PAR_SIN_D: val = sin(als_result[3]); break;
                        case PAR_COS_D: val = cos(als_result[3]); break;
                        case PAR_SIN_E: val = sin(als_result[4]); break;
                        case PAR_COS_E: val = cos(als_result[4]); break;
                        case PAR_SIN_F: val = sin(als_result[5]); break;
                        case PAR_COS_F: val = cos(als_result[5]); break;
                        case PAR_LOG_A: val = log(als_result[0]); break;
                        case PAR_LOG_B: val = log(als_result[1]); break;
                        case PAR_LOG_C: val = log(als_result[2]); break;
                        case PAR_LOG_D: val = log(als_result[3]); break;
                        case PAR_LOG_E: val = log(als_result[4]); break;
                        case PAR_LOG_F: val = log(als_result[5]); break;
                        case PAR_N1:    val = ups->numbers[0];    break;
                        case PAR_N2:    val = ups->numbers[1];    break;
                        case PAR_N3:    val = ups->numbers[2];    break;
                        case PAR_N4:    val = ups->numbers[3];    break;
                        case PAR_N5:    val = ups->numbers[4];    break;
                        case PAR_N6:    val = ups->numbers[5];    break;
                        default:
                             val = 0;
     printf("\nBUG - switch default for colmode.in_param[%d]", pset);
                             exit(-1);
                     } /* end switch */

                     if (par == 0)
                         als_result[pset] = val;
                     else {
                         switch(p_ope[par - 1]) {
                             case OP_OFF: break;
                             case OP_ADD: als_result[pset] += val; break;
                             case OP_SUB: als_result[pset] -= val; break;
                             case OP_MUL: als_result[pset] *= val; break;
                             case OP_DIV: als_result[pset] /= val; break;
                             case OP_MIN: als_result[pset]  =
                                     (val < als_result[pset])
                                     ? val : als_result[pset]; break;
                             case OP_MAX: als_result[pset] =
                                     (val > als_result[pset]) 
                                     ? val : als_result[pset]; break;
                             default:
     printf("\nBUG - hit switch default for colmode.opera[%d]", pset-1);
                         }
                     }
                 }
             }
         }
        /* workout if inside or outside */
        switch(als_bt) {
            case BT_MAND:
                if (mbail == TRUE) {
                    als_par   = als->out_par;
                    als_scale = als->out_scale;
                }
                else {
                    als_par   = als->in_par;
                    als_scale = als->in_scale;
                }
                break;
            case BT_KUNGE:
                if (kbail == TRUE) {
                    als_par   = als->out_par;
                    als_scale = als->out_scale;
                }
                else {
                    als_par   = als->in_par;
                    als_scale = als->in_scale;
                }
                break;
            case BT_FIRST:
                if (mbail == TRUE || kbail == TRUE) {
                    als_par   = als->out_par;
                    als_scale = als->out_scale;
                }
                else {
                    als_par   = als->in_par;
                    als_scale = als->in_scale;
                }
                break;
            case BT_BOTH:
                if (mbail == TRUE && kbail == TRUE) {
                    als_par   = als->out_par;
                    als_scale = als->out_scale;
                }
                else {
                    als_par   = als->in_par;
                    als_scale = als->in_scale;
                }
                break;
            default: printf("\nthis sucks");
        }
        switch(als_par) {
                        case PAR_Z:         val = mz;       break;
                        case PAR_RE:        val = mre;      break;
                        case PAR_IM:        val = mim;      break;
                        case PAR_RE2:       val = mre2;     break;
                        case PAR_IM2:       val = mim2;     break;
                        case PAR_LRE:       val = lre;      break;
                        case PAR_LIM:       val = lim;      break;
                        case PAR_LRE2:      val = lre2;     break;
                        case PAR_LIM2:      val = lim2;     break;
                        case PAR_KZ:        val = kz;       break;
                        case PAR_KRE:       val = kre;      break;
                        case PAR_KIM:       val = kim;      break;
                        case PAR_KRE2:      val = kre2;     break;
                        case PAR_KIM2:      val = kim2;     break;
                        case PAR_SIN_Z:     val = sin(mz);  break;
                        case PAR_COS_Z:     val = cos(mz);  break;
                        case PAR_SIN_RE:    val = sin(mre); break;
                        case PAR_COS_RE:    val = cos(mre); break;
                        case PAR_SIN_IM:    val = sin(mim); break;
                        case PAR_COS_IM:    val = cos(mim); break;
                        case PAR_SIN_RE2:   val = sin(mre2);break;
                        case PAR_COS_RE2:   val = cos(mre2);break;
                        case PAR_SIN_IM2:   val = sin(mim2);break;
                        case PAR_COS_IM2:   val = cos(mim2);break;
                        case PAR_SIN_LRE:   val = sin(lre); break;
                        case PAR_COS_LRE:   val = cos(lre); break;
                        case PAR_SIN_LIM:   val = sin(lim); break;
                        case PAR_COS_LIM:   val = cos(lim); break;
                        case PAR_SIN_LRE2:  val = sin(lre2);break;
                        case PAR_COS_LRE2:  val = cos(lre2);break;
                        case PAR_SIN_LIM2:  val = sin(lim2);break;
                        case PAR_COS_LIM2:  val = cos(lim2);break;
                        case PAR_SIN_KZ:    val = sin(kz);  break;
                        case PAR_COS_KZ:    val = cos(kz);  break;
                        case PAR_SIN_KRE:   val = sin(kre); break;
                        case PAR_COS_KRE:   val = cos(kre); break;
                        case PAR_SIN_KIM:   val = sin(kim); break;
                        case PAR_COS_KIM:   val = cos(kim); break;
                        case PAR_SIN_KRE2:  val = sin(kre2);break;
                        case PAR_COS_KRE2:  val = cos(kre2);break;
                        case PAR_SIN_KIM2:  val = sin(kim2);break;
                        case PAR_COS_KIM2:  val = cos(kim2);break;
                        case PAR_LOG_Z:     val = log(mz);  break;
                        case PAR_LOG_RE:    val = log(mre); break;
                        case PAR_LOG_IM:    val = log(mim); break;
                        case PAR_LOG_RE2:   val = log(mre2);break;
                        case PAR_LOG_IM2:   val = log(mim2);break;
                        case PAR_LOG_LRE:   val = log(lre); break;
                        case PAR_LOG_LIM:   val = log(lim); break;
                        case PAR_LOG_LRE2:  val = log(lre2);break;
                        case PAR_LOG_LIM2:  val = log(lim2);break;
                        case PAR_LOG_KZ:    val = log(kz);  break;
                        case PAR_LOG_KRE:   val = log(kre); break;
                        case PAR_LOG_KIM:   val = log(kim); break;
                        case PAR_LOG_KRE2:  val = log(kre2);break;
                        case PAR_LOG_KIM2:  val = log(kim2);break;
                        case PAR_A:     val = als_result[0];break;
                        case PAR_B:     val = als_result[1];break;
                        case PAR_C:     val = als_result[2];break;
                        case PAR_D:     val = als_result[3];break;
                        case PAR_E:     val = als_result[4];break;
                        case PAR_F:     val = als_result[5];break;
                        case PAR_SIN_A: val = sin(als_result[0]); break;
                        case PAR_COS_A: val = cos(als_result[0]); break;
                        case PAR_SIN_B: val = sin(als_result[1]); break;
                        case PAR_COS_B: val = cos(als_result[1]); break;
                        case PAR_SIN_C: val = sin(als_result[2]); break;
                        case PAR_COS_C: val = cos(als_result[2]); break;
                        case PAR_SIN_D: val = sin(als_result[3]); break;
                        case PAR_COS_D: val = cos(als_result[3]); break;
                        case PAR_SIN_E: val = sin(als_result[4]); break;
                        case PAR_COS_E: val = cos(als_result[4]); break;
                        case PAR_SIN_F: val = sin(als_result[5]); break;
                        case PAR_COS_F: val = cos(als_result[5]); break;
                        case PAR_LOG_A: val = log(als_result[0]); break;
                        case PAR_LOG_B: val = log(als_result[1]); break;
                        case PAR_LOG_C: val = log(als_result[2]); break;
                        case PAR_LOG_D: val = log(als_result[3]); break;
                        case PAR_LOG_E: val = log(als_result[4]); break;
                        case PAR_LOG_F: val = log(als_result[5]); break;
                        case PAR_N1:    val = ups->numbers[0];    break;
                        case PAR_N2:    val = ups->numbers[1];    break;
                        case PAR_N3:    val = ups->numbers[2];    break;
                        case PAR_N4:    val = ups->numbers[3];    break;
                        case PAR_N5:    val = ups->numbers[4];    break;
                        case PAR_N6:    val = ups->numbers[5];    break;
                        default:        val = UINT_MAX;
         }
                bail_st += bail_sz;
                pert_re_st += pert_re_sz;
                pert_im_st += pert_im_sz;
                als_col += val;
                layers--;
             } while (layers > 0);
        }
        img->raw_data[img->lines_done * img->real_width + ix] 
                = frs_col * frs_scale + als_col * als_scale;
    }
    img->lines_done++;
}

void filestr_to_imagestr(imginfo* fstr, image_info* istr)
{
    istr->xmin = fstr->xmin;
    istr->xmax = fstr->xmax;
    istr->ymax = fstr->ymax;
    istr->old_xmin = fstr->old_xmin;
    istr->old_xmax = fstr->old_xmax;
    istr->old_ymax = fstr->old_ymax;
    istr->depth = fstr->depth;
    istr->j_pre = fstr->j_pre;
    istr->real_width = fstr->real_width;
    istr->real_height = fstr->real_height;
    istr->user_width = fstr->user_width;
    istr->user_height = fstr->user_height;
    istr->ratio = fstr->ratio;
    istr->aa_factor = fstr->aa_factor;
    istr->fr_type = fstr->fr_type;
    istr->method = fstr->method;
    istr->palette_ip = fstr->palette_ip;
    istr->u.julia.c_re = fstr->u.julia.c_re;
    istr->u.julia.c_im = fstr->u.julia.c_im;
}

void imagestr_to_filestr(image_info* istr, imginfo* fstr)
{
    fstr->xmin = istr->xmin;
    fstr->xmax = istr->xmax;
    fstr->ymax = istr->ymax;
    fstr->old_xmin = istr->old_xmin;
    fstr->old_xmax = istr->old_xmax;
    fstr->old_ymax = istr->old_ymax;
    fstr->depth = istr->depth;
    fstr->j_pre = istr->j_pre;
    fstr->real_width = istr->real_width;
    fstr->real_height = istr->real_height;
    fstr->user_width = istr->user_width;
    fstr->user_height = istr->user_height;
    fstr->ratio = istr->ratio;
    fstr->aa_factor = istr->aa_factor;
    fstr->fr_type = istr->fr_type;
    fstr->method = istr->method;
    fstr->palette_ip = istr->palette_ip;
    fstr->u.julia.c_re = istr->u.julia.c_re;
    fstr->u.julia.c_im = istr->u.julia.c_im;
}

#endif
