#ifndef FRACSET_DLG_H
#define FRACSET_DLG_H

#include <gtk/gtk.h>

#include "fractal_types.h"
#include "fractal_settings.h"

typedef struct {
    GtkWidget* dialog;

    GtkWidget* in_par;
    GtkWidget* out_par;

    GtkWidget* in_scale;
    GtkWidget* out_scale;

    GtkWidget* bail;
    GtkWidget* kunge;

    GtkWidget* bail_value;

    GtkWidget* re_pert;
    GtkWidget* im_pert;

    GtkWidget* ok_button;
    GtkWidget* apply_button;

    GtkWidget* inscale_label;
    GtkWidget* outscale_label;
    GtkWidget* frac_frame;
    GtkWidget* pert_frame;

    fractal_settings* frac_ptr;

} fracset_dialog;

void fracset_dlg_new(fracset_dialog** ptr, image_info* img);
void fracset_dlg_set(fractal_settings* fs, fracset_dialog* fsd);
void get_fractal_settings(fractal_settings* fs, fracset_dialog* fsd);

#endif
