#ifndef FRACSET_DLG_H
#include "fracset_dlg.h"

#include <stdlib.h>
#include <stdio.h>

enum {
    FS_NO_COLUMN,
    FS_NAME_COLUMN,
    FS_N_COLUMNS
};

static void update_fracset_dialog(GtkWidget* widget, fracset_dialog* fsd);
static void create_fracset_param(GtkTable* table, int init,
                              GtkWidget** widget, GtkListStore* plist,
                              fracset_dialog* fsd, int x, int y);
static void fracset_dlg_destroy(GtkWidget* widget, fracset_dialog* fsd);

void fracset_dlg_new(fracset_dialog** ptr, image_info* img)
{
    fracset_dialog* fsd;

    /* main */
    GtkWidget* vbox   = 0;

    /* drawing frame */
    GtkWidget* draw_frame= 0;
    GtkWidget* draw_hbox = 0;
    GtkWidget* in_frame  = 0;
    GtkWidget* out_frame = 0;
    GtkWidget* in_table  = 0;
    GtkWidget* out_table = 0;

    /* fractal frame */
    GtkWidget* frac_frame = 0;
    GtkWidget* frac_table = 0;

    /* perturbation frame */
    GtkWidget* pert_frame = 0;
    GtkWidget* pert_table = 0;

    /* list stores & iters for combos */
    GtkListStore* par_list  = 0;
    GtkListStore* bail_list = 0;
    GtkListStore* kunge_list= 0;

    GtkTreeIter   par_iter;
    GtkTreeIter  bail_iter;
    GtkTreeIter kunge_iter;

    /* misc */
    GtkWidget* tmp = 0;
    GtkObject* adj = 0;
    guint i = 0, y = 0;

    /* start */
    fsd = g_malloc(sizeof(fracset_dialog));
    *ptr = fsd;
    fsd->frac_ptr = &img->frac_settings;

    /* create a list store containing the parameter + operator names */
    par_list = gtk_list_store_new(
                        FS_N_COLUMNS, G_TYPE_INT, G_TYPE_STRING);
    bail_list = gtk_list_store_new(
                        FS_N_COLUMNS, G_TYPE_INT, G_TYPE_STRING);
    kunge_list = gtk_list_store_new(
                        FS_N_COLUMNS, G_TYPE_INT, G_TYPE_STRING);

    for (i = 0; i < PAR_COUNT; i++) {
        gtk_list_store_append(par_list, &par_iter);
        gtk_list_store_set( par_list, &par_iter,
                            FS_NO_COLUMN, i,
                            FS_NAME_COLUMN, draw_par_names[i],
                            -1);
    }
    for (i = 0; i < BT_COUNT; i++) {
        gtk_list_store_append(bail_list, &bail_iter);
        gtk_list_store_set( bail_list, &bail_iter,
                            FS_NO_COLUMN, i,
                            FS_NAME_COLUMN, bail_type_names[i],
                            -1);
    }
    for (i = 0; i < KT_COUNT; i++) {
        gtk_list_store_append(kunge_list, &kunge_iter);
        gtk_list_store_set( kunge_list, &kunge_iter,
                            FS_NO_COLUMN, i,
                            FS_NAME_COLUMN, kung_type_names[i],
                            -1);
    }

    fsd->dialog = gtk_dialog_new();
    g_signal_connect(GTK_OBJECT(fsd->dialog), "destroy",
                       G_CALLBACK(fracset_dlg_destroy), fsd);
    g_signal_connect(GTK_OBJECT(fsd->dialog), "destroy",
                       G_CALLBACK(gtk_widget_destroyed),
                       ptr);
    gtk_window_set_title(GTK_WINDOW(fsd->dialog), "Fractal Settings");
    gtk_window_set_resizable(GTK_WINDOW(fsd->dialog), FALSE);
    gtk_window_set_position(GTK_WINDOW(fsd->dialog), GTK_WIN_POS_MOUSE);

    /* BUTTONS */
    fsd->ok_button = gtk_button_new_with_label("OK");
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(fsd->dialog)->action_area),
                       fsd->ok_button,   TRUE, TRUE, 0);

    fsd->apply_button = gtk_button_new_with_label("Apply");
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(fsd->dialog)->action_area),
                       fsd->apply_button,TRUE, TRUE, 0);

    tmp = gtk_button_new_with_label("Dismiss");
    g_signal_connect_object(GTK_OBJECT(tmp), "clicked",
                              G_CALLBACK(gtk_widget_destroy),
                              GTK_OBJECT(fsd->dialog), G_CONNECT_SWAPPED);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(fsd->dialog)->action_area),
                       tmp,             TRUE, TRUE, 0);

    vbox = gtk_vbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(fsd->dialog)->vbox),
                                        vbox, TRUE, TRUE, 0);

    /* frames & boxes & frames & boxes */
    draw_frame = gtk_frame_new("Drawing");
    frac_frame = gtk_frame_new("Fractal");
    pert_frame = gtk_frame_new("Perturbation");
    fsd->frac_frame = frac_frame;
    fsd->pert_frame = pert_frame;

    gtk_container_set_border_width(GTK_CONTAINER(draw_frame),4);
    gtk_container_set_border_width(GTK_CONTAINER(frac_frame),4);
    gtk_container_set_border_width(GTK_CONTAINER(pert_frame),4);
    gtk_container_add(GTK_CONTAINER(vbox), draw_frame);
    gtk_container_add(GTK_CONTAINER(vbox), frac_frame);
    gtk_container_add(GTK_CONTAINER(vbox), pert_frame);

    /* just to be arkwardness */
    draw_hbox = gtk_hbox_new(FALSE, 0);
    gtk_container_add(GTK_CONTAINER(draw_frame), draw_hbox);
    in_frame = gtk_frame_new("Inside");
    out_frame= gtk_frame_new("Outside");
    gtk_container_set_border_width(GTK_CONTAINER(in_frame), 4);
    gtk_container_set_border_width(GTK_CONTAINER(out_frame),4);
    gtk_box_pack_start(GTK_BOX(draw_hbox), in_frame, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(draw_hbox), out_frame,TRUE, TRUE, 0);
    in_table  = gtk_table_new(1, 1, FALSE);
    out_table = gtk_table_new(1, 1, FALSE);
    frac_table= gtk_table_new(1, 1, FALSE);
    pert_table= gtk_table_new(1, 1, FALSE);
    gtk_container_set_border_width(GTK_CONTAINER(in_table),  4);
    gtk_container_set_border_width(GTK_CONTAINER(out_table), 4);
    gtk_container_set_border_width(GTK_CONTAINER(frac_table),4);
    gtk_container_set_border_width(GTK_CONTAINER(pert_table),4);
    gtk_table_set_row_spacings(GTK_TABLE(in_table),  4);
    gtk_table_set_row_spacings(GTK_TABLE(out_table), 4);
    gtk_table_set_row_spacings(GTK_TABLE(frac_table),4);
    gtk_table_set_row_spacings(GTK_TABLE(pert_table),4);
    gtk_container_add(GTK_CONTAINER(in_frame),  in_table);
    gtk_container_add(GTK_CONTAINER(out_frame), out_table);
    gtk_container_add(GTK_CONTAINER(frac_frame),frac_table);
    gtk_container_add(GTK_CONTAINER(pert_frame),pert_table);

    /* combos & spin buttons & combos & spin buttons*/

    /* inside par & scaling */
    y = 0;
    create_fracset_param(GTK_TABLE(in_table), fsd->frac_ptr->in_par, 
                        &fsd->in_par, par_list, fsd, 0, y);
    y++;
    tmp = gtk_label_new("Scaling:");
    gtk_misc_set_alignment(GTK_MISC(tmp), 0.0, 0.5);
    gtk_table_attach_defaults(GTK_TABLE(in_table), tmp, 0, 1, y, y+1);
    fsd->inscale_label = tmp;
    y++;
    adj = gtk_adjustment_new(fsd->frac_ptr->in_scale,
                             0.00000000001, 999999.0,
                             0.03125, 0.03125, 0.0);
    tmp = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 0.0, 12.0);
    gtk_table_attach_defaults(GTK_TABLE(in_table),tmp, 0, 1, y, y+1);
    fsd->in_scale = tmp;

    /* outside par & scaling */
    y = 0;
    create_fracset_param(GTK_TABLE(out_table), fsd->frac_ptr->out_par,
                        &fsd->out_par, par_list, fsd, 0, y);
    y++;
    tmp = gtk_label_new("Scaling:");
    gtk_misc_set_alignment(GTK_MISC(tmp), 0.0, 0.5);
    gtk_table_attach_defaults(GTK_TABLE(out_table), tmp, 0, 1, y, y+1);
    fsd->outscale_label = tmp;
    y++;
    adj = gtk_adjustment_new(fsd->frac_ptr->out_scale,
                             0.00000000001, 999999.0,
                             0.03125, 0.03125, 0.0);
    tmp = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 0.0, 12.0);
    gtk_table_attach_defaults(GTK_TABLE(out_table), tmp, 0, 1, y, y+1);
    fsd->out_scale = tmp;

    /* fractal - bail type */
    y = 0;
    tmp = gtk_label_new("Bail type:");
    gtk_misc_set_alignment(GTK_MISC(tmp), 0.0, 0.5);
    gtk_table_attach_defaults(GTK_TABLE(frac_table), tmp, 0, 1, y, y+1);
    create_fracset_param(GTK_TABLE(frac_table), fsd->frac_ptr->bail,
                        &fsd->bail, bail_list, fsd, 1, y);
    /* fractal - kunge type */
    y++;
    tmp = gtk_label_new("Kunge type:");
    gtk_misc_set_alignment(GTK_MISC(tmp), 0.0, 0.5);
    gtk_table_attach_defaults(GTK_TABLE(frac_table), tmp, 0, 1, y, y+1);
    create_fracset_param(GTK_TABLE(frac_table), fsd->frac_ptr->kunge,
                        &fsd->kunge, kunge_list, fsd, 1, y);
    /* bailout */
    y++;
    tmp = gtk_label_new("Bailout:");
    gtk_misc_set_alignment(GTK_MISC(tmp), 0.0, 0.5);
    gtk_table_attach_defaults(GTK_TABLE(frac_table), tmp, 0,1,y,y+1);
    adj = gtk_adjustment_new(fsd->frac_ptr->bail_value,
                             0.00000000001, 999999.0,
                             0.03125, 0.03125, 0.0);
    tmp = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 0.0, 12.0);
    gtk_table_attach_defaults(GTK_TABLE(frac_table), tmp, 1,2,y,y+1);
    fsd->bail_value = tmp;
    /* perturbation */
    y = 0;
    tmp = gtk_label_new("Real:");
    gtk_misc_set_alignment(GTK_MISC(tmp), 0.0, 0.5);
    gtk_table_attach_defaults(GTK_TABLE(pert_table), tmp, 0,1,y,y+1);
    adj = gtk_adjustment_new(fsd->frac_ptr->re_pert,
                             -99.0, 99.0, 0.03125, 0.03125, 0.0);
    tmp = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 0.0, 12.0);
    gtk_table_attach_defaults(GTK_TABLE(pert_table), tmp, 1,2,y,y+1);
    fsd->re_pert = tmp;
    y++;
    tmp = gtk_label_new("Imaginary:");
    gtk_misc_set_alignment(GTK_MISC(tmp), 0.0, 0.5);
    gtk_table_attach_defaults(GTK_TABLE(pert_table), tmp, 0,1,y,y+1);
    adj = gtk_adjustment_new(fsd->frac_ptr->im_pert,
                             -99.0, 99.0, 0.03125, 0.03125, 0.0);
    tmp = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 0.0, 12.0);
    gtk_table_attach_defaults(GTK_TABLE(pert_table), tmp, 1,2,y,y+1);
    fsd->im_pert = tmp;

    update_fracset_dialog(NULL, fsd);
    gtk_widget_show_all(fsd->dialog);
}

void fracset_dlg_set(fractal_settings* fs, fracset_dialog* fsd)
{
    gtk_combo_box_set_active(GTK_COMBO_BOX(fsd->in_par), fs->in_par);
    gtk_combo_box_set_active(GTK_COMBO_BOX(fsd->out_par),fs->out_par);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(fsd->in_scale),
                                                        fs->in_scale);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(fsd->out_scale),
                                                        fs->out_scale);
    gtk_combo_box_set_active(GTK_COMBO_BOX(fsd->kunge), fs->kunge);
    gtk_combo_box_set_active(GTK_COMBO_BOX(fsd->bail),  fs->bail);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(fsd->bail_value),
                                                        fs->bail_value);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(fsd->re_pert),
                                                        fs->re_pert);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(fsd->im_pert),
                                                        fs->im_pert);
}

void get_fractal_settings(fractal_settings* fs, fracset_dialog* fsd)
{
    fs->in_par  = gtk_combo_box_get_active(GTK_COMBO_BOX(fsd->in_par));
    fs->out_par = gtk_combo_box_get_active(GTK_COMBO_BOX(fsd->out_par));
    fs->in_scale = gtk_spin_button_get_value(
                                GTK_SPIN_BUTTON(fsd->in_scale));
    fs->out_scale= gtk_spin_button_get_value(
                                GTK_SPIN_BUTTON(fsd->out_scale));
    fs->kunge= gtk_combo_box_get_active(GTK_COMBO_BOX(fsd->kunge));
    fs->bail = gtk_combo_box_get_active(GTK_COMBO_BOX(fsd->bail));
    fs->bail_value = gtk_spin_button_get_value(
                        GTK_SPIN_BUTTON(fsd->bail_value));
    fs->re_pert = gtk_spin_button_get_value(
                        GTK_SPIN_BUTTON(fsd->re_pert));
    fs->im_pert = gtk_spin_button_get_value(
                        GTK_SPIN_BUTTON(fsd->im_pert));
}

static void update_fracset_dialog(GtkWidget* widget, fracset_dialog* fsd)
{
    dr_par p1 = gtk_combo_box_get_active(GTK_COMBO_BOX(fsd->in_par));
    dr_par p2 = gtk_combo_box_get_active(GTK_COMBO_BOX(fsd->out_par));
    if (p1 == PAR_OFF && p2 == PAR_OFF) {
        gtk_widget_set_sensitive(fsd->frac_frame, FALSE);
        gtk_widget_set_sensitive(fsd->pert_frame, FALSE);
    }
    else {
        gtk_widget_set_sensitive(fsd->frac_frame, TRUE);
        gtk_widget_set_sensitive(fsd->pert_frame, TRUE);
    }
    if (p1 == PAR_OFF) {
        gtk_widget_set_sensitive(fsd->in_scale, FALSE);
        gtk_widget_set_sensitive(fsd->inscale_label, FALSE);
    }
    else {
        gtk_widget_set_sensitive(fsd->in_scale, TRUE);
        gtk_widget_set_sensitive(fsd->inscale_label, TRUE);
    }
    if (p2 == PAR_OFF) {
        gtk_widget_set_sensitive(fsd->out_scale, FALSE);
        gtk_widget_set_sensitive(fsd->outscale_label, FALSE);
    }
    else {
        gtk_widget_set_sensitive(fsd->out_scale, TRUE);
        gtk_widget_set_sensitive(fsd->outscale_label, TRUE);
    }
    return;
}

static void create_fracset_param(GtkTable* table, int init,
                              GtkWidget** widget, GtkListStore* plist,
                              fracset_dialog* fsd, int x, int y)
{
    GtkWidget* combo;
    GtkCellRenderer* renderer;

    combo = gtk_combo_box_new_with_model(GTK_TREE_MODEL(plist));
    gtk_combo_box_set_active(GTK_COMBO_BOX(combo), init);
    renderer = gtk_cell_renderer_text_new();
    gtk_cell_layout_pack_start(GTK_CELL_LAYOUT(combo), renderer, FALSE);
    gtk_cell_layout_set_attributes (GTK_CELL_LAYOUT(combo), 
                                    renderer, "text", 1, NULL);
    gtk_table_attach_defaults(GTK_TABLE(table), combo, x, x+1, y, y+1);
    g_signal_connect(GTK_OBJECT(combo), "changed",
                     G_CALLBACK(update_fracset_dialog), fsd);
    *widget = combo;
}

static void fracset_dlg_destroy(GtkWidget* widget, fracset_dialog* fsd)
{
    g_free(fsd);
}

#endif
