#ifndef DATATYPES_H
#define DATATYPES_H

#include <gtk/gtk.h>

/*  Edit the line "#define USER_MAX_PARS" to 
    increase/decrease how many parameters and 
    operators you want to use.  */
#define USER_MAX_PARS 6
#define USER_MAX_OPS (USER_MAX_PARS - 1)

#define PAR_NAME_SIZE 12
#define OP_NAME_SIZE 5
#define BT_NAME_SIZE 9
#define KT_NAME_SIZE 12

/*  set at six, so you will find in enum below:
    PAR_A... ...PAR_F.  I don't know better way */
#define MAX_PAR_SETS 6
#define MAX_NUMS 6

typedef enum DRAW_PARS {
    PAR_OFF = 0,
    /* standard parameters */
    PAR_Z,
    PAR_RE,
    PAR_IM,
    PAR_RE2,
    PAR_IM2,
    PAR_LRE,
    PAR_LIM,
    PAR_LRE2,
    PAR_LIM2,
    PAR_KZ,
    PAR_KRE,
    PAR_KIM,
    PAR_KRE2,
    PAR_KIM2,
    PAR_SIN_Z,
    PAR_COS_Z,
    PAR_SIN_RE,
    PAR_COS_RE,
    PAR_SIN_IM,
    PAR_COS_IM,
    PAR_SIN_RE2,
    PAR_COS_RE2,
    PAR_SIN_IM2,
    PAR_COS_IM2,
    PAR_SIN_LRE,
    PAR_COS_LRE,
    PAR_SIN_LIM,
    PAR_COS_LIM,
    PAR_SIN_LRE2,
    PAR_COS_LRE2,
    PAR_SIN_LIM2,
    PAR_COS_LIM2,
    PAR_SIN_KZ,
    PAR_COS_KZ,
    PAR_SIN_KRE,
    PAR_COS_KRE,
    PAR_SIN_KIM,
    PAR_COS_KIM,
    PAR_SIN_KRE2,
    PAR_COS_KRE2,
    PAR_SIN_KIM2,
    PAR_COS_KIM2,
    PAR_LOG_Z,
    PAR_LOG_RE,
    PAR_LOG_IM,
    PAR_LOG_RE2,
    PAR_LOG_IM2,
    PAR_LOG_LRE,
    PAR_LOG_LIM,
    PAR_LOG_LRE2,
    PAR_LOG_LIM2,
    PAR_LOG_KZ,
    PAR_LOG_KRE,
    PAR_LOG_KIM,
    PAR_LOG_KRE2,
    PAR_LOG_KIM2,
    /* insert new PAR_ between here */
    /* and here, but not below */
    PAR_A,
    PAR_B,
    PAR_C,
    PAR_D,
    PAR_E,
    PAR_F,
    PAR_SIN_A,
    PAR_COS_A,
    PAR_SIN_B,
    PAR_COS_B,
    PAR_SIN_C,
    PAR_COS_C,
    PAR_SIN_D,
    PAR_COS_D,
    PAR_SIN_E,
    PAR_COS_E,
    PAR_SIN_F,
    PAR_COS_F,
    PAR_LOG_A,
    PAR_LOG_B,
    PAR_LOG_C,
    PAR_LOG_D,
    PAR_LOG_E,
    PAR_LOG_F,
    /* these PAR_Nn MUST be very last */
    PAR_N1,
    PAR_N2,
    PAR_N3,
    PAR_N4,
    PAR_N5,
    PAR_N6,
    PAR_COUNT
} dr_par;

typedef enum DRAW_OPS {
    OP_OFF = 0,
    OP_ADD,
    OP_SUB,
    OP_MUL,
    OP_DIV,
    OP_MIN,
    OP_MAX,
    OP_COUNT
} dr_op;

typedef enum BAIL_TYPES{
    BT_MAND,
    BT_KUNGE,
    BT_FIRST,
    BT_BOTH,
    BT_COUNT
} bail_type;

typedef enum KUNGE_TYPES {
    KT_OFF,
    KT_XR2,
    KT_GTI,
    KT_AFX,
    KT_NSX,
    KT_RPM,
    KT_XR2MKII,
    KT_XR2MKIII,
    KT_GTIMKII,
    KT_MTB,
    KT_COUNT
} kunge_type;

extern gchar
    draw_par_names[PAR_COUNT][PAR_NAME_SIZE];

extern gchar
    draw_op_names[OP_COUNT][OP_NAME_SIZE];

extern gchar
    bail_type_names[BT_COUNT][BT_NAME_SIZE];
    
extern gchar
    kung_type_names[KT_COUNT][KT_NAME_SIZE];

#endif
