#ifndef AUTOLAYER_H
#define AUTOLAYER_H

#include "datatypes.h"

typedef struct
{
/*  general settings ... */
    dr_par  in_par;
    dr_par  out_par;
    double  in_scale;
    double  out_scale;
    kunge_type  kunge;
    bail_type   bail;
    int layer_count;

/*  ??_start    -   this value at first layer
    ??_end      -   this value at last layer */
    double bail_start;
    double bail_end;
    double pert_re_start;
    double pert_re_end;
    double pert_im_start;
    double pert_im_end;

/*  slopes      -   modify values above as we go down the iters
    it takes the iter on bailout from the main fractal for this.
    the above values are modified by a ratio below. */
    int count_min_iter;
    int count_max_iter;
    float count_min_rt;
    float count_max_rt;
    int bail_min_iter;
    int bail_max_iter;
    float bail_min_rt;
    float bail_max_rt;
    int pert_min_iter;
    int pert_max_iter;
    float pert_re_min_rt;
    float pert_re_max_rt;
    float pert_im_min_rt;
    float pert_im_max_rt;

} auto_layer;

void init_auto_layer(auto_layer* al);
void copy_auto_layer(auto_layer* src, auto_layer* dest);

#endif
