#ifndef AUTOLAYER_H
#include "autolayer.h"

#include "fractal_settings.h"

void init_auto_layer(auto_layer* al)
{
    if (al == NULL)
        return;
    al->in_par = PAR_OFF;
    al->out_par = PAR_OFF;
    al->in_scale = 1.0;
    al->out_scale = 1.0;
    al->kunge = KT_OFF;
    al->bail = BT_MAND;
    al->layer_count = 16;
    al->bail_start = 2.0;
    al->bail_end   = 6.0;
    al->pert_re_start = 0.0;
    al->pert_re_end = 0.0;
    al->pert_im_start = 0.0;
    al->pert_im_end = 0.0;
    al->count_min_iter = 0;
    al->count_max_iter = 100;
    al->count_min_rt = 1.0;
    al->count_max_rt = 1.0;
    al->bail_min_iter = 0;
    al->bail_max_iter = 100;
    al->bail_min_rt = 1.0;
    al->bail_max_rt = 1.0;
    al->pert_min_iter = 0;
    al->pert_max_iter = 100;
    al->pert_re_min_rt = 1.0;
    al->pert_re_max_rt = 1.0;
    al->pert_im_min_rt = 1.0;
    al->pert_im_max_rt = 1.0;
}

void copy_auto_layer(auto_layer* src, auto_layer* dest)
{
    if (src == NULL || dest == NULL)
        return;
    dest->in_par = src->in_par;
    dest->out_par = src->out_par;
    dest->in_scale = src->in_scale;
    dest->out_scale = src->out_scale;
    dest->kunge = src->kunge;
    dest->bail = src->bail;
    dest->layer_count = src->layer_count;
    dest->bail_start = src->bail_start;
    dest->bail_end = src->bail_end;
    dest->pert_re_start = src->pert_re_start;
    dest->pert_re_end = src->pert_re_end;
    dest->pert_im_start = src->pert_im_start;
    dest->pert_im_end = src->pert_im_end;
    dest->count_min_iter = src->count_min_iter;
    dest->count_max_iter = src->count_max_iter;
    dest->count_min_rt = src->count_min_rt;
    dest->count_max_rt = src->count_max_rt;
    dest->bail_min_iter = src->bail_min_iter;
    dest->bail_max_iter = src->bail_max_iter;
    dest->bail_min_rt = src->bail_min_rt;
    dest->bail_max_rt = src->bail_max_rt;
    dest->pert_min_iter = src->pert_min_iter;
    dest->pert_max_iter = src->pert_max_iter;
    dest->pert_re_min_rt = src->pert_re_min_rt;
    dest->pert_re_max_rt = src->pert_re_max_rt;
    dest->pert_im_min_rt = src->pert_im_min_rt;
    dest->pert_im_max_rt = src->pert_im_max_rt;
}

#endif
