#ifndef AUTOLAY_DLG_H
#define AUTOLAY_DLG_H

#include <gtk/gtk.h>

#include "fractal_types.h"
#include "autolayer.h"

typedef struct {
    GtkWidget* dialog;

    GtkWidget* in_par;
    GtkWidget* out_par;

    GtkWidget* in_scale;
    GtkWidget* out_scale;

    GtkWidget* bail;  
    GtkWidget* kunge;

    GtkWidget* layer_count;

    GtkWidget* bail_start;
    GtkWidget* bail_end;
    
    GtkWidget* pert_re_start;
    GtkWidget* pert_re_end;
    GtkWidget* pert_im_start;
    GtkWidget* pert_im_end;

    GtkWidget* count_min_iter;
    GtkWidget* count_max_iter;

    GtkWidget* count_min_rt;
    GtkWidget* count_max_rt;
    
    GtkWidget* bail_min_iter;
    GtkWidget* bail_max_iter;
    
    GtkWidget* bail_min_rt;
    GtkWidget* bail_max_rt;

    GtkWidget* pert_min_iter;
    GtkWidget* pert_max_iter;

    GtkWidget* pert_re_min_rt;
    GtkWidget* pert_re_max_rt;

    GtkWidget* pert_im_min_rt;
    GtkWidget* pert_im_max_rt;

    GtkWidget* ok_button;
    GtkWidget* apply_button;

    GtkWidget* draw_frame;
    GtkWidget* fract_frame;
    GtkWidget* layer_frame;
    GtkWidget* slope_frame;
    GtkWidget* inscale_label;
    GtkWidget* outscale_label;

    auto_layer* autolayer_ptr;

} autolayer_dialog;

void autolayer_dlg_new(autolayer_dialog** ptr, image_info* img);
void autolayer_dlg_set(auto_layer* al, autolayer_dialog* ald);
void get_autolayer_data(auto_layer* al, autolayer_dialog* ald);

#endif
