#ifndef AUTOLAY_DLG_H
#include "autolay_dlg.h"

#include <stdlib.h>
#include <stdio.h>

enum {
    AL_NO_COLUMN,
    AL_NAME_COLUMN,
    AL_N_COLUMNS
};

static void update_auto_dialog(GtkWidget* widget, autolayer_dialog* ald);
static void create_auto_param(GtkTable* table, int init,
                              GtkWidget** widget, GtkListStore* plist,
                              autolayer_dialog* ald, int x, int y);
static void auto_dlg_destroy(GtkWidget* widget, autolayer_dialog* ald);

void autolayer_dlg_new(autolayer_dialog** ptr, image_info* img)
{
    autolayer_dialog* ald;

    /* main */
    GtkWidget* vbox   = 0;
    GtkWidget* hbox   = 0;
    GtkWidget* vbox_l = 0;
    GtkWidget* vbox_r = 0;

    /* drawing frame */
    GtkWidget* draw_frame= 0;
    GtkWidget* draw_hbox = 0;
    GtkWidget* in_frame  = 0;
    GtkWidget* out_frame = 0;
    GtkWidget* in_table  = 0;
    GtkWidget* out_table = 0;

    /* fractal frame */
    GtkWidget* fract_frame = 0;
    GtkWidget* fract_table = 0;

    /* layer frame */
    GtkWidget* layer_frame   = 0;
    GtkWidget* layer_vbox    = 0;
    GtkWidget* layer_c_frame = 0;
    GtkWidget* layer_c_table = 0;
    GtkWidget* layer_f_frame = 0;
    GtkWidget* layer_f_table = 0;
    GtkWidget* layer_l_frame = 0;
    GtkWidget* layer_l_table = 0;

    /* slope frame */
    GtkWidget* slope_frame  = 0;
    GtkWidget* slope_vbox   = 0;
    GtkWidget* slope_c_table= 0;
    GtkWidget* slope_c_frame= 0;
    GtkWidget* slope_b_table= 0;
    GtkWidget* slope_b_frame= 0;
    GtkWidget* slope_p_table= 0;
    GtkWidget* slope_p_frame= 0;

    /* list stores & iters for combos */
    GtkListStore* par_list  = 0;
    GtkListStore* bail_list = 0;
    GtkListStore* kunge_list= 0;

    GtkTreeIter   par_iter;
    GtkTreeIter  bail_iter;
    GtkTreeIter kunge_iter;

    /* misc */
    GtkWidget* tmp = 0;
    GtkObject* adj = 0;
    guint i = 0, y = 0;

    /* start */
    ald = g_malloc(sizeof(autolayer_dialog));
    *ptr = ald;
    ald->autolayer_ptr = &img->auto_settings;

    /* create a list store containing the parameter + operator names */
    par_list = gtk_list_store_new(
                        AL_N_COLUMNS,G_TYPE_INT, G_TYPE_STRING);
    bail_list = gtk_list_store_new(
                        AL_N_COLUMNS, G_TYPE_INT, G_TYPE_STRING);
    kunge_list = gtk_list_store_new(
                        AL_N_COLUMNS, G_TYPE_INT, G_TYPE_STRING);

    for (i = 0; i < PAR_COUNT; i++) {
        gtk_list_store_append(par_list, &par_iter);
        gtk_list_store_set( par_list, &par_iter,
                            AL_NO_COLUMN, i,
                            AL_NAME_COLUMN, draw_par_names[i],
                            -1);
    }
    for (i = 0; i < BT_COUNT; i++) {
        gtk_list_store_append(bail_list, &bail_iter);
        gtk_list_store_set( bail_list, &bail_iter,
                            AL_NO_COLUMN, i,
                            AL_NAME_COLUMN, bail_type_names[i],
                            -1);
    }
    for (i = 0; i < KT_COUNT; i++) {
        gtk_list_store_append(kunge_list, &kunge_iter);
        gtk_list_store_set( kunge_list, &kunge_iter,
                            AL_NO_COLUMN, i,
                            AL_NAME_COLUMN, kung_type_names[i],
                            -1);
    }

    ald->dialog = gtk_dialog_new();
    g_signal_connect(GTK_OBJECT(ald->dialog), "destroy",
                       G_CALLBACK(auto_dlg_destroy), ald);
    g_signal_connect(GTK_OBJECT(ald->dialog), "destroy",
                       G_CALLBACK(gtk_widget_destroyed),
                       ptr);
    gtk_window_set_title(GTK_WINDOW(ald->dialog), "Auto Layer Settings");
    gtk_window_set_resizable(GTK_WINDOW(ald->dialog), FALSE);
    gtk_window_set_position(GTK_WINDOW(ald->dialog), GTK_WIN_POS_MOUSE);

    /* BUTTONS */
    ald->ok_button = gtk_button_new_with_label("OK");
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(ald->dialog)->action_area),
                       ald->ok_button,   TRUE, TRUE, 0);

    ald->apply_button = gtk_button_new_with_label("Apply");
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(ald->dialog)->action_area),
                       ald->apply_button,TRUE, TRUE, 0);

    tmp = gtk_button_new_with_label("Dismiss");
    g_signal_connect_object(GTK_OBJECT(tmp), "clicked",
                              G_CALLBACK(gtk_widget_destroy),
                              GTK_OBJECT(ald->dialog), G_CONNECT_SWAPPED);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(ald->dialog)->action_area), 
                       tmp,             TRUE, TRUE, 0);

    vbox = gtk_vbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(GTK_DIALOG(ald->dialog)->vbox),
                                        vbox, TRUE, TRUE, 0);
    hbox   = gtk_hbox_new(FALSE, 0);
    vbox_l = gtk_vbox_new(FALSE, 0);
    vbox_r = gtk_vbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(vbox), hbox,  TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(hbox), vbox_l,TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(hbox), vbox_r,TRUE, TRUE, 0);

    /* frames & boxes & frames & boxes */
    draw_frame  = gtk_frame_new("Drawing");
    fract_frame = gtk_frame_new("Fractal");
    layer_frame = gtk_frame_new("Automation");
    slope_frame = gtk_frame_new("Slopes");
    gtk_container_set_border_width(GTK_CONTAINER(draw_frame), 4);
    gtk_container_set_border_width(GTK_CONTAINER(fract_frame),4);
    gtk_container_set_border_width(GTK_CONTAINER(layer_frame),4);
    gtk_container_set_border_width(GTK_CONTAINER(slope_frame),4);
    gtk_container_add(GTK_CONTAINER(vbox_l), draw_frame);
    gtk_container_add(GTK_CONTAINER(vbox_l), fract_frame);
    gtk_container_add(GTK_CONTAINER(vbox_l), layer_frame);
    gtk_container_add(GTK_CONTAINER(vbox_r), slope_frame);
    ald->draw_frame  = draw_frame;
    ald->fract_frame = fract_frame;
    ald->layer_frame = layer_frame;
    ald->slope_frame = slope_frame;

    /* just to be arkwardness */
    draw_hbox = gtk_hbox_new(FALSE, 0);
    layer_vbox= gtk_vbox_new(FALSE, 0);
    slope_vbox= gtk_vbox_new(FALSE, 0);
    gtk_container_add(GTK_CONTAINER(draw_frame), draw_hbox);
    gtk_container_add(GTK_CONTAINER(layer_frame),layer_vbox);
    gtk_container_add(GTK_CONTAINER(slope_frame),slope_vbox);
    in_frame      = gtk_frame_new("Inside");
    out_frame     = gtk_frame_new("Outside");
    layer_c_frame = gtk_frame_new("Layers");
    layer_f_frame = gtk_frame_new("First Layer");
    layer_l_frame = gtk_frame_new("Last Layer");
    slope_c_frame = gtk_frame_new("Layer Count Slope");
    slope_b_frame = gtk_frame_new("Bailout Slope");
    slope_p_frame = gtk_frame_new("Perturbation Slope");
    gtk_container_set_border_width(GTK_CONTAINER(in_frame),     4);
    gtk_container_set_border_width(GTK_CONTAINER(out_frame),    4);
    gtk_container_set_border_width(GTK_CONTAINER(layer_c_frame),4);
    gtk_container_set_border_width(GTK_CONTAINER(layer_f_frame),4);
    gtk_container_set_border_width(GTK_CONTAINER(layer_l_frame),4);
    gtk_container_set_border_width(GTK_CONTAINER(slope_c_frame),4);
    gtk_container_set_border_width(GTK_CONTAINER(slope_b_frame),4);
    gtk_container_set_border_width(GTK_CONTAINER(slope_p_frame),4);
    gtk_box_pack_start(GTK_BOX(draw_hbox), in_frame,      TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(draw_hbox), out_frame,     TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(layer_vbox),layer_c_frame, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(layer_vbox),layer_f_frame, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(layer_vbox),layer_l_frame, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(slope_vbox),slope_c_frame, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(slope_vbox),slope_b_frame, TRUE, TRUE, 0);
    gtk_box_pack_start(GTK_BOX(slope_vbox),slope_p_frame, TRUE, TRUE, 0);
    in_table     = gtk_table_new(1, 1, TRUE);
    out_table    = gtk_table_new(1, 1, TRUE);
    fract_table  = gtk_table_new(1, 1, TRUE);
    layer_c_table= gtk_table_new(1, 1, TRUE);
    layer_f_table= gtk_table_new(1, 1, TRUE);
    layer_l_table= gtk_table_new(1, 1, TRUE);
    slope_c_table= gtk_table_new(1, 1, TRUE);
    slope_b_table= gtk_table_new(1, 1, TRUE);
    slope_p_table= gtk_table_new(1, 1, TRUE);
    gtk_container_set_border_width(GTK_CONTAINER(in_table),     4);
    gtk_container_set_border_width(GTK_CONTAINER(out_table),    4);
    gtk_container_set_border_width(GTK_CONTAINER(fract_table),  4);
    gtk_container_set_border_width(GTK_CONTAINER(layer_c_table),4);
    gtk_container_set_border_width(GTK_CONTAINER(layer_f_table),4);
    gtk_container_set_border_width(GTK_CONTAINER(layer_l_table),4);
    gtk_container_set_border_width(GTK_CONTAINER(slope_c_table),4);
    gtk_container_set_border_width(GTK_CONTAINER(slope_b_table),4);
    gtk_container_set_border_width(GTK_CONTAINER(slope_p_table),4);
    gtk_table_set_row_spacings(GTK_TABLE(in_table),     4);
    gtk_table_set_row_spacings(GTK_TABLE(out_table),    4);
    gtk_table_set_row_spacings(GTK_TABLE(fract_table),  4);
    gtk_table_set_row_spacings(GTK_TABLE(layer_c_table),4);
    gtk_table_set_row_spacings(GTK_TABLE(layer_f_table),4);
    gtk_table_set_row_spacings(GTK_TABLE(layer_l_table),4);
    gtk_table_set_row_spacings(GTK_TABLE(slope_c_table),4);
    gtk_table_set_row_spacings(GTK_TABLE(slope_b_table),4);
    gtk_table_set_row_spacings(GTK_TABLE(slope_p_table),4);
    gtk_container_add(GTK_CONTAINER(in_frame),     in_table);
    gtk_container_add(GTK_CONTAINER(out_frame),    out_table);
    gtk_container_add(GTK_CONTAINER(fract_frame),  fract_table);
    gtk_container_add(GTK_CONTAINER(layer_c_frame),layer_c_table);
    gtk_container_add(GTK_CONTAINER(layer_f_frame),layer_f_table);
    gtk_container_add(GTK_CONTAINER(layer_l_frame),layer_l_table);
    gtk_container_add(GTK_CONTAINER(slope_c_frame),slope_c_table);
    gtk_container_add(GTK_CONTAINER(slope_b_frame),slope_b_table);
    gtk_container_add(GTK_CONTAINER(slope_p_frame),slope_p_table);

    /* combos & spin buttons & combos & spin buttons*/

    /* inside par & scaling */
    y = 0;
    create_auto_param(GTK_TABLE(in_table), img->auto_settings.in_par, 
                        &ald->in_par, par_list, ald, 0, y);
    y++;
    tmp = gtk_label_new("Scaling:");
    gtk_misc_set_alignment(GTK_MISC(tmp), 0.0, 0.5);
    gtk_table_attach_defaults(GTK_TABLE(in_table), tmp, 0, 1, y, y+1);
    ald->inscale_label = tmp;
    y++;
    adj = gtk_adjustment_new(img->auto_settings.in_scale, 
                             0.00000000001, 999999.0, 
                             0.0078125, 0.0078125, 0.0);
    tmp = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 0.0, 12.0);
    gtk_table_attach_defaults(GTK_TABLE(in_table),tmp, 0, 1, y, y+1);
    ald->in_scale = tmp;

    /* outside par & scaling */
    y = 0;
    create_auto_param(GTK_TABLE(out_table),
                        img->auto_settings.out_par,
                        &ald->out_par, par_list, ald, 0, y);
    y++;
    tmp = gtk_label_new("Scaling:");
    gtk_misc_set_alignment(GTK_MISC(tmp), 0.0, 0.5);
    gtk_table_attach_defaults(GTK_TABLE(out_table), tmp, 0, 1, y, y+1);
    ald->outscale_label = tmp;
    y++;
    adj = gtk_adjustment_new(img->auto_settings.out_scale,
                             0.00000000001, 999999.0, 
                             0.0078125, 0.0078125, 0.0);
    tmp = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 0.0, 12.0);
    gtk_table_attach_defaults(GTK_TABLE(out_table),tmp, 0, 1, y, y+1);
    ald->out_scale = tmp;

    /* fractal - bail type */
    y = 0;
    tmp = gtk_label_new("Bail type:");
    gtk_misc_set_alignment(GTK_MISC(tmp), 0.0, 0.5);
    gtk_table_attach_defaults(GTK_TABLE(fract_table), tmp, 0, 1, y, y+1);
    create_auto_param(GTK_TABLE(fract_table),
                        img->auto_settings.bail,
                        &ald->bail, bail_list, ald, 1, y);
    /* fractal - kunge type */
    y++;
    tmp = gtk_label_new("Kunge type:");
    gtk_misc_set_alignment(GTK_MISC(tmp), 0.0, 0.5);
    gtk_table_attach_defaults(GTK_TABLE(fract_table), tmp, 0, 1, y, y+1);
    create_auto_param(GTK_TABLE(fract_table),
                        img->auto_settings.kunge,
                        &ald->kunge, kunge_list, ald, 1, y);

    /* layers */
    y = 0;
    tmp = gtk_label_new("Count:");
    gtk_misc_set_alignment(GTK_MISC(tmp), 0.0, 0.5);
    gtk_table_attach_defaults(GTK_TABLE(layer_c_table), tmp, 0,1,y,y+1);
    adj = gtk_adjustment_new(img->auto_settings.layer_count,
                             1.0, 99999.0, 1.0, 1.0, 0.0);
    tmp = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 0.0, 0.0);
    gtk_table_attach_defaults(GTK_TABLE(layer_c_table), tmp, 1,2,y,y+1);
    ald->layer_count = tmp;

    /* first layer */
    y = 0;
    tmp = gtk_label_new("Bailout:");
    gtk_misc_set_alignment(GTK_MISC(tmp), 0.0, 0.5);
    gtk_table_attach_defaults(GTK_TABLE(layer_f_table), tmp, 0,1,y,y+1);
    adj = gtk_adjustment_new(img->auto_settings.bail_start,
                             0.00000000001, 999999.0, 
                             0.03125, 0.03125, 0.0);
    tmp = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 0.0, 12.0);
    gtk_table_attach_defaults(GTK_TABLE(layer_f_table), tmp, 1,2,y,y+1);
    ald->bail_start = tmp;
    y++;
    tmp = gtk_label_new("Real Pertubation:");
    gtk_misc_set_alignment(GTK_MISC(tmp), 0.0, 0.5);
    gtk_table_attach_defaults(GTK_TABLE(layer_f_table), tmp, 0,1,y,y+1);
    adj = gtk_adjustment_new(img->auto_settings.pert_re_start,
                             -999.0, 999.0, 0.0078125, 0.0078125, 0.0);

    tmp = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 0.0, 12.0);
    gtk_table_attach_defaults(GTK_TABLE(layer_f_table), tmp, 1,2,y,y+1);
    ald->pert_re_start = tmp;
    y++;
    tmp = gtk_label_new("Imaginary Pertubation:");
    gtk_misc_set_alignment(GTK_MISC(tmp), 0.0, 0.5);
    gtk_table_attach_defaults(GTK_TABLE(layer_f_table), tmp, 0,1,y,y+1);
    adj = gtk_adjustment_new(img->auto_settings.pert_im_start,
                             -999.0, 999.0, 0.0078125, 0.0078125, 0.0);
    tmp = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 0.0, 12.0);
    gtk_table_attach_defaults(GTK_TABLE(layer_f_table), tmp, 1,2,y,y+1);
    ald->pert_im_start = tmp;

    /* last layer */
    y = 0;
    tmp = gtk_label_new("Bailout:");
    gtk_misc_set_alignment(GTK_MISC(tmp), 0.0, 0.5);
    gtk_table_attach_defaults(GTK_TABLE(layer_l_table), tmp, 0,1,y,y+1);
    adj = gtk_adjustment_new(img->auto_settings.bail_end,
                             0.00000000001, 999999.0, 
                             0.03125, 0.03125, 0.0);
    tmp = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 0.0, 12.0);
    gtk_table_attach_defaults(GTK_TABLE(layer_l_table), tmp, 1,2,y,y+1);
    ald->bail_end = tmp;
    y++;
    tmp = gtk_label_new("Real Pertubation:");
    gtk_misc_set_alignment(GTK_MISC(tmp), 0.0, 0.5);
    gtk_table_attach_defaults(GTK_TABLE(layer_l_table), tmp, 0,1,y,y+1);
    adj = gtk_adjustment_new(img->auto_settings.pert_re_end,
                             -999.0, 999.0, 0.0078125, 0.0078125, 0.0);
    tmp = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 0.0, 12.0);
    gtk_table_attach_defaults(GTK_TABLE(layer_l_table), tmp, 1,2,y,y+1);
    ald->pert_re_end = tmp;
    y++;
    tmp = gtk_label_new("Imaginary Pertubation:");
    gtk_misc_set_alignment(GTK_MISC(tmp), 0.0, 0.5);
    gtk_table_attach_defaults(GTK_TABLE(layer_l_table), tmp, 0,1,y,y+1);
    adj = gtk_adjustment_new(img->auto_settings.pert_im_end,
                             -999.0, 999.0, 0.0078125, 0.0078125, 0.0);
    tmp = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 0.0, 12.0);
    gtk_table_attach_defaults(GTK_TABLE(layer_l_table), tmp, 1,2,y,y+1);
    ald->pert_im_end = tmp;

    /* slopes - layer count*/
    y = 0;
    tmp = gtk_label_new("Min Iter:");
    gtk_misc_set_alignment(GTK_MISC(tmp), 0.0, 0.5);
    gtk_table_attach_defaults(GTK_TABLE(slope_c_table), tmp, 0,1,y,y+1);
    adj = gtk_adjustment_new(img->auto_settings.count_min_iter,
                             1.0, 9999999.0, 1.0, 1.0, 0.0);
    tmp = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 0.0, 0.0);
    gtk_table_attach_defaults(GTK_TABLE(slope_c_table), tmp, 1,2,y,y+1);
    ald->count_min_iter = tmp;
    y++;
    tmp = gtk_label_new("Max Iter:");
    gtk_misc_set_alignment(GTK_MISC(tmp), 0.0, 0.5);
    gtk_table_attach_defaults(GTK_TABLE(slope_c_table), tmp, 0,1,y,y+1);
    adj = gtk_adjustment_new(img->auto_settings.count_max_iter,
                             1.0, 9999999.0, 1.0, 1.0, 0.0);
    tmp = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 0.0, 0.0);
    gtk_table_attach_defaults(GTK_TABLE(slope_c_table), tmp, 1,2,y,y+1);
    ald->count_max_iter = tmp;
    y++;
    tmp = gtk_label_new("Min Ratio");
    gtk_misc_set_alignment(GTK_MISC(tmp), 0.0, 0.5);
    gtk_table_attach_defaults(GTK_TABLE(slope_c_table), tmp, 0,1,y,y+1);
    adj = gtk_adjustment_new(img->auto_settings.count_min_rt,
                             -999.0, 999.0, 0.0078125, 0.0078125, 0.0);
    tmp = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 0.0, 12.0);
    gtk_table_attach_defaults(GTK_TABLE(slope_c_table), tmp, 1,2,y,y+1);
    ald->count_min_rt = tmp;
    y++;
    tmp = gtk_label_new("Max Ratio");
    gtk_misc_set_alignment(GTK_MISC(tmp), 0.0, 0.5);
    gtk_table_attach_defaults(GTK_TABLE(slope_c_table), tmp, 0,1,y,y+1);
    adj = gtk_adjustment_new(img->auto_settings.count_max_rt,
                             -999.0, 999.0, 0.0078125, 0.0078125, 0.0);
    tmp = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 0.0, 12.0);
    gtk_table_attach_defaults(GTK_TABLE(slope_c_table), tmp, 1,2,y,y+1);
    ald->count_max_rt = tmp;

    /* slopes - bail values*/
    y = 0;
    tmp = gtk_label_new("Min Iter:");
    gtk_misc_set_alignment(GTK_MISC(tmp), 0.0, 0.5);
    gtk_table_attach_defaults(GTK_TABLE(slope_b_table), tmp, 0,1,y,y+1);
    adj = gtk_adjustment_new(img->auto_settings.bail_min_iter,
                             1.0, 9999999.0, 1.0, 1.0, 0.0);
    tmp = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 0.0, 0.0);
    gtk_table_attach_defaults(GTK_TABLE(slope_b_table), tmp, 1,2,y,y+1);
    ald->bail_min_iter = tmp;
    y++;
    tmp = gtk_label_new("Max Iter:");
    gtk_misc_set_alignment(GTK_MISC(tmp), 0.0, 0.5);
    gtk_table_attach_defaults(GTK_TABLE(slope_b_table), tmp, 0,1,y,y+1);
    adj = gtk_adjustment_new(img->auto_settings.bail_max_iter,
                             1.0, 9999999.0, 1.0, 1.0, 0.0);
    tmp = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 0.0, 0.0);
    gtk_table_attach_defaults(GTK_TABLE(slope_b_table), tmp, 1,2,y,y+1);
    ald->bail_max_iter = tmp;
    y++;
    tmp = gtk_label_new("Min Ratio");
    gtk_misc_set_alignment(GTK_MISC(tmp), 0.0, 0.5);
    gtk_table_attach_defaults(GTK_TABLE(slope_b_table), tmp, 0,1,y,y+1);
    adj = gtk_adjustment_new(img->auto_settings.bail_min_rt,
                             -999.0, 999.0, 0.0078125, 0.0078125, 0.0);
    tmp = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 0.0, 12.0);
    gtk_table_attach_defaults(GTK_TABLE(slope_b_table), tmp, 1,2,y,y+1);
    ald->bail_min_rt = tmp;
    y++;
    tmp = gtk_label_new("Max Ratio");
    gtk_misc_set_alignment(GTK_MISC(tmp), 0.0, 0.5);
    gtk_table_attach_defaults(GTK_TABLE(slope_b_table), tmp, 0,1,y,y+1);
    adj = gtk_adjustment_new(img->auto_settings.bail_max_rt,
                             -999.0, 999.0, 0.0078125, 0.0078125, 0.0);
    tmp = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 0.0, 12.0);
    gtk_table_attach_defaults(GTK_TABLE(slope_b_table), tmp, 1,2,y,y+1);
    ald->bail_max_rt = tmp;

    /* slopes - perturbation values*/
    y = 0;
    tmp = gtk_label_new("Min Iter:");
    gtk_misc_set_alignment(GTK_MISC(tmp), 0.0, 0.5);
    gtk_table_attach_defaults(GTK_TABLE(slope_p_table), tmp, 0,1,y,y+1);
    adj = gtk_adjustment_new(img->auto_settings.pert_min_iter,
                             1.0, 9999999.0, 1.0, 1.0, 0.0);
    tmp = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 0.0, 0.0);
    gtk_table_attach_defaults(GTK_TABLE(slope_p_table), tmp, 1,2,y,y+1);
    ald->pert_min_iter = tmp;
    y++;
    tmp = gtk_label_new("Max Iter:");
    gtk_misc_set_alignment(GTK_MISC(tmp), 0.0, 0.5);
    gtk_table_attach_defaults(GTK_TABLE(slope_p_table), tmp, 0,1,y,y+1);
    adj = gtk_adjustment_new(img->auto_settings.pert_max_iter,
                             1.0, 9999999.0, 1.0, 1.0, 0.0);
    tmp = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 0.0, 0.0);
    gtk_table_attach_defaults(GTK_TABLE(slope_p_table), tmp, 1,2,y,y+1);
    ald->pert_max_iter = tmp;
    y++;
    tmp = gtk_label_new("Min Real Ratio");
    gtk_misc_set_alignment(GTK_MISC(tmp), 0.0, 0.5);
    gtk_table_attach_defaults(GTK_TABLE(slope_p_table), tmp, 0,1,y,y+1);
    adj = gtk_adjustment_new(img->auto_settings.pert_re_min_rt,
                             -999.0, 999.0, 0.0078125, 0.0078125, 0.0);
    tmp = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 0.0, 12.0);
    gtk_table_attach_defaults(GTK_TABLE(slope_p_table), tmp, 1,2,y,y+1);
    ald->pert_re_min_rt = tmp;
    y++;
    tmp = gtk_label_new("Max Real Ratio");
    gtk_misc_set_alignment(GTK_MISC(tmp), 0.0, 0.5);
    gtk_table_attach_defaults(GTK_TABLE(slope_p_table), tmp, 0,1,y,y+1);
    adj = gtk_adjustment_new(img->auto_settings.pert_re_max_rt,
                             -999.0, 999.0, 0.0078125, 0.0078125, 0.0);
    tmp = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 0.0, 12.0);
    gtk_table_attach_defaults(GTK_TABLE(slope_p_table), tmp, 1,2,y,y+1);
    ald->pert_re_max_rt = tmp;
    y++;
    tmp = gtk_label_new("Min Imaginary Ratio");
    gtk_misc_set_alignment(GTK_MISC(tmp), 0.0, 0.5);
    gtk_table_attach_defaults(GTK_TABLE(slope_p_table), tmp, 0,1,y,y+1);
    adj = gtk_adjustment_new(img->auto_settings.pert_im_min_rt,
                             -999.0, 999.0, 0.0078125, 0.0078125, 0.0);
    tmp = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 0.0, 12.0);
    gtk_table_attach_defaults(GTK_TABLE(slope_p_table), tmp, 1,2,y,y+1);
    ald->pert_im_min_rt = tmp;
    y++;
    tmp = gtk_label_new("Max Imaginary Ratio");
    gtk_misc_set_alignment(GTK_MISC(tmp), 0.0, 0.5);
    gtk_table_attach_defaults(GTK_TABLE(slope_p_table), tmp, 0,1,y,y+1);
    adj = gtk_adjustment_new(img->auto_settings.pert_im_max_rt,
                             -999.0, 999.0, 0.0078125, 0.0078125, 0.0);
    tmp = gtk_spin_button_new(GTK_ADJUSTMENT(adj), 0.0, 12.0);
    gtk_table_attach_defaults(GTK_TABLE(slope_p_table), tmp, 1,2,y,y+1);
    ald->pert_im_max_rt = tmp;

    update_auto_dialog(NULL, ald);
    gtk_widget_show_all(ald->dialog);
}

void autolayer_dlg_set(auto_layer* al, autolayer_dialog* ald)
{
    gtk_combo_box_set_active (GTK_COMBO_BOX(ald->in_par),
                                                    al->in_par);
    gtk_combo_box_set_active (GTK_COMBO_BOX(ald->out_par),
                                                    al->out_par);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(ald->in_scale),
                                                    al->in_scale);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(ald->out_scale),
                                                    al->out_scale);
    gtk_combo_box_set_active (GTK_COMBO_BOX(ald->kunge),
                                                    al->kunge);
    gtk_combo_box_set_active (GTK_COMBO_BOX(ald->bail),
                                                    al->bail);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(ald->layer_count),
                                                    al->layer_count);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(ald->bail_start),
                                                    al->bail_start);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(ald->bail_end),
                                                    al->bail_end);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(ald->pert_re_start),
                                                    al->pert_re_start);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(ald->pert_re_end),
                                                    al->pert_re_end);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(ald->pert_im_start),
                                                    al->pert_im_start);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(ald->pert_im_end),
                                                    al->pert_im_end);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(ald->count_min_iter),
                                                    al->count_min_iter);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(ald->count_max_iter),
                                                    al->count_max_iter);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(ald->count_min_rt),
                                                    al->count_min_rt);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(ald->count_max_rt),
                                                    al->count_max_rt);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(ald->bail_min_iter),
                                                    al->bail_min_iter);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(ald->bail_max_iter),
                                                    al->bail_max_iter);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(ald->bail_min_rt),
                                                    al->bail_min_rt);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(ald->bail_max_rt),
                                                    al->bail_max_rt);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(ald->pert_min_iter),
                                                    al->pert_min_iter);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(ald->pert_max_iter),
                                                    al->pert_max_iter);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(ald->pert_re_min_rt),
                                                    al->pert_re_min_rt);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(ald->pert_re_max_rt),
                                                    al->pert_re_max_rt);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(ald->pert_im_min_rt),
                                                    al->pert_im_min_rt);
    gtk_spin_button_set_value(GTK_SPIN_BUTTON(ald->pert_im_max_rt),
                                                    al->pert_im_max_rt);
}

void get_autolayer_data(auto_layer* al, autolayer_dialog* ald)
{
    al->in_par = gtk_combo_box_get_active(GTK_COMBO_BOX(ald->in_par));
    al->out_par = gtk_combo_box_get_active(GTK_COMBO_BOX(ald->out_par));
    al->in_scale = gtk_spin_button_get_value(
                                GTK_SPIN_BUTTON(ald->in_scale));
    al->out_scale = gtk_spin_button_get_value(
                                GTK_SPIN_BUTTON(ald->out_scale));

    al->kunge = gtk_combo_box_get_active(GTK_COMBO_BOX(ald->kunge));
    al->bail = gtk_combo_box_get_active(GTK_COMBO_BOX(ald->bail));

    al->layer_count = gtk_spin_button_get_value_as_int(
                        GTK_SPIN_BUTTON(ald->layer_count));

    al->bail_start = gtk_spin_button_get_value(
                        GTK_SPIN_BUTTON(ald->bail_start));
    al->bail_end   = gtk_spin_button_get_value(
                        GTK_SPIN_BUTTON(ald->bail_end));

    al->pert_re_start = gtk_spin_button_get_value(
                        GTK_SPIN_BUTTON(ald->pert_re_start));
    al->pert_re_end = gtk_spin_button_get_value(
                        GTK_SPIN_BUTTON(ald->pert_re_end));
    al->pert_im_start = gtk_spin_button_get_value(
                        GTK_SPIN_BUTTON(ald->pert_im_start));
    al->pert_im_end = gtk_spin_button_get_value(
                        GTK_SPIN_BUTTON(ald->pert_im_end));

    al->count_min_iter = gtk_spin_button_get_value_as_int(
                        GTK_SPIN_BUTTON(ald->count_min_iter));
    al->count_max_iter = gtk_spin_button_get_value_as_int(
                        GTK_SPIN_BUTTON(ald->count_max_iter));

    al->count_min_rt = gtk_spin_button_get_value(
                        GTK_SPIN_BUTTON(ald->count_min_rt));
    al->count_max_rt = gtk_spin_button_get_value(
                        GTK_SPIN_BUTTON(ald->count_max_rt));

    al->bail_min_iter = gtk_spin_button_get_value_as_int(
                        GTK_SPIN_BUTTON(ald->bail_min_iter));
    al->bail_max_iter = gtk_spin_button_get_value_as_int(
                        GTK_SPIN_BUTTON(ald->bail_max_iter));

    al->bail_min_rt = gtk_spin_button_get_value(
                        GTK_SPIN_BUTTON(ald->bail_min_rt));
    al->bail_max_rt = gtk_spin_button_get_value(
                        GTK_SPIN_BUTTON(ald->bail_max_rt));

    al->pert_min_iter = gtk_spin_button_get_value_as_int(
                        GTK_SPIN_BUTTON(ald->pert_min_iter));
    al->pert_max_iter = gtk_spin_button_get_value_as_int(
                        GTK_SPIN_BUTTON(ald->pert_max_iter));

    al->pert_re_min_rt = gtk_spin_button_get_value(
                        GTK_SPIN_BUTTON(ald->pert_re_min_rt));
    al->pert_re_max_rt = gtk_spin_button_get_value(
                        GTK_SPIN_BUTTON(ald->pert_re_max_rt));

    al->pert_im_min_rt = gtk_spin_button_get_value(
                        GTK_SPIN_BUTTON(ald->pert_im_min_rt));
    al->pert_im_max_rt = gtk_spin_button_get_value(
                        GTK_SPIN_BUTTON(ald->pert_im_max_rt));
}

static void update_auto_dialog(GtkWidget* widget, autolayer_dialog* ald)
{
    dr_par ip = gtk_combo_box_get_active(GTK_COMBO_BOX(ald->in_par));
    dr_par op = gtk_combo_box_get_active(GTK_COMBO_BOX(ald->out_par));

    if (ip == PAR_OFF && op == PAR_OFF) {
        gtk_widget_set_sensitive(ald->inscale_label, FALSE);
        gtk_widget_set_sensitive(ald->outscale_label,FALSE);
        gtk_widget_set_sensitive(ald->in_scale,      FALSE);
        gtk_widget_set_sensitive(ald->out_scale,     FALSE);
        gtk_widget_set_sensitive(ald->fract_frame,   FALSE);
        gtk_widget_set_sensitive(ald->layer_frame,   FALSE);
        gtk_widget_set_sensitive(ald->slope_frame,   FALSE);
        return;
    }
    if (ip == PAR_OFF) {
        gtk_widget_set_sensitive(ald->in_scale,      FALSE);
        gtk_widget_set_sensitive(ald->inscale_label, FALSE);
    }
    else {
        gtk_widget_set_sensitive(ald->in_scale,      TRUE);
        gtk_widget_set_sensitive(ald->inscale_label, TRUE);
    }
    if (op == PAR_OFF) {
        gtk_widget_set_sensitive(ald->out_scale,     FALSE);
        gtk_widget_set_sensitive(ald->outscale_label,FALSE);
    }
    else {
        gtk_widget_set_sensitive(ald->out_scale,     TRUE);
        gtk_widget_set_sensitive(ald->outscale_label,TRUE);
    }
    gtk_widget_set_sensitive(ald->fract_frame, TRUE);
    gtk_widget_set_sensitive(ald->layer_frame, TRUE);
    gtk_widget_set_sensitive(ald->slope_frame, TRUE);
    /*
    place code here-abouts to prevent user from 
    making a MAX value less than a MIN value.
    */
}

static void create_auto_param(GtkTable* table, int init,
                              GtkWidget** widget, GtkListStore* plist,
                              autolayer_dialog* ald, int x, int y)
{
    GtkWidget* combo;
    GtkCellRenderer* renderer;

    combo = gtk_combo_box_new_with_model(GTK_TREE_MODEL(plist));
    gtk_combo_box_set_active(GTK_COMBO_BOX(combo), init);
    renderer = gtk_cell_renderer_text_new();
    gtk_cell_layout_pack_start(GTK_CELL_LAYOUT(combo), renderer, FALSE);
    gtk_cell_layout_set_attributes (GTK_CELL_LAYOUT(combo), 
                                    renderer, "text", 1, NULL);
    gtk_table_attach_defaults(GTK_TABLE(table), combo, x, x+1, y, y+1);
    g_signal_connect(GTK_OBJECT(combo), "changed",
                     G_CALLBACK(update_auto_dialog), ald);
    *widget = combo;
}

static void auto_dlg_destroy(GtkWidget* widget, autolayer_dialog* ald)
{
    g_free(ald);
}

#endif
