/* Ghost In The Mail (gitmail)
 *  Copyright (C) 2004-2005 Clément Plantier <clem38fr at users dot sf.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "socket.h"

GtkWidget *button;
GtkWidget *progressbar;
GtkWidget *button;
GtkWidget *statusbar1;
guint context;

char *coded_data;

void * sendamail(maildata *mdata) {
	
	int sd = 0, err = 0;
	char *server, *name, *to, *subject, *filepath, *text, *from;
	
	server = (char *) malloc (strlen (mdata->server) + 1);
	name = (char *) malloc (strlen (mdata->name) + 1);
	to = (char *) malloc (strlen (mdata->to) + 1);
	subject = (char *) malloc (strlen (mdata->subject) + 1);
	filepath = (char *) malloc (strlen (mdata->filepath) + 1);
	text = (char *) malloc (strlen (mdata->text) + 1);
	from = (char *) malloc (strlen (mdata->from) + 1);
	
	strcpy (server,mdata->server);
	strcpy (from,mdata->from);
	strcpy (name,mdata->name);
	strcpy (to,mdata->to);
	strcpy (subject,mdata->subject);
	strcpy (filepath,mdata->filepath);
	strcpy (text,mdata->text);

	sem_post (&mdata->sema);
	
	lookup_all_widgets();
	
	name = (char*) realloc (name, strlen(name) * 2 + 1);
	subject = (char*) realloc (subject, strlen(subject) * 2 + 1);
	text = (char*) realloc (text, strlen(text) * 2 + 1);
	convertion (name, subject, text);
	
	if (strlen (filepath))
		encode_file(filepath);
	
	if (strlen(server)) {
		sd = initconnection (server, sd);
		if (!sd) {
			showerror ("Connection Error !\n Gitmail cannot connect to the smtp server\nCheck your internet connection");
			return 0;			
		}
	} else	printf ("\nWarning ! Test without connection\n");
	
	if (sd >= 0) {	
		char errorstr[16];
		err = transmitinfo (&sd, from, to);
		if (err) {
			sprintf (errorstr, "Error %d", err);
			showerror (errorstr);
			return 0;
		}
		
		err = transmitdata (&sd, from, name, to, subject, text, filepath);
		statusbarsettext (NULL);
		if (err != 0) {
			sprintf (errorstr, "Error %d", err);
			showerror (errorstr);
			return 0;
		}
		close (sd);
	}
	
	progressbarsetfraction(0);
	
	gdk_threads_enter ();
	window2 = create_window2 ();
	gtk_widget_show (window2);
	gtk_widget_set_sensitive (button, TRUE);
	gdk_threads_leave ();
	
	return 0;
}

void encode_file (char *filepath) {
	
	/*format file name without path*/
	int k;
	char *filename = (char*) malloc (strlen (filepath));
	k = strlen (filepath);
	while (filepath[k] != '/')
		k--;
	k++;
	int l = k;
	while (filepath[k]) {
		filename[k - l] = filepath[k];
		k++;
	}
	filename[k - l] = '\0';
	
	char **outdata = (char **) malloc (1000);
	char *filebuffer = (char *) malloc (1);
	FILE *ptrFile = fopen (filepath, "r");
		
	statusbarsettext ("Reading file...");
	
	struct stat *filestat = (struct stat *) malloc (sizeof (struct stat));
	stat (filepath, filestat);
	
	int i = 0, j, len;
	do {
		filebuffer = realloc (filebuffer, i + 2);
		len = fread (filebuffer + i, sizeof (char), 1, ptrFile);
		i++;
		if (!(i % 100000))
			progressbarsetfraction (((double) i)/filestat->st_size);
	} while (len);
	
	progressbarsetfraction (1.0);
	
	filebuffer[i - 1] = '\0';
	fclose (ptrFile);
	
	statusbarsettext ("Encoding...");
	base64_encode (filebuffer, i - 1, outdata);
	free (filebuffer);

	char *outdata2 = (char *) malloc (strlen (*outdata) + 1);
	
	strcpy (outdata2, *outdata);
	free (outdata);
	
	char *outdata3 = (char *) malloc (strlen (outdata2) + 1 + (strlen (outdata2)) / 35);
	len = strlen (outdata2);

	/*70 chars max per line*/	
	j = 0;
	for (i = 0; i <= len; i++) {
		if (!(i % 70)) {
			outdata3[j] = '\r';
			outdata3[j + 1] = '\n';
			j += 2;
		}
		outdata3[j] = outdata2[i];
		j++;
	}
		
	free (outdata2);
	
	coded_data = outdata3;
	
}
void convertion (char *name, char *subject, char *text) {
	int i, j = 0, len = strlen (text);

	for (i = 0; i <= len; i++) {
		if (text[i] == '\n') {
			len++;
			for (j = len; j > i; j--)
				text[j] = text[j-1];
			text[i] = '\r';
			i++;
		}
	}

	if (text[0] == '.') {
			len++;
			for (j = len; j > 0; j--)
				text[j] = text[j-1];
	}
		
	for (i = 0; i <= len; i++) {
		if ((text[i] == '\n') && (text[i+1] == '.')) {
			len++;
			for (j = len; j > (i + 1); j--)
				text[j] = text[j-1];
			i++;
		}
	}
	
	charsetconvert (&text, &text);
	charsetconvert (&name, &name);
	charsetconvert (&subject, &subject);
}

void charsetconvert (char **inptr, char **outptr) {
	iconv_t cd = iconv_open ("ISO8859-1","UTF-8");
	size_t insize;
	size_t outsize;
	
	insize = strlen (*inptr) + 1;
	outsize = strlen (*inptr) + 100;

	iconv (cd, inptr, &insize, outptr, &outsize);

	iconv_close (cd);
}

int initconnection (char *server, int sd) {
	struct sockaddr_in adsock;
	struct hostent *hptr;
	char buffer[1024];	

	printf ("\ngitmail will connect to : %s\n", server);

	hptr = gethostbyname (server);
	
	if((hptr != NULL) && (hptr->h_addr[0] != '\0')) {
		memcpy ((char *) &adsock.sin_addr, (char *) hptr->h_addr, hptr->h_length);
		adsock.sin_family = hptr->h_addrtype;
		adsock.sin_port = htons (25);
		sd = socket (AF_INET, SOCK_STREAM, 0);
		if (sd)	{
			if(!connect (sd, (struct sockaddr *) &adsock, sizeof (adsock)))
				getans (sd, buffer);
			else
				sd = 0;
		}
	} else sd = 0;
	return sd;
}

int transmitinfo (int *sd, char *from, char *to) {
	char buffer[1024];
	
	struct sockaddr_in nameaddr;
	int length = sizeof (nameaddr);
	getsockname(*sd, (struct sockaddr *)&nameaddr, &length);
	
	sprintf (buffer, "HELO [%s]\r\n", inet_ntoa (nameaddr.sin_addr));
	printf ("%s", buffer);
	write (*sd, buffer, strlen(buffer));
	
	getans (*sd, buffer);
		
	sprintf (buffer, "mail from: <%s>\r\n", from);
	printf ("%s", buffer);
	write (*sd, buffer, strlen (buffer));
	
	getans (*sd, buffer);
	if ((buffer[0] == '4') || (buffer[0] == '5'))
		return (atoi (buffer));
	
	sprintf (buffer, "rcpt to: <%s>\r\n", to);
	printf ("%s", buffer);
	write (*sd, buffer, strlen (buffer));
	
	getans (*sd, buffer);	
	if ((buffer[0] == '4') || (buffer[0] == '5'))
		return (atoi (buffer));
	
	return 0;
}

int transmitdata (int *sd, char *from, char *name, char *to, char *subject, char *text, char *filepath) {
	char *buffer;
	int len, i, j;
	
	buffer = (char *) malloc (1024);
	buffer = realloc (buffer, 1024 + strlen (text));
	
	strcpy (buffer, "data\r\n");
	printf ("%s", buffer);
	write (*sd, buffer, strlen (buffer));
	
	getans (*sd, buffer);	
	if ((buffer[0] == '4') || (buffer[0] == '5'))
		return (atoi (buffer));
	
	if (strlen (filepath)) {		/*MIME encoding if attached file*/
		
		/*format file name without path*/
		int k;
		char *filename = (char*) malloc (strlen (filepath));
		k = strlen (filepath);
		while (filepath[k] != '/')
			k--;
		k++;
		int l = k;
		while (filepath[k]) {
			filename[k - l] = filepath[k];
			k++;
		}
		filename[k - l] = '\0';
		
		char *textmime;
		textmime = (char *) malloc (100000);
		strcpy (textmime, "MIME-Version: 1.0\r\n");
		strcat (textmime, "Content-Type: multipart/mixed;\r\n");
		strcat (textmime, " boundary=\"xxXxx\"\r\n\r\n");
		strcat (textmime, "--xxXxx\r\n");
		strcat (textmime, "Content-Type: text/plain\r\n");
		strcat (textmime, "Content-Transfer-Encoding: 8bit\r\n\r\n");
		textmime = realloc (textmime, strlen (textmime) + strlen (text) + 1000);
		strcat (textmime, text);
		strcat (textmime, "\r\n--xxXxx\r\n");
		strcat (textmime, "Content-Type: application/octet-stream;\r\n");
		strcat (textmime, " name=\"");
		strcat (textmime, filename);
		strcat (textmime, "\"\r\n");
		strcat (textmime, "Content-Transfer-Encoding: base64\r\n");
		strcat (textmime, "Content-Disposition: attachment;\r\n");
		strcat (textmime, " filename=\"");
		strcat (textmime, filename);
		strcat (textmime, "\"\r\n\r\n");

		textmime = realloc (textmime, strlen (textmime) + strlen (coded_data) + 12);
		strcat (textmime, coded_data);
		free (coded_data);
		
		strcat (textmime, "\r\n--xxXxx\r\n");
		
		text = realloc (text, strlen (textmime) + 1);
		strcpy (text, textmime);	
		
		free (textmime);
	}
	buffer = realloc (buffer, strlen (text) + 1000);
	
	/*data*/
	sprintf (buffer, "From:%s (%s)\r\nTo:%s\r\nSubject:%s\r\n%s\r\n.\r\n", from, name, to, subject, text);
	
	len = strlen (buffer);
	char *buffer2;
	buffer2 = (char*) malloc (1000);
	j = 0;
	
	statusbarsettext ("Sending mail...");
	for (i = 0; i <= len; i++) {
		if ((!(i % 1000)) && i) {
			buffer2[j] = '\0';
			write (*sd, buffer2, strlen (buffer2));
			j = 0;
			progressbarsetfraction (((double) i)/len);
		}
		buffer2[j] = buffer[i];
		j++;
	}
	
	if (j) write (*sd, buffer2, strlen (buffer2));

	getans (*sd, buffer);
	if ((buffer[0] == '4') || (buffer[0] == '5'))
		return (atoi (buffer));
	
	free (buffer);
	free (text);
	
	return 0;
}

void statusbarsettext (char *text) {
	gdk_threads_enter ();
	gtk_statusbar_pop (GTK_STATUSBAR (statusbar1), context);
	if (text != NULL)
		gtk_statusbar_push (GTK_STATUSBAR (statusbar1), context, text);
	gdk_threads_leave();
	
}

void progressbarsetfraction (double frac) {
	gdk_threads_enter ();
	gtk_progress_bar_set_fraction (GTK_PROGRESS_BAR (progressbar), frac);
	gdk_threads_leave ();
}

void showerror (char *text) {
	window3 = create_window3 ();
	
	GtkWidget *label17 = lookup_widget (window3, "label17");
	
	gdk_threads_enter ();
	
	gtk_label_set_text (GTK_LABEL (label17), text);
	gtk_widget_set_sensitive (button, TRUE);
	
	gtk_widget_show (window3);
	
	gdk_threads_leave ();
}

void getans (int sd, char *buffer) {
	buffer[recv (sd, buffer, 1024, 0)] = '\0';
	printf ("%s", buffer);
}

void lookup_all_widgets () {
	gdk_threads_enter ();
	button = lookup_widget(mainwindow, "button1");
	progressbar = lookup_widget (mainwindow, "progressbar1");
	statusbar1 = lookup_widget (mainwindow, "statusbar1");
	context = gtk_statusbar_get_context_id (GTK_STATUSBAR (statusbar1), "sendamail");
	gdk_threads_leave ();
}
