/* Ghost In The Mail (gitmail)
 *  Copyright (C) 2004-2005 Clément Plantier <clem38fr at users dot sf.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "main.h"

int main (int argc, char *argv[]) {

#ifdef ENABLE_NLS
	bindtextdomain (GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "ISO8859-1");
	textdomain (GETTEXT_PACKAGE);
#endif

	g_thread_init(NULL);
	gdk_threads_init();
	gtk_set_locale ();
	gtk_init (&argc, &argv);
	
	add_pixmap_directory (PACKAGE_DATA_DIR "/" PACKAGE "/pixmaps");
	
	mainwindow = create_window1 ();
	
	readfiles ();
	
	statusbar1 = lookup_widget (mainwindow, "statusbar1");
	gtk_statusbar_push (GTK_STATUSBAR (statusbar1), gtk_statusbar_get_context_id (GTK_STATUSBAR (statusbar1), "main"), "Idle");
	
	gtk_widget_show (mainwindow);
	
	gdk_threads_enter();
	gtk_main ();
	gdk_threads_leave();
	
	writefiles ();

	return 0;
}

void readfiles (void) {
	comboboxentry1 = lookup_widget (mainwindow, "comboboxentry1");
	comboboxentry2 = lookup_widget (mainwindow, "comboboxentry2");
	comboboxentry3 = lookup_widget (mainwindow, "comboboxentry3");
	comboboxentry4 = lookup_widget (mainwindow, "comboboxentry4");
	
	char serverfile[] = "/.gitmail/serverlist";
	char fromfile[] = "/.gitmail/fromlist";
	char namefile[] = "/.gitmail/namelist";
	char tofile[] = "/.gitmail/tolist";
	
	serverlistroot = readfile (serverfile, comboboxentry1);
	fromlistroot = readfile (fromfile, comboboxentry2);
	namelistroot = readfile (namefile, comboboxentry3);
	tolistroot = readfile (tofile, comboboxentry4);
}

GList *readfile (char *file, GtkWidget *comboboxentry) {
	char *homedir = (char*)malloc(1024);
	strcpy (homedir, g_get_home_dir());
	
	strcat (homedir, file);
	
	int fd = open (homedir, O_RDONLY);
	
	char *buffer = (char*) malloc (10000);
	int len;
	len = read (fd, buffer, SSIZE_MAX);
	buffer[len] = '\0';
	if (len > 0)
		return setcbe(buffer, comboboxentry);
	else
		return NULL;
}

GList *setcbe (char *buffer, GtkWidget *comboboxentry) {
	char *buffer2 = (char *) malloc (128);
	int i = -1;
	GList *list = (GList *) malloc (1024);
	list->data = (GList *) malloc (128);
	GList *listroot = list;
	do {
		buffer = &buffer[i+1];
		i = 0;
		
		do {
			if (buffer[i] != '\n') {
				buffer2[i] = buffer[i];
				i++;
			}
		} while (buffer[i] != '\n');
		
		buffer2[i] = '\0';
		strcpy(list->data, buffer2);
		list->next = (GList *) malloc (1024);
		list->next->data = (char *) malloc (128);
		list->next->prev = list;
		list = list->next;
	} while (buffer[i+1] != '\0');
	
	list->prev->next = NULL;

	for (list = listroot; list; list = list->next)
		gtk_combo_box_append_text (GTK_COMBO_BOX(comboboxentry), list->data);
	
	return listroot;
}

void writefiles (void) {
	char *homedir = (char*)malloc(1024);
	strcpy (homedir, g_get_home_dir());
	
	char serverfile[] = "/.gitmail/serverlist";
	char fromfile[] = "/.gitmail/fromlist";
	char namefile[] = "/.gitmail/namelist";
	char tofile[] = "/.gitmail/tolist";
	
	char *fullserverfile = (char *) malloc (strlen (homedir) + strlen (serverfile) + 1);
	char *fullfromfile = (char *) malloc (strlen (homedir) + strlen (fromfile) + 1);
	char *fullnamefile = (char *) malloc (strlen (homedir) + strlen (namefile) + 1);
	char *fulltofile = (char *) malloc (strlen (homedir) + strlen (tofile) + 1);
	
	sprintf (fullserverfile, "%s%s", homedir, serverfile);
	sprintf (fullfromfile, "%s%s", homedir, fromfile);
	sprintf (fullnamefile, "%s%s", homedir, namefile);
	sprintf (fulltofile, "%s%s", homedir, tofile);
	
	remove (fullserverfile);
	remove (fullfromfile);
	remove (fullnamefile);
	remove (fulltofile);
	
	int fd0 = creat (fullserverfile, S_IRUSR | S_IWUSR);
	int fd1 = creat (fullfromfile, S_IRUSR | S_IWUSR);
	int fd2 = creat (fullnamefile, S_IRUSR | S_IWUSR);
	int fd3 = creat (fulltofile, S_IRUSR | S_IWUSR);
	
	writefile (fd0, serverlistroot);
	writefile (fd1, fromlistroot);
	writefile (fd2, namelistroot);
	writefile (fd3, tolistroot);
}

void writefile (int fd, GList *listroot) {
	char *data = (char *)malloc (1024);
	data[0] = '\0';
	
	GList *list;
	for (list = listroot; list; list = list->next) {
		sprintf (data, "%s\n", (char *)list->data);
		write (fd, data, strlen (data));	
	}
}
