/* Ghost In The Mail (gitmail)
 *  Copyright (C) 2004-2005 Clément Plantier <clem38fr at users dot sf.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "cbbentries.h"

GList * additem (GtkWidget *comboboxentry, GList *listroot, char *text) {
	if (strlen (text)) {
		if (listroot) {
			if (check_text (listroot, text)) {
				gtk_combo_box_append_text (GTK_COMBO_BOX(comboboxentry), text);
				char *ptext = (char *)malloc (strlen (text) + 1);
				strcpy (ptext, text);
				listroot = g_list_append (listroot, ptext);
			}
		} else {
			gtk_combo_box_append_text (GTK_COMBO_BOX(comboboxentry), text);
			char *ptext = (char *)malloc (strlen (text) + 1);
			strcpy (ptext, text);
			listroot = g_list_append (listroot, ptext);
		}
	}
	return listroot;
}

gboolean check_text (GList *listroot, char *text) {
	gboolean i = TRUE;
	GList *list;
	for (list = listroot; list; list = list->next)
		if (!strcmp(text, (char *)list->data))
			i = FALSE;
	return i;
}

void erase_all_items (void) {
	serverlistroot = erase_list (comboboxentry1, serverlistroot);
	fromlistroot = erase_list (comboboxentry2, fromlistroot);
	namelistroot = erase_list (comboboxentry3, namelistroot);
	tolistroot = erase_list (comboboxentry4, tolistroot);
}

GList * erase_list (GtkWidget *comboboxentry, GList *listroot) {
	g_list_free (listroot);
	listroot = NULL;
	gtk_list_store_clear (GTK_LIST_STORE (gtk_combo_box_get_model (GTK_COMBO_BOX(comboboxentry))));
	return listroot;
}
