/* Ghost In The Mail (gitmail)
 *  Copyright (C) 2004-2005 Clément Plantier <clem38fr at users dot sf.net>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "callbacks.h"

extern GtkWidget *mainwindow;

void clicksend (GtkButton *button, gpointer user_data) {
	char server[128], from[128], to[128], name[128], subject[128], filepath[1024];
	
	gtk_widget_set_sensitive(GTK_WIDGET(button), FALSE);
	GtkWidget * entry1 = lookup_widget(GTK_WIDGET(button), "entry1");
	GtkWidget * entry2 = lookup_widget(GTK_WIDGET(button), "entry2");
	GtkWidget * comboboxentry1 = lookup_widget(GTK_WIDGET(button), "comboboxentry1");
	GtkWidget * comboboxentry2 = lookup_widget(GTK_WIDGET(button), "comboboxentry2");
	GtkWidget * comboboxentry3 = lookup_widget(GTK_WIDGET(button), "comboboxentry3");
	GtkWidget * comboboxentry4 = lookup_widget(GTK_WIDGET(button), "comboboxentry4");
	GtkWidget * textview1 = lookup_widget(GTK_WIDGET(button), "textview1");
	GtkTextBuffer * buffer;
	
	strcpy(server, gtk_entry_get_text(GTK_ENTRY(GTK_BIN(comboboxentry1)->child)));
	strcpy(from, gtk_entry_get_text(GTK_ENTRY(GTK_BIN(comboboxentry2)->child)));
	strcpy(to, gtk_entry_get_text(GTK_ENTRY(GTK_BIN(comboboxentry4)->child)));
	strcpy(subject, gtk_entry_get_text(GTK_ENTRY(entry1)));
	strcpy(name, gtk_entry_get_text(GTK_ENTRY(GTK_BIN(comboboxentry3)->child)));
	strcpy(filepath, gtk_entry_get_text(GTK_ENTRY(entry2)));
	
	serverlistroot = additem (comboboxentry1, serverlistroot, server);
	fromlistroot = additem (comboboxentry2, fromlistroot, from);
	namelistroot = additem (comboboxentry3, namelistroot, name);
	tolistroot = additem (comboboxentry4, tolistroot, to);
	
	buffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(textview1));
	GtkTextIter start;
	GtkTextIter end;
	gtk_text_buffer_get_start_iter(buffer,&start);
	gtk_text_buffer_get_end_iter(buffer,&end);
	char *text=gtk_text_buffer_get_text (buffer, &start, &end, 0);
	
	maildata *mdata;
	mdata=(maildata *)malloc(sizeof(maildata));
	mdata->server=server;
	mdata->from=from;
	mdata->name=name;
	mdata->to=to;
	mdata->subject=subject;
	mdata->filepath=filepath;
	mdata->text=text;
	sem_t sema;
	mdata->sema=sema;
	pthread_t thread_id;
	sem_init (&mdata->sema, 0, 0);
	pthread_create(&thread_id, NULL, sendamail, mdata);

	sem_wait (&mdata->sema);
}

void clickattach (GtkButton *button, gpointer user_data) {
	GtkWidget *fileselection1=create_fileselection1();
	gtk_widget_show (fileselection1);
}

void file_ok_sel (GtkButton *button, gpointer user_data) {
	GtkWidget *fileselection1=lookup_widget(GTK_WIDGET(button), "fileselection1");
	char file[1024];
	strcpy(file, gtk_file_selection_get_filename (GTK_FILE_SELECTION (fileselection1)));
	gtk_widget_destroy(fileselection1);
	GtkWidget *entry2=lookup_widget(GTK_WIDGET(mainwindow), "entry2");
	gtk_entry_set_text(GTK_ENTRY(entry2), file);
}

void
on_about_activate                      (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	dialog1 = create_dialog1 ();
	gtk_widget_show (dialog1);
}

void
on_erase_all_items1_activate           (GtkMenuItem     *menuitem,
                                        gpointer         user_data)
{
	erase_all_items();
}
