static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2006 Øyvind Kolås <pippin@gimp.org>                            \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (radius, _(\"Radius\"), 10.0)                                 \n"
"   value_range (0.0, 50.0)                                                    \n"
"   description (_(\"Radius of square pixel region (width and height will be radius*2+1)\"))\n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_AREA_FILTER                                                   \n"
"#define GEGL_OP_NAME kuwahara                                                 \n"
"#define GEGL_OP_C_SOURCE kuwahara.c                                           \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"#include <math.h>                                                             \n"
"                                                                              \n"
"static inline void                                                            \n"
"compute_rectangle (gfloat *buf,                                               \n"
"                   gint    buf_width,                                         \n"
"                   gint    buf_height,                                        \n"
"                   gint    x0,                                                \n"
"                   gint    y0,                                                \n"
"                   gint    width,                                             \n"
"                   gint    height,                                            \n"
"                   gint    component,                                         \n"
"                   gfloat *pmin,                                              \n"
"                   gfloat *pmax,                                              \n"
"                   gfloat *pmean,                                             \n"
"                   gfloat *pvariance)                                         \n"
"{                                                                             \n"
"  gint    x, y;                                                               \n"
"  gfloat  max   = -1000000000.0;                                              \n"
"  gfloat  min   =  1000000000.0;                                              \n"
"  gfloat  mean  =  0.0;                                                       \n"
"  glong   count =  0;                                                         \n"
"                                                                              \n"
"  gint offset = (y0 * buf_width + x0) * 4 + component;                        \n"
"                                                                              \n"
"  for (y=y0; y<y0+height; y++)                                                \n"
"    {                                                                         \n"
"    for (x=x0; x<x0+width; x++)                                               \n"
"      {                                                                       \n"
"        if (x>=0 && x<buf_width &&                                            \n"
"            y>=0 && y<buf_height)                                             \n"
"          {                                                                   \n"
"            if (buf [offset] > max)                                           \n"
"              max = buf[offset];                                              \n"
"            if (buf [offset] < min)                                           \n"
"              min = buf[offset];                                              \n"
"            mean += buf[offset];                                              \n"
"            count++;                                                          \n"
"          }                                                                   \n"
"        offset+=4;                                                            \n"
"      }                                                                       \n"
"      offset+= (buf_width * 4) - 4 * width;                                   \n"
"    }                                                                         \n"
"  if (pmin)                                                                   \n"
"    *pmin = min;                                                              \n"
"  if (pmax)                                                                   \n"
"    *pmax = max;                                                              \n"
"  if (pmean && count)                                                         \n"
"    *pmean = mean/count;                                                      \n"
"  if (pvariance)                                                              \n"
"    *pvariance = max-min;                                                     \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"kuwahara (GeglBuffer *src,                                                    \n"
"          GeglBuffer *dst,                                                    \n"
"          gint        radius)                                                 \n"
"{                                                                             \n"
"  gint u,v;                                                                   \n"
"  gint offset;                                                                \n"
"  gfloat *src_buf;                                                            \n"
"  gfloat *dst_buf;                                                            \n"
"                                                                              \n"
"  src_buf = g_new0 (gfloat, gegl_buffer_get_pixel_count (src) * 4);           \n"
"  dst_buf = g_new0 (gfloat, gegl_buffer_get_pixel_count (dst) * 4);           \n"
"                                                                              \n"
"  gegl_buffer_get (src, NULL, 1.0, babl_format (\"RGBA float\"), src_buf,     \n"
"                   GEGL_AUTO_ROWSTRIDE, GEGL_ABYSS_NONE);                     \n"
"                                                                              \n"
"  offset = 0;                                                                 \n"
"  for (v=0; v<gegl_buffer_get_height (dst); v++)                              \n"
"    for (u=0; u<gegl_buffer_get_width (dst); u++)                             \n"
"      {                                                                       \n"
"        gint component;                                                       \n"
"                                                                              \n"
"        for (component=0; component<3; component++)                           \n"
"          {                                                                   \n"
"            gfloat value=0.0;                                                 \n"
"            gfloat best=1000000.0;                                            \n"
"                                                                              \n"
"            gfloat mean = 0.0;                                                \n"
"            gfloat variance = 0.0;                                            \n"
"                                                                              \n"
"            compute_rectangle (src_buf,                                       \n"
"                               gegl_buffer_get_width (src),                   \n"
"                               gegl_buffer_get_height (src),                  \n"
"                               u - radius - 1,                                \n"
"                               v - radius - 1,                                \n"
"                               1 + radius,                                    \n"
"                               1 + radius,                                    \n"
"                               component,                                     \n"
"                               NULL, /* min */                                \n"
"                               NULL, /* max */                                \n"
"                               &mean,                                         \n"
"                               &variance);                                    \n"
"            if (variance<best)                                                \n"
"              {                                                               \n"
"                best = variance;                                              \n"
"                value = mean;                                                 \n"
"              }                                                               \n"
"                                                                              \n"
"            compute_rectangle (src_buf,                                       \n"
"                               gegl_buffer_get_width (src),                   \n"
"                               gegl_buffer_get_height (src),                  \n"
"                               u,                                             \n"
"                               v - radius - 1,                                \n"
"                               1 + radius,                                    \n"
"                               1 + radius,                                    \n"
"                               component,                                     \n"
"                               NULL, /* min */                                \n"
"                               NULL, /* max */                                \n"
"                               &mean,                                         \n"
"                               &variance);                                    \n"
"            if (variance<best)                                                \n"
"              {                                                               \n"
"                best = variance;                                              \n"
"                value = mean;                                                 \n"
"              }                                                               \n"
"                                                                              \n"
"            compute_rectangle (src_buf,                                       \n"
"                               gegl_buffer_get_width (src),                   \n"
"                               gegl_buffer_get_height (src),                  \n"
"                               u - radius - 1,                                \n"
"                               v,                                             \n"
"                               1 + radius,                                    \n"
"                               1 + radius,                                    \n"
"                               component,                                     \n"
"                               NULL, /* min */                                \n"
"                               NULL, /* max */                                \n"
"                               &mean,                                         \n"
"                               &variance);                                    \n"
"            if (variance<best)                                                \n"
"              {                                                               \n"
"                best = variance;                                              \n"
"                value = mean;                                                 \n"
"              }                                                               \n"
"                                                                              \n"
"            compute_rectangle (src_buf,                                       \n"
"                               gegl_buffer_get_width (src),                   \n"
"                               gegl_buffer_get_height (src),                  \n"
"                               u,                                             \n"
"                               v,                                             \n"
"                               1 + radius,                                    \n"
"                               1 + radius,                                    \n"
"                               component,                                     \n"
"                               NULL, /* min */                                \n"
"                               NULL, /* max */                                \n"
"                               &mean,                                         \n"
"                               &variance);                                    \n"
"                                                                              \n"
"            if (variance<best)                                                \n"
"              {                                                               \n"
"                best = variance;                                              \n"
"                value = mean;                                                 \n"
"              }                                                               \n"
"            dst_buf [offset++] = value;                                       \n"
"          }                                                                   \n"
"          dst_buf [offset] = src_buf[offset];                                 \n"
"          offset++;                                                           \n"
"      }                                                                       \n"
"                                                                              \n"
"  gegl_buffer_set (dst, NULL, 0, babl_format (\"RGBA float\"), dst_buf, GEGL_AUTO_ROWSTRIDE);\n"
"  g_free (src_buf);                                                           \n"
"  g_free (dst_buf);                                                           \n"
"}                                                                             \n"
"                                                                              \n"
"static void prepare (GeglOperation *operation)                                \n"
"{                                                                             \n"
"  GeglOperationAreaFilter *area = GEGL_OPERATION_AREA_FILTER (operation);     \n"
"                                                                              \n"
"  area->left = area->right = area->top = area->bottom =                       \n"
"      ceil (GEGL_PROPERTIES (operation)->radius);                             \n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"RGBA float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *input,                                          \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties   *o = GEGL_PROPERTIES (operation);                          \n"
"  GeglBuffer   *temp_in;                                                      \n"
"  GeglRectangle compute = gegl_operation_get_required_for_output (operation, \"input\", result);\n"
"                                                                              \n"
"  temp_in = gegl_buffer_create_sub_buffer (input, &compute);                  \n"
"                                                                              \n"
"  kuwahara (temp_in, output, o->radius);                                      \n"
"  g_object_unref (temp_in);                                                   \n"
"                                                                              \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationFilterClass *filter_class;                                     \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  filter_class    = GEGL_OPERATION_FILTER_CLASS (klass);                      \n"
"                                                                              \n"
"  filter_class->process = process;                                            \n"
"  operation_class->prepare = prepare;                                         \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\"    , \"gegl:kuwahara\",                                          \n"
"    \"categories\"  , \"misc\",                                               \n"
"    \"description\" , _(\"Edge preserving blur\"),                            \n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
