static const char* op_c_source =
"/* Video4Linux2 frame source op for GEGL                                      \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2004-2008, 2014 Øyvind Kolås <pippin@gimp.org>                 \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_file_path (path, _(\"Path\"), \"/dev/video0\")                       \n"
"     description (_(\"video device path\"))                                   \n"
"property_int  (width,  _(\"Width\"),  320)                                    \n"
"     description (_(\"Width for rendered image\"))                            \n"
"property_int  (height, _(\"Height\"), 240)                                    \n"
"     description (_(\"Height for rendered image\"))                           \n"
"property_int  (frame,  _(\"Frame\"),  0)                                      \n"
"     description (_(\"current frame number, can be changed to trigger a reload of the image.\"))\n"
"property_int  (fps, _(\"FPS\"),  0)                                           \n"
"     description (_(\"autotrigger reload this many times a second.\"))        \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_SOURCE                                                        \n"
"#define GEGL_OP_NAME     v4l2                                                 \n"
"#define GEGL_OP_C_SOURCE v4l2.c                                               \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"#include <stdio.h>                                                            \n"
"#include <stdlib.h>                                                           \n"
"#include <string.h>                                                           \n"
"#include <assert.h>                                                           \n"
"                                                                              \n"
"#include <getopt.h>             /* getopt_long() */                           \n"
"                                                                              \n"
"#include <fcntl.h>              /* low-level i/o */                           \n"
"#include <unistd.h>                                                           \n"
"#include <errno.h>                                                            \n"
"#include <sys/stat.h>                                                         \n"
"#include <sys/types.h>                                                        \n"
"#include <sys/time.h>                                                         \n"
"#include <sys/mman.h>                                                         \n"
"#include <sys/ioctl.h>                                                        \n"
"#include <linux/videodev2.h>                                                  \n"
"                                                                              \n"
"struct buffer {                                                               \n"
"  void  *start;                                                               \n"
"  size_t length;                                                              \n"
"};                                                                            \n"
"                                                                              \n"
"typedef struct                                                                \n"
"{                                                                             \n"
"  gint           active;                                                      \n"
"  gint           w;                                                           \n"
"  gint           h;                                                           \n"
"  gint           w_stored;                                                    \n"
"  gint           h_stored;                                                    \n"
"  gint           frame;                                                       \n"
"                                                                              \n"
"  char          *dev_name;                                                    \n"
"  int            use_mmap;                                                    \n"
"  int            fd;                                                          \n"
"  int            io;                                                          \n"
"  struct buffer *buffers;                                                     \n"
"  unsigned int   n_buffers;                                                   \n"
"  int            out_buf;                                                     \n"
"  int            force_format;                                                \n"
"  int            frame_count;                                                 \n"
"} Priv;                                                                       \n"
"                                                                              \n"
"static void                                                                   \n"
"init (GeglProperties *o)                                                      \n"
"{                                                                             \n"
"  Priv *p = (Priv*)o->user_data;                                              \n"
"                                                                              \n"
"  if (p==NULL)                                                                \n"
"    {                                                                         \n"
"      p = g_new0 (Priv, 1);                                                   \n"
"      o->user_data = (void*) p;                                               \n"
"    }                                                                         \n"
"                                                                              \n"
"  p->w = 320;                                                                 \n"
"  p->h = 240;                                                                 \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_bounding_box (GeglOperation *operation)                                   \n"
"{                                                                             \n"
"  GeglRectangle result ={0,0,640,480};                                        \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"                                                                              \n"
"  result.width = o->width;                                                    \n"
"  result.height = o->height;                                                  \n"
"  return result;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"#define CLEAR(x) memset(&(x), 0, sizeof(x))                                   \n"
"                                                                              \n"
"enum io_method {                                                              \n"
"	IO_METHOD_MMAP,                                                              \n"
"	IO_METHOD_READ,                                                              \n"
"	IO_METHOD_USERPTR,                                                           \n"
"};                                                                            \n"
"                                                                              \n"
"static void errno_exit(const char *s)                                         \n"
"{                                                                             \n"
"	fprintf(stderr, \"%s error %d, %s\\n\", s, errno, strerror(errno));          \n"
"	exit(EXIT_FAILURE);                                                          \n"
"}                                                                             \n"
"                                                                              \n"
"static int xioctl(int fh, unsigned long int request, void *arg)               \n"
"{                                                                             \n"
"	int r;                                                                       \n"
"                                                                              \n"
"	do {                                                                         \n"
"		r = ioctl(fh, request, arg);                                                \n"
"	} while (-1 == r && EINTR == errno);                                         \n"
"                                                                              \n"
"	return r;                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"static int read_frame(GeglOperation *operation, GeglBuffer *output)           \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  Priv *p= (Priv*)o->user_data;                                               \n"
"                                                                              \n"
"	struct v4l2_buffer buf;                                                      \n"
"	unsigned int i;                                                              \n"
"                                                                              \n"
"	switch (p->io) {                                                             \n"
"	case IO_METHOD_READ:                                                         \n"
"		if (-1 == read(p->fd, p->buffers[0].start, p->buffers[0].length)) {         \n"
"			switch (errno) {                                                           \n"
"			case EAGAIN:                                                               \n"
"				return 0;                                                                 \n"
"                                                                              \n"
"			case EIO:                                                                  \n"
"				/* Could ignore EIO, see spec. */                                         \n"
"                                                                              \n"
"				/* fall through */                                                        \n"
"                                                                              \n"
"			default:                                                                   \n"
"				errno_exit(\"read\");                                                     \n"
"			}                                                                          \n"
"		}                                                                           \n"
"                                                                              \n"
"		//process_image(priv, p->buffers[0].start, p->buffers[0].length);           \n"
"    gegl_buffer_set (output, NULL, 0, NULL, p->buffers[0].start, GEGL_AUTO_ROWSTRIDE);\n"
"		break;                                                                      \n"
"                                                                              \n"
"	case IO_METHOD_MMAP:                                                         \n"
"		CLEAR(buf);                                                                 \n"
"                                                                              \n"
"		buf.type = V4L2_BUF_TYPE_VIDEO_CAPTURE;                                     \n"
"		buf.memory = V4L2_MEMORY_MMAP;                                              \n"
"                                                                              \n"
"		if (-1 == xioctl(p->fd, VIDIOC_DQBUF, &buf)) {                              \n"
"			switch (errno) {                                                           \n"
"			case EAGAIN:                                                               \n"
"				return 0;                                                                 \n"
"                                                                              \n"
"			case EIO:                                                                  \n"
"				/* Could ignore EIO, see spec. */                                         \n"
"                                                                              \n"
"				/* fall through */                                                        \n"
"                                                                              \n"
"			default:                                                                   \n"
"				errno_exit(\"VIDIOC_DQBUF\");                                             \n"
"			}                                                                          \n"
"		}                                                                           \n"
"                                                                              \n"
"		assert(buf.index < p->n_buffers);                                           \n"
"                                                                              \n"
"		//process_image(priv, p->buffers[buf.index].start, buf.bytesused);          \n"
"    //                                                                        \n"
"    //                                                                        \n"
"    {                                                                         \n"
"      guchar *capbuf = p->buffers[buf.index].start;                           \n"
"      guchar foobuf[o->width*o->height*4];                                    \n"
"          /* XXX: foobuf is unneeded the conversions resets for every         \n"
"           * scanline and could thus have been done in a line by line         \n"
"           * manner an fed into the output buffer                             \n"
"           */                                                                 \n"
"      gint y;                                                                 \n"
"      for (y = 0; y < p->h; y++)                                              \n"
"        {                                                                     \n"
"          gint       x;                                                       \n"
"                                                                              \n"
"          guchar *dst = &foobuf[y*p->w*4];                                    \n"
"          guchar *ysrc = (guchar *) (capbuf + (y) * (p->w) * 2);              \n"
"                                                                              \n"
"          guchar *usrc = ysrc + 3;                                            \n"
"          guchar *vsrc = ysrc + 1;                                            \n"
"                                                                              \n"
"                                                                              \n"
"                                                                              \n"
"          for (x = 0; x < p->w; x++)                                          \n"
"            {                                                                 \n"
"                                                                              \n"
"              gint       R, G, B;                                             \n"
"                                                                              \n"
"#ifndef byteclamp                                                             \n"
"#define byteclamp(j) do{if(j<0)j=0; else if(j>255)j=255;}while(0)             \n"
"#endif                                                                        \n"
"                                                                              \n"
"#define YUV82RGB8(Y,U,V,R,G,B)do{\\                                           \n"
"                  R= ((Y<<15)                 + 37355*(V-128))>>15;\\         \n"
"                  G= ((Y<<15) -12911* (U-128) - 19038*(V-128))>>15;\\         \n"
"                  B= ((Y<<15) +66454* (U-128)                )>>15;\\         \n"
"                  byteclamp(R);\\                                             \n"
"                  byteclamp(G);\\                                             \n"
"                  byteclamp(B);\\                                             \n"
"              }while(0)                                                       \n"
"                                                                              \n"
"      /* the format support for this code is not very good, but it            \n"
"       * works for the devices I have tested with, conversion even            \n"
"       * for chroma subsampled images is something we should let              \n"
"       * babl handle.                                                         \n"
"       */                                                                     \n"
"              YUV82RGB8 (*ysrc, *usrc, *vsrc, R, G, B);                       \n"
"#if 0                                                                         \n"
"              dst[0] = *ysrc;                                                 \n"
"              dst[1] = *ysrc;                                                 \n"
"              dst[2] = *ysrc;                                                 \n"
"#else                                                                         \n"
"              dst[0] = B;                                                     \n"
"              dst[1] = G;                                                     \n"
"              dst[2] = R;                                                     \n"
"              dst[3] = 255;                                                   \n"
"#endif                                                                        \n"
"                                                                              \n"
"              dst  += 4;                                                      \n"
"              ysrc += 2;                                                      \n"
"                                                                              \n"
"              if (x % 2)                                                      \n"
"                {                                                             \n"
"                  usrc += 4;                                                  \n"
"                  vsrc += 4;                                                  \n"
"                }                                                             \n"
"            }                                                                 \n"
"        }                                                                     \n"
"                                                                              \n"
"    gegl_buffer_set (output, NULL, 0, NULL, foobuf,                           \n"
"        GEGL_AUTO_ROWSTRIDE);                                                 \n"
"    }                                                                         \n"
"                                                                              \n"
"		if (-1 == xioctl(p->fd, VIDIOC_QBUF, &buf))                                 \n"
"			errno_exit(\"VIDIOC_QBUF\");                                               \n"
"		break;                                                                      \n"
"                                                                              \n"
"	case IO_METHOD_USERPTR:                                                      \n"
"		CLEAR(buf);                                                                 \n"
"                                                                              \n"
"		buf.type = V4L2_BUF_TYPE_VIDEO_CAPTURE;                                     \n"
"		buf.memory = V4L2_MEMORY_USERPTR;                                           \n"
"                                                                              \n"
"		if (-1 == xioctl(p->fd, VIDIOC_DQBUF, &buf)) {                              \n"
"			switch (errno) {                                                           \n"
"			case EAGAIN:                                                               \n"
"				return 0;                                                                 \n"
"                                                                              \n"
"			case EIO:                                                                  \n"
"				/* Could ignore EIO, see spec. */                                         \n"
"                                                                              \n"
"				/* fall through */                                                        \n"
"                                                                              \n"
"			default:                                                                   \n"
"				errno_exit(\"VIDIOC_DQBUF\");                                             \n"
"			}                                                                          \n"
"		}                                                                           \n"
"                                                                              \n"
"		for (i = 0; i < p->n_buffers; ++i)                                          \n"
"			if (buf.m.userptr == (unsigned long)p->buffers[i].start                    \n"
"			    && buf.length == p->buffers[i].length)                                 \n"
"				break;                                                                    \n"
"                                                                              \n"
"		assert(i < p->n_buffers);                                                   \n"
"                                                                              \n"
"		//process_image(priv, (void *)buf.m.userptr, buf.bytesused);                \n"
"    gegl_buffer_set (output, NULL, 0, NULL, (void*)buf.m.userptr, GEGL_AUTO_ROWSTRIDE);\n"
"                                                                              \n"
"		if (-1 == xioctl(p->fd, VIDIOC_QBUF, &buf))                                 \n"
"			errno_exit(\"VIDIOC_QBUF\");                                               \n"
"		break;                                                                      \n"
"	}                                                                            \n"
"                                                                              \n"
"	return 1;                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"static void stop_capturing(Priv *priv)                                        \n"
"{                                                                             \n"
"	enum v4l2_buf_type type;                                                     \n"
"                                                                              \n"
"	switch (priv->io) {                                                          \n"
"	case IO_METHOD_READ:                                                         \n"
"		/* Nothing to do. */                                                        \n"
"		break;                                                                      \n"
"                                                                              \n"
"	case IO_METHOD_MMAP:                                                         \n"
"	case IO_METHOD_USERPTR:                                                      \n"
"		type = V4L2_BUF_TYPE_VIDEO_CAPTURE;                                         \n"
"		if (-1 == xioctl(priv->fd, VIDIOC_STREAMOFF, &type))                        \n"
"			errno_exit(\"VIDIOC_STREAMOFF\");                                          \n"
"		break;                                                                      \n"
"	}                                                                            \n"
"}                                                                             \n"
"                                                                              \n"
"static void start_capturing(Priv *priv)                                       \n"
"{                                                                             \n"
"	unsigned int i;                                                              \n"
"	enum v4l2_buf_type type;                                                     \n"
"                                                                              \n"
"	switch (priv->io) {                                                          \n"
"	case IO_METHOD_READ:                                                         \n"
"		/* Nothing to do. */                                                        \n"
"		break;                                                                      \n"
"                                                                              \n"
"	case IO_METHOD_MMAP:                                                         \n"
"		for (i = 0; i < priv->n_buffers; ++i) {                                     \n"
"			struct v4l2_buffer buf;                                                    \n"
"                                                                              \n"
"			CLEAR(buf);                                                                \n"
"			buf.type = V4L2_BUF_TYPE_VIDEO_CAPTURE;                                    \n"
"			buf.memory = V4L2_MEMORY_MMAP;                                             \n"
"			buf.index = i;                                                             \n"
"                                                                              \n"
"			if (-1 == xioctl(priv->fd, VIDIOC_QBUF, &buf))                             \n"
"				errno_exit(\"VIDIOC_QBUF\");                                              \n"
"		}                                                                           \n"
"		type = V4L2_BUF_TYPE_VIDEO_CAPTURE;                                         \n"
"		if (-1 == xioctl(priv->fd, VIDIOC_STREAMON, &type))                         \n"
"			errno_exit(\"VIDIOC_STREAMON\");                                           \n"
"		break;                                                                      \n"
"                                                                              \n"
"	case IO_METHOD_USERPTR:                                                      \n"
"		for (i = 0; i < priv->n_buffers; ++i) {                                     \n"
"			struct v4l2_buffer buf;                                                    \n"
"                                                                              \n"
"			CLEAR(buf);                                                                \n"
"			buf.type = V4L2_BUF_TYPE_VIDEO_CAPTURE;                                    \n"
"			buf.memory = V4L2_MEMORY_USERPTR;                                          \n"
"			buf.index = i;                                                             \n"
"			buf.m.userptr = (unsigned long)priv->buffers[i].start;                     \n"
"			buf.length = priv->buffers[i].length;                                      \n"
"                                                                              \n"
"			if (-1 == xioctl(priv->fd, VIDIOC_QBUF, &buf))                             \n"
"				errno_exit(\"VIDIOC_QBUF\");                                              \n"
"		}                                                                           \n"
"		type = V4L2_BUF_TYPE_VIDEO_CAPTURE;                                         \n"
"		if (-1 == xioctl(priv->fd, VIDIOC_STREAMON, &type))                         \n"
"			errno_exit(\"VIDIOC_STREAMON\");                                           \n"
"		break;                                                                      \n"
"	}                                                                            \n"
"}                                                                             \n"
"                                                                              \n"
"static void uninit_device(Priv *priv)                                         \n"
"{                                                                             \n"
"	unsigned int i;                                                              \n"
"                                                                              \n"
"	switch (priv->io) {                                                          \n"
"	case IO_METHOD_READ:                                                         \n"
"		free(priv->buffers[0].start);                                               \n"
"		break;                                                                      \n"
"                                                                              \n"
"	case IO_METHOD_MMAP:                                                         \n"
"		for (i = 0; i < priv->n_buffers; ++i)                                       \n"
"			if (-1 == munmap(priv->buffers[i].start, priv->buffers[i].length))         \n"
"				errno_exit(\"munmap\");                                                   \n"
"		break;                                                                      \n"
"                                                                              \n"
"	case IO_METHOD_USERPTR:                                                      \n"
"		for (i = 0; i < priv->n_buffers; ++i)                                       \n"
"			free(priv->buffers[i].start);                                              \n"
"		break;                                                                      \n"
"	}                                                                            \n"
"                                                                              \n"
"	free(priv->buffers);                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void init_read(Priv *priv, unsigned int buffer_size)                   \n"
"{                                                                             \n"
"	priv->buffers = calloc(1, sizeof(*priv->buffers));                           \n"
"                                                                              \n"
"	if (!priv->buffers) {                                                        \n"
"		fprintf(stderr, \"Out of memory\\n\");                                      \n"
"		exit(EXIT_FAILURE);                                                         \n"
"	}                                                                            \n"
"                                                                              \n"
"	priv->buffers[0].length = buffer_size;                                       \n"
"	priv->buffers[0].start = malloc(buffer_size);                                \n"
"                                                                              \n"
"	if (!priv->buffers[0].start) {                                               \n"
"		fprintf(stderr, \"Out of memory\\n\");                                      \n"
"		exit(EXIT_FAILURE);                                                         \n"
"	}                                                                            \n"
"}                                                                             \n"
"                                                                              \n"
"static void init_mmap(Priv *priv)                                             \n"
"{                                                                             \n"
"	struct v4l2_requestbuffers req;                                              \n"
"                                                                              \n"
"	CLEAR(req);                                                                  \n"
"                                                                              \n"
"	req.count = 4;                                                               \n"
"	req.type = V4L2_BUF_TYPE_VIDEO_CAPTURE;                                      \n"
"	req.memory = V4L2_MEMORY_MMAP;                                               \n"
"                                                                              \n"
"	if (-1 == xioctl(priv->fd, VIDIOC_REQBUFS, &req)) {                          \n"
"		if (EINVAL == errno) {                                                      \n"
"			fprintf(stderr, \"%s does not support \"                                   \n"
"				 \"memory mapping\\n\", priv->dev_name);                                  \n"
"			exit(EXIT_FAILURE);                                                        \n"
"		} else {                                                                    \n"
"			errno_exit(\"VIDIOC_REQBUFS\");                                            \n"
"		}                                                                           \n"
"	}                                                                            \n"
"                                                                              \n"
"	if (req.count < 2) {                                                         \n"
"		fprintf(stderr, \"Insufficient buffer memory on %s\\n\",                    \n"
"			 priv->dev_name);                                                          \n"
"		exit(EXIT_FAILURE);                                                         \n"
"	}                                                                            \n"
"                                                                              \n"
"	priv->buffers = calloc(req.count, sizeof(*priv->buffers));                   \n"
"                                                                              \n"
"	if (!priv->buffers) {                                                        \n"
"		fprintf(stderr, \"Out of memory\\n\");                                      \n"
"		exit(EXIT_FAILURE);                                                         \n"
"	}                                                                            \n"
"                                                                              \n"
"	for (priv->n_buffers = 0; priv->n_buffers < req.count; ++priv->n_buffers) {  \n"
"		struct v4l2_buffer buf;                                                     \n"
"                                                                              \n"
"		CLEAR(buf);                                                                 \n"
"                                                                              \n"
"		buf.type        = V4L2_BUF_TYPE_VIDEO_CAPTURE;                              \n"
"		buf.memory      = V4L2_MEMORY_MMAP;                                         \n"
"		buf.index       = priv->n_buffers;                                          \n"
"                                                                              \n"
"		if (-1 == xioctl(priv->fd, VIDIOC_QUERYBUF, &buf))                          \n"
"			errno_exit(\"VIDIOC_QUERYBUF\");                                           \n"
"                                                                              \n"
"		priv->buffers[priv->n_buffers].length = buf.length;                         \n"
"		priv->buffers[priv->n_buffers].start =                                      \n"
"			mmap(NULL /* start anywhere */,                                            \n"
"			      buf.length,                                                          \n"
"			      PROT_READ | PROT_WRITE /* required */,                               \n"
"			      MAP_SHARED /* recommended */,                                        \n"
"			      priv->fd, buf.m.offset);                                             \n"
"                                                                              \n"
"		if (MAP_FAILED == priv->buffers[priv->n_buffers].start)                     \n"
"			errno_exit(\"mmap\");                                                      \n"
"	}                                                                            \n"
"}                                                                             \n"
"                                                                              \n"
"static void init_userp(Priv *priv, unsigned int buffer_size)                  \n"
"{                                                                             \n"
"	struct v4l2_requestbuffers req;                                              \n"
"                                                                              \n"
"	CLEAR(req);                                                                  \n"
"                                                                              \n"
"	req.count  = 4;                                                              \n"
"	req.type   = V4L2_BUF_TYPE_VIDEO_CAPTURE;                                    \n"
"	req.memory = V4L2_MEMORY_USERPTR;                                            \n"
"                                                                              \n"
"	if (-1 == xioctl(priv->fd, VIDIOC_REQBUFS, &req)) {                          \n"
"		if (EINVAL == errno) {                                                      \n"
"			fprintf(stderr, \"%s does not support \"                                   \n"
"				 \"user pointer i/o\\n\", priv->dev_name);                                \n"
"			exit(EXIT_FAILURE);                                                        \n"
"		} else {                                                                    \n"
"			errno_exit(\"VIDIOC_REQBUFS\");                                            \n"
"		}                                                                           \n"
"	}                                                                            \n"
"                                                                              \n"
"	priv->buffers = calloc(4, sizeof(*priv->buffers));                           \n"
"                                                                              \n"
"	if (!priv->buffers) {                                                        \n"
"		fprintf(stderr, \"Out of memory\\n\");                                      \n"
"		exit(EXIT_FAILURE);                                                         \n"
"	}                                                                            \n"
"                                                                              \n"
"	for (priv->n_buffers = 0; priv->n_buffers < 4; ++priv->n_buffers) {          \n"
"		priv->buffers[priv->n_buffers].length = buffer_size;                        \n"
"		priv->buffers[priv->n_buffers].start = malloc(buffer_size);                 \n"
"                                                                              \n"
"		if (!priv->buffers[priv->n_buffers].start) {                                \n"
"			fprintf(stderr, \"Out of memory\\n\");                                     \n"
"			exit(EXIT_FAILURE);                                                        \n"
"		}                                                                           \n"
"	}                                                                            \n"
"}                                                                             \n"
"                                                                              \n"
"static void init_device(Priv *priv)                                           \n"
"{                                                                             \n"
"	struct v4l2_capability cap;                                                  \n"
"	struct v4l2_cropcap cropcap;                                                 \n"
"	struct v4l2_crop crop;                                                       \n"
"	struct v4l2_format fmt;                                                      \n"
"                                                                              \n"
"	if (-1 == xioctl(priv->fd, VIDIOC_QUERYCAP, &cap)) {                         \n"
"		if (EINVAL == errno) {                                                      \n"
"			fprintf(stderr, \"%s is no V4L2 device\\n\",                               \n"
"				 priv->dev_name);                                                         \n"
"			exit(EXIT_FAILURE);                                                        \n"
"		} else {                                                                    \n"
"			errno_exit(\"VIDIOC_QUERYCAP\");                                           \n"
"		}                                                                           \n"
"	}                                                                            \n"
"                                                                              \n"
"	if (!(cap.capabilities & V4L2_CAP_VIDEO_CAPTURE)) {                          \n"
"		fprintf(stderr, \"%s is no video capture device\\n\",                       \n"
"			 priv->dev_name);                                                          \n"
"		exit(EXIT_FAILURE);                                                         \n"
"	}                                                                            \n"
"                                                                              \n"
"	switch (priv->io) {                                                          \n"
"	case IO_METHOD_READ:                                                         \n"
"		if (!(cap.capabilities & V4L2_CAP_READWRITE)) {                             \n"
"			fprintf(stderr, \"%s does not support read i/o\\n\",                       \n"
"				 priv->dev_name);                                                         \n"
"			exit(EXIT_FAILURE);                                                        \n"
"		}                                                                           \n"
"		break;                                                                      \n"
"                                                                              \n"
"	case IO_METHOD_MMAP:                                                         \n"
"	case IO_METHOD_USERPTR:                                                      \n"
"		if (!(cap.capabilities & V4L2_CAP_STREAMING)) {                             \n"
"			fprintf(stderr, \"%s does not support streaming i/o\\n\",                  \n"
"				 priv->dev_name);                                                         \n"
"			exit(EXIT_FAILURE);                                                        \n"
"		}                                                                           \n"
"		break;                                                                      \n"
"	}                                                                            \n"
"                                                                              \n"
"                                                                              \n"
"	/* Select video input, video standard and tune here. */                      \n"
"                                                                              \n"
"                                                                              \n"
"	CLEAR(cropcap);                                                              \n"
"                                                                              \n"
"	cropcap.type = V4L2_BUF_TYPE_VIDEO_CAPTURE;                                  \n"
"                                                                              \n"
"	if (0 == xioctl(priv->fd, VIDIOC_CROPCAP, &cropcap)) {                       \n"
"		crop.type = V4L2_BUF_TYPE_VIDEO_CAPTURE;                                    \n"
"		crop.c = cropcap.defrect; /* reset to default */                            \n"
"                                                                              \n"
"		if (-1 == xioctl(priv->fd, VIDIOC_S_CROP, &crop)) {                         \n"
"			switch (errno) {                                                           \n"
"			case EINVAL:                                                               \n"
"				/* Cropping not supported. */                                             \n"
"				break;                                                                    \n"
"			default:                                                                   \n"
"				/* Errors ignored. */                                                     \n"
"				break;                                                                    \n"
"			}                                                                          \n"
"		}                                                                           \n"
"	} else {                                                                     \n"
"		/* Errors ignored. */                                                       \n"
"	}                                                                            \n"
"                                                                              \n"
"                                                                              \n"
"	CLEAR(fmt);                                                                  \n"
"                                                                              \n"
"	fmt.type = V4L2_BUF_TYPE_VIDEO_CAPTURE;                                      \n"
"	if (priv->force_format) {                                                    \n"
"		fmt.fmt.pix.width       = priv->w;                                          \n"
"		fmt.fmt.pix.height      = priv->h;                                          \n"
"		//fmt.fmt.pix.pixelformat = V4L2_PIX_FMT_YUYV;                              \n"
"		fmt.fmt.pix.pixelformat = V4L2_PIX_FMT_YUYV;                                \n"
"		fmt.fmt.pix.field       = V4L2_FIELD_INTERLACED;                            \n"
"                                                                              \n"
"		if (-1 == xioctl(priv->fd, VIDIOC_S_FMT, &fmt))                             \n"
"			errno_exit(\"VIDIOC_S_FMT\");                                              \n"
"                                                                              \n"
"		/* Note VIDIOC_S_FMT may change width and height. */                        \n"
"	} else {                                                                     \n"
"		/* Preserve original settings as set by v4l2-ctl for example */             \n"
"		if (-1 == xioctl(priv->fd, VIDIOC_G_FMT, &fmt))                             \n"
"			errno_exit(\"VIDIOC_G_FMT\");                                              \n"
"	}                                                                            \n"
"                                                                              \n"
"	switch (priv->io) {                                                          \n"
"	case IO_METHOD_READ:                                                         \n"
"		init_read(priv, fmt.fmt.pix.sizeimage);                                     \n"
"		break;                                                                      \n"
"                                                                              \n"
"	case IO_METHOD_MMAP:                                                         \n"
"		init_mmap(priv);                                                            \n"
"		break;                                                                      \n"
"                                                                              \n"
"	case IO_METHOD_USERPTR:                                                      \n"
"		init_userp(priv, fmt.fmt.pix.sizeimage);                                    \n"
"		break;                                                                      \n"
"	}                                                                            \n"
"}                                                                             \n"
"                                                                              \n"
"static void close_device(Priv *priv)                                          \n"
"{                                                                             \n"
"	if (-1 == close(priv->fd))                                                   \n"
"		errno_exit(\"close\");                                                      \n"
"                                                                              \n"
"	priv->fd = -1;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static void open_device(Priv *priv)                                           \n"
"{                                                                             \n"
"	struct stat st;                                                              \n"
"                                                                              \n"
"	if (-1 == stat(priv->dev_name, &st)) {                                       \n"
"		fprintf(stderr, \"Cannot identify '%s': %d, %s\\n\",                        \n"
"			 priv->dev_name, errno, strerror(errno));                                  \n"
"		exit(EXIT_FAILURE);                                                         \n"
"	}                                                                            \n"
"                                                                              \n"
"	if (!S_ISCHR(st.st_mode)) {                                                  \n"
"		fprintf(stderr, \"%s is no device\\n\", priv->dev_name);                    \n"
"		exit(EXIT_FAILURE);                                                         \n"
"	}                                                                            \n"
"                                                                              \n"
"	priv->fd = open(priv->dev_name, O_RDWR /* required */ | O_NONBLOCK, 0);      \n"
"                                                                              \n"
"	if (-1 == priv->fd) {                                                        \n"
"		fprintf(stderr, \"Cannot open '%s': %d, %s\\n\",                            \n"
"			 priv->dev_name, errno, strerror(errno));                                  \n"
"		exit(EXIT_FAILURE);                                                         \n"
"	}                                                                            \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  Priv *p= (Priv*)o->user_data;                                               \n"
"                                                                              \n"
"  if (p == NULL)                                                              \n"
"    init (o);                                                                 \n"
"  p = (Priv*)o->user_data;                                                    \n"
"                                                                              \n"
"  gegl_operation_set_format (operation, \"output\",                           \n"
"                            babl_format (\"R'G'B'A u8\"));                    \n"
"                                                                              \n"
"                                                                              \n"
"  if (!p->fd)                                                                 \n"
"    {                                                                         \n"
"      p->force_format = 1;                                                    \n"
"      p->dev_name = o->path;                                                  \n"
"      p->io = IO_METHOD_MMAP;                                                 \n"
"      p->w = o->width;                                                        \n"
"      p->h = o->height;                                                       \n"
"                                                                              \n"
"      open_device (p);                                                        \n"
"      init_device (p);                                                        \n"
"                                                                              \n"
"      start_capturing (p);                                                    \n"
"    }                                                                         \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"finalize (GObject *object)                                                    \n"
"{                                                                             \n"
" GeglProperties *o = GEGL_PROPERTIES (object);                                \n"
"                                                                              \n"
"  if (o->user_data)                                                           \n"
"    {                                                                         \n"
"      Priv *p = (Priv*)o->user_data;                                          \n"
"      if (p->fd)                                                              \n"
"      {                                                                       \n"
"	      stop_capturing(p);                                                     \n"
"        uninit_device (p);                                                    \n"
"        close_device (p);                                                     \n"
"        p->fd = 0;                                                            \n"
"      }                                                                       \n"
"      g_free (o->user_data);                                                  \n"
"      o->user_data = NULL;                                                    \n"
"    }                                                                         \n"
"                                                                              \n"
"  G_OBJECT_CLASS (gegl_op_parent_class)->finalize (object);                   \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean update (gpointer operation)                                   \n"
"{                                                                             \n"
"  GeglRectangle bounds = gegl_operation_get_bounding_box (operation);         \n"
"  gegl_operation_invalidate (operation, &bounds, FALSE);                      \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"static gboolean                                                               \n"
"process (GeglOperation       *operation,                                      \n"
"         GeglBuffer          *output,                                         \n"
"         const GeglRectangle *result,                                         \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (operation);                            \n"
"  Priv       *p = (Priv*)o->user_data;                                        \n"
"                                                                              \n"
"  static gboolean inited = FALSE;                                             \n"
"                                                                              \n"
"    if (!inited && o->fps != 0)                                               \n"
"      {                                                                       \n"
"        inited= TRUE;                                                         \n"
"        g_timeout_add (1000/o->fps, update, operation);                       \n"
"      }                                                                       \n"
"                                                                              \n"
"                                                                              \n"
"  {                                                                           \n"
"    fd_set fds;                                                               \n"
"    struct timeval tv;                                                        \n"
"    FD_ZERO (&fds);                                                           \n"
"    FD_SET (p->fd, &fds);                                                     \n"
"                                                                              \n"
"    tv.tv_sec = 2;                                                            \n"
"    tv.tv_usec = 0;                                                           \n"
"                                                                              \n"
"    switch (select (p->fd + 1, &fds, NULL, NULL, &tv))                        \n"
"    {                                                                         \n"
"      case -1:                                                                \n"
"        if (errno == EINTR)                                                   \n"
"        {                                                                     \n"
"          g_warning (\"select\");                                             \n"
"          return FALSE;                                                       \n"
"        }                                                                     \n"
"        break;                                                                \n"
"      case 0:                                                                 \n"
"        g_warning (\"select timeout\");                                       \n"
"        return FALSE;                                                         \n"
"        break;                                                                \n"
"      default:                                                                \n"
"        read_frame (operation, output);                                       \n"
"    }                                                                         \n"
"  }                                                                           \n"
"                                                                              \n"
"  return  TRUE;                                                               \n"
"}                                                                             \n"
"                                                                              \n"
"static GeglRectangle                                                          \n"
"get_cached_region (GeglOperation       *operation,                            \n"
"                   const GeglRectangle *roi)                                  \n"
"{                                                                             \n"
"  return get_bounding_box (operation);                                        \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass       *operation_class;                                  \n"
"  GeglOperationSourceClass *source_class;                                     \n"
"                                                                              \n"
"  G_OBJECT_CLASS (klass)->finalize = finalize;                                \n"
"                                                                              \n"
"  operation_class = GEGL_OPERATION_CLASS (klass);                             \n"
"  source_class    = GEGL_OPERATION_SOURCE_CLASS (klass);                      \n"
"                                                                              \n"
"  source_class->process             = process;                                \n"
"  operation_class->get_bounding_box = get_bounding_box;                       \n"
"  operation_class->get_cached_region = get_cached_region;                     \n"
"  operation_class->prepare          = prepare;                                \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",         \"gegl:v4l2\",                                          \n"
"    \"title\",        _(\"Video4Linux2 Frame Source\"),                       \n"
"    \"categories\",   \"input:video\",                                        \n"
"    \"description\",  _(\"Video4Linux2 input, webcams framegrabbers and similar devices.\"),\n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
