static const char* op_c_source =
"/* This file is an image processing operation for GEGL                        \n"
" *                                                                            \n"
" * GEGL is free software; you can redistribute it and/or                      \n"
" * modify it under the terms of the GNU Lesser General Public                 \n"
" * License as published by the Free Software Foundation; either               \n"
" * version 3 of the License, or (at your option) any later version.           \n"
" *                                                                            \n"
" * GEGL is distributed in the hope that it will be useful,                    \n"
" * but WITHOUT ANY WARRANTY; without even the implied warranty of             \n"
" * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU          \n"
" * Lesser General Public License for more details.                            \n"
" *                                                                            \n"
" * You should have received a copy of the GNU Lesser General Public           \n"
" * License along with GEGL; if not, see <http://www.gnu.org/licenses/>.       \n"
" *                                                                            \n"
" * Copyright 2012,2013 Felix Ulber <felix.ulber@gmx.de>                       \n"
" *           2013 Øyvind Kolås <pippin@gimp.org>                            \n"
" *           2017 Red Hat, Inc.                                               \n"
" */                                                                           \n"
"                                                                              \n"
"#include \"config.h\"                                                         \n"
"#include <glib/gi18n-lib.h>                                                   \n"
"                                                                              \n"
"#ifdef GEGL_PROPERTIES                                                        \n"
"                                                                              \n"
"property_double (black_level, _(\"Black level\"), 0.0)                        \n"
"    description (_(\"Adjust the black level\"))                               \n"
"    value_range (-0.1, 0.1)                                                   \n"
"                                                                              \n"
"property_double (exposure, _(\"Exposure\"), 0.0)                              \n"
"    description (_(\"Relative brightness change in stops\"))                  \n"
"    ui_range    (-10.0, 10.0)                                                 \n"
"                                                                              \n"
"property_double (gamma, _(\"Gamma adjustment\"), 1.0)                         \n"
"    value_range (0.01, 10)                                                    \n"
"    ui_range    (0.01, 3.0)                                                   \n"
"                                                                              \n"
"#else                                                                         \n"
"                                                                              \n"
"#define GEGL_OP_POINT_FILTER                                                  \n"
"#define GEGL_OP_NAME     exposure                                             \n"
"#define GEGL_OP_C_SOURCE exposure.c                                           \n"
"                                                                              \n"
"#include \"gegl-op.h\"                                                        \n"
"                                                                              \n"
"#include <math.h>                                                             \n"
"#ifdef _MSC_VER                                                               \n"
"#define exp2f (b) ((gfloat) pow (2.0, b))                                     \n"
"#endif                                                                        \n"
"                                                                              \n"
"static void                                                                   \n"
"prepare (GeglOperation *operation)                                            \n"
"{                                                                             \n"
"  gegl_operation_set_format (operation, \"input\", babl_format (\"RGBA float\"));\n"
"  gegl_operation_set_format (operation, \"output\", babl_format (\"RGBA float\"));\n"
"}                                                                             \n"
"                                                                              \n"
"/* GeglOperationPointFilter gives us a linear buffer to operate on            \n"
" * in our requested pixel format                                              \n"
" */                                                                           \n"
"static gboolean                                                               \n"
"process (GeglOperation       *op,                                             \n"
"         void                *in_buf,                                         \n"
"         void                *out_buf,                                        \n"
"         glong                n_pixels,                                       \n"
"         const GeglRectangle *roi,                                            \n"
"         gint                 level)                                          \n"
"{                                                                             \n"
"  GeglProperties *o = GEGL_PROPERTIES (op);                                   \n"
"  gfloat     *in_pixel;                                                       \n"
"  gfloat     *out_pixel;                                                      \n"
"  gfloat      black_level = (gfloat) o->black_level;                          \n"
"  gfloat      diff;                                                           \n"
"  gfloat      exposure_negated = (gfloat) -o->exposure;                       \n"
"  gfloat      gain;                                                           \n"
"  gfloat      white;                                                          \n"
"  gfloat      gamma = 1.0 / o->gamma;                                         \n"
"                                                                              \n"
"  glong       i;                                                              \n"
"                                                                              \n"
"  in_pixel = in_buf;                                                          \n"
"  out_pixel = out_buf;                                                        \n"
"                                                                              \n"
"  white = exp2f (exposure_negated);                                           \n"
"  diff = MAX (white - black_level, 0.01);                                     \n"
"  gain = 1.0f / diff;                                                         \n"
"                                                                              \n"
"  if (gamma == 1.0)                                                           \n"
"    for (i=0; i<n_pixels; i++)                                                \n"
"      {                                                                       \n"
"        out_pixel[0] = (in_pixel[0] - black_level) * gain;                    \n"
"        out_pixel[1] = (in_pixel[1] - black_level) * gain;                    \n"
"        out_pixel[2] = (in_pixel[2] - black_level) * gain;                    \n"
"        out_pixel[3] = in_pixel[3];                                           \n"
"                                                                              \n"
"        out_pixel += 4;                                                       \n"
"        in_pixel  += 4;                                                       \n"
"      }                                                                       \n"
"  else                                                                        \n"
"    for (i=0; i<n_pixels; i++)                                                \n"
"      {                                                                       \n"
"        out_pixel[0] = powf ((in_pixel[0] - black_level) * gain, gamma);      \n"
"        out_pixel[1] = powf ((in_pixel[1] - black_level) * gain, gamma);      \n"
"        out_pixel[2] = powf ((in_pixel[2] - black_level) * gain, gamma);      \n"
"        out_pixel[3] = in_pixel[3];                                           \n"
"                                                                              \n"
"        out_pixel += 4;                                                       \n"
"        in_pixel += 4;                                                        \n"
"      }                                                                       \n"
"                                                                              \n"
"  return TRUE;                                                                \n"
"}                                                                             \n"
"                                                                              \n"
"#include \"opencl/gegl-cl.h\"                                                 \n"
"                                                                              \n"
"static const char* kernel_source =                                            \n"
"\"__kernel void kernel_exposure(__global const float4 *in,          \\n\"     \n"
"\"                              __global       float4 *out,         \\n\"     \n"
"\"                              float                  black_level, \\n\"     \n"
"\"                              float                  gain,        \\n\"     \n"
"\"                              float                  gamma)       \\n\"     \n"
"\"{                                                                 \\n\"     \n"
"\"  int gid = get_global_id(0);                                     \\n\"     \n"
"\"  float4 in_v  = in[gid];                                         \\n\"     \n"
"\"  float4 out_v;                                                   \\n\"     \n"
"\"  out_v.xyz = pow(((in_v.xyz - black_level) * gain), 1.0/gamma);  \\n\"     \n"
"\"  out_v.w   =  in_v.w;                                            \\n\"     \n"
"\"  out[gid]  =  out_v;                                             \\n\"     \n"
"\"}                                                                 \\n\";    \n"
"                                                                              \n"
"static GeglClRunData *cl_data = NULL;                                         \n"
"                                                                              \n"
"/* OpenCL processing function */                                              \n"
"static cl_int                                                                 \n"
"cl_process (GeglOperation       *op,                                          \n"
"            cl_mem               in_tex,                                      \n"
"            cl_mem               out_tex,                                     \n"
"            size_t               global_worksize,                             \n"
"            const GeglRectangle *roi,                                         \n"
"            gint                 level)                                       \n"
"{                                                                             \n"
"  /* Retrieve a pointer to GeglProperties structure which contains all the    \n"
"   * chanted properties                                                       \n"
"   */                                                                         \n"
"                                                                              \n"
"  GeglProperties *o = GEGL_PROPERTIES (op);                                   \n"
"                                                                              \n"
"  gfloat      black_level = (gfloat) o->black_level;                          \n"
"  gfloat      diff;                                                           \n"
"  gfloat      exposure_negated = (gfloat) -o->exposure;                       \n"
"  gfloat      gain;                                                           \n"
"  gfloat      white;                                                          \n"
"  gfloat      gamma = 1.0 / o->gamma;                                         \n"
"                                                                              \n"
"  cl_int cl_err = 0;                                                          \n"
"                                                                              \n"
"  if (!cl_data)                                                               \n"
"    {                                                                         \n"
"      const char *kernel_name[] = {\"kernel_exposure\", NULL};                \n"
"      cl_data = gegl_cl_compile_and_build (kernel_source, kernel_name);       \n"
"    }                                                                         \n"
"  if (!cl_data) return 1;                                                     \n"
"                                                                              \n"
"  white = exp2f (exposure_negated);                                           \n"
"  diff = MAX (white - black_level, 0.01);                                     \n"
"  gain = 1.0f / diff;                                                         \n"
"                                                                              \n"
"  cl_err |= gegl_clSetKernelArg(cl_data->kernel[0], 0, sizeof(cl_mem),   (void*)&in_tex);\n"
"  cl_err |= gegl_clSetKernelArg(cl_data->kernel[0], 1, sizeof(cl_mem),   (void*)&out_tex);\n"
"  cl_err |= gegl_clSetKernelArg(cl_data->kernel[0], 2, sizeof(cl_float), (void*)&black_level);\n"
"  cl_err |= gegl_clSetKernelArg(cl_data->kernel[0], 3, sizeof(cl_float), (void*)&gain);\n"
"  cl_err |= gegl_clSetKernelArg(cl_data->kernel[0], 4, sizeof(cl_float), (void*)&gamma);\n"
"  if (cl_err != CL_SUCCESS) return cl_err;                                    \n"
"                                                                              \n"
"  cl_err = gegl_clEnqueueNDRangeKernel(gegl_cl_get_command_queue (),          \n"
"                                        cl_data->kernel[0], 1,                \n"
"                                        NULL, &global_worksize, NULL,         \n"
"                                        0, NULL, NULL);                       \n"
"  if (cl_err != CL_SUCCESS) return cl_err;                                    \n"
"                                                                              \n"
"  return cl_err;                                                              \n"
"}                                                                             \n"
"                                                                              \n"
"static void                                                                   \n"
"gegl_op_class_init (GeglOpClass *klass)                                       \n"
"{                                                                             \n"
"  GeglOperationClass            *operation_class;                             \n"
"  GeglOperationPointFilterClass *point_filter_class;                          \n"
"                                                                              \n"
"  operation_class    = GEGL_OPERATION_CLASS (klass);                          \n"
"  point_filter_class = GEGL_OPERATION_POINT_FILTER_CLASS (klass);             \n"
"                                                                              \n"
"  operation_class->opencl_support = TRUE;                                     \n"
"  operation_class->prepare        = prepare;                                  \n"
"                                                                              \n"
"  point_filter_class->process    = process;                                   \n"
"  point_filter_class->cl_process = cl_process;                                \n"
"                                                                              \n"
"  gegl_operation_class_set_keys (operation_class,                             \n"
"    \"name\",        \"gegl:exposure\",                                       \n"
"    \"title\",       _(\"Exposure\"),                                         \n"
"    \"categories\",  \"color\",                                               \n"
"    \"description\", _(\"Changes Exposure of an image, allows stepping HDR and photographs up/down in stops. \"),\n"
"    NULL);                                                                    \n"
"}                                                                             \n"
"                                                                              \n"
"#endif                                                                        \n"
;
