/* GAdmin-SSHD - An easy to use GTK+ frontend for the openssh server.
 * Copyright (C) 2009 - 2010 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include "../config.h"
#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "widgets.h"
#include "gettext.h"
#include "allocate.h"
#include "show_info.h"
#include "functions.h"

extern int MAX_READ_POPEN;



void set_version(struct w *widgets)
{
    FILE *fp;
    char *line;
    int i=0, ver_found=0;
    gchar *cmd;
    gchar *ver=NULL;
    gchar *utf8=NULL;
    gchar *info;
    GdkColor color;

    cmd = g_strdup_printf("%s -V 2>&1", SSHD_BINARY);
    if((fp=popen(cmd, "r"))==NULL)
    {
        info = g_strdup_printf(_("Set version failed\n"));
        show_info(info);
        g_free(info);
        g_free(cmd);
        return;
    }
    g_free(cmd);    

    line = allocate(MAX_READ_POPEN);

    while(fgets(line, MAX_READ_POPEN, fp)!=NULL)
    {
        if( strstr(line, "OpenSSH") && strlen(line) < 100 )
        {

            for(i=0; line[i]!='\0'; i++)
            if( line[i]==' ' )
            {
                line[i]='\0';
                break;
            }

            ver = g_strdup_printf(_(" Information: %s"), line);

            utf8 = g_locale_to_utf8(ver, strlen(ver)-1, NULL, NULL, NULL);
            gtk_label_set_text(GTK_LABEL(widgets->version_label), utf8);
            if( utf8!=NULL )
                g_free(utf8);
            if( ver!=NULL )
                g_free(ver);
            ver_found = 1;
        }
    }

    if( ! ver_found )
    {
        ver = g_strdup_printf(_(" SSHD is not installed or not in your path."));
        utf8 = g_locale_to_utf8(ver, strlen(ver), NULL, NULL, NULL);
        gtk_label_set_text(GTK_LABEL(widgets->version_label), utf8);
        if( utf8!=NULL )
            g_free(utf8);
        if( ver!=NULL )
            g_free(ver);

        /* Set status color */
        gdk_color_parse("red", &color);
        gtk_widget_modify_fg(widgets->version_label, GTK_STATE_NORMAL, &color);
    }
    free(line);
    pclose(fp);
}
