/* GAdmin-SSHD - An easy to use GTK+ frontend for the openssh server.
 * Copyright (C) 2009 - 2010 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include "../config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include "gettext.h"
#include "widgets.h"
#include "show_info.h"
#include "allocate.h"
#include "populate_server_settings.h"
#include "functions.h"
#include "get_option_pos.h"

extern char global_server_address[1024];
extern char global_server_port[1024];
extern char global_server_name[1024];
extern char global_server_type[1024];



/* Populates the the server settings */
void populate_server_settings(struct w *widgets)
{
    FILE *fp;
    int i = 0; //, count = 0;
    long opt_pos = 0, file_size = 0;
    char *line, *tmp;
    gchar *info, *utf8 = NULL;
    int found_listen_ipv4 = 0;
    int found_listen_ipv6 = 0;
    int found_port = 0;
    gchar *tmp_txt, *addrs;

    /* Clear all entries. */
    for(i=0; i<2; i++)
        gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[i]), "");

    /* Set standard combo settings */
    gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[0]), 0);
    gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[1]), 0);
    gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[2]), 1);
    gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[3]), 0);


    if((fp=fopen(SSHD_CONF, "r"))==NULL)
    {
        info = g_strdup_printf("%s %s", _("Error: Can not open:\n"), SSHD_CONF);
        show_info(info);
        g_free(info);
        return;
    }
    fseek(fp, 0, SEEK_END);
    file_size = ftell(fp);
    rewind(fp);

    line = allocate(file_size);
    tmp  = allocate(1024);

    if( file_size > 1 )
    while(fgets(line, file_size, fp)!=NULL)
    {
        if( line==NULL || strlen(line) < 4 || commented(line) )
          continue;

        /* Insert all IPv4 and IPv6 listen to addresses:
	       "ListenAddress 0.0.0.0" "ListenAddress ::"  */
        if( cmplowercase(line, "listenaddress ") )
        {
            opt_pos = get_option_pos(line, 1);

            snprintf(tmp, 1000, "%s", &line[opt_pos]);

            if( tmp[strlen(tmp)-1]=='\n' )
                tmp[strlen(tmp)-1]='\0';

            if( cmplowercase(line, ":") ) /* IPv6 */
            {
                found_listen_ipv6 = 1;
                tmp_txt = g_strdup_printf("%s", gtk_entry_get_text(GTK_ENTRY(widgets->server_set_entry[1])));
            }
            else
            {
                found_listen_ipv4 = 1;
                tmp_txt = g_strdup_printf("%s", gtk_entry_get_text(GTK_ENTRY(widgets->server_set_entry[0])));
            }

            if( strlen(tmp_txt) > 1 )
                addrs = g_strdup_printf("%s %s", tmp, tmp_txt);
            else
                addrs = g_strdup_printf("%s", tmp);

            if( tmp_txt!=NULL )
                g_free(tmp_txt);
	    
            utf8 = g_locale_to_utf8(addrs, strlen(addrs), NULL, NULL, NULL);

            if( cmplowercase(line, ":") ) /* IPv6 */
                gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[1]), utf8);
            else
                gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[0]), utf8);
    	    
            if( utf8!=NULL )
                g_free(utf8);
            if( addrs!=NULL )
                g_free(addrs);
        }

        /* Server port */
        if( cmplowercase(line, "port ") )
        {
            found_port = 1;
            opt_pos = get_option_pos(line, 1);

            snprintf(tmp, 1000, "%s", &line[opt_pos]);

            if( tmp[strlen(tmp)-1]=='\n' )
                tmp[strlen(tmp)-1]='\0';

            if( chars_are_digits(tmp) )
            {
                i = atoi(tmp);
                gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[0]), i);
            }
        }

        /* Require password */
        if( cmplowercase(line, "passwordauthentication ") )
        {
            /* Authentication required */
            if( cmplowercase(line, "yes") )
            {
                gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[0]), 0);
            }
            else /* No authentication required */
            if( cmplowercase(line, "no") )
            {
                gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[0]), 1);
            }
        }

        /* X-Forwarding */
        if( cmplowercase(line, "x11forwarding ") )
        {
            if( cmplowercase(line, "yes") )
            {
                gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[1]), 0);
            }
            else
            if( cmplowercase(line, "no") )
            {
                gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[1]), 1);
            }
        }

        /* Challenge Auth */
        if( cmplowercase(line, "challengeresponseauthentication ") )
        {
            if( cmplowercase(line, "yes") )
            {
                gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[2]), 0);
            }
            else
            if( cmplowercase(line, "no") )
            {
                gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[2]), 1);
            }
        }

        /* PermitRootLogin */
        if( cmplowercase(line, "permitrootlogin ") )
        {
            if( cmplowercase(line, "yes") )
            {
                gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[3]), 0);
            }
            else
            if( cmplowercase(line, "no") )
            {
                gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[3]), 1);
            }
        }
    }
    fclose(fp);
    free(line);
    free(tmp);


    /* If there is no IPv4 "listenaddress" it listens to all IPv4 addresses */
    if( ! found_listen_ipv4 )
    {
        addrs = g_strdup_printf("0.0.0.0");
        utf8 = g_locale_to_utf8(addrs, strlen(addrs), NULL, NULL, NULL);
        gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[0]), utf8);
        if( utf8!=NULL )
            g_free(utf8);
        if( addrs!=NULL )
            g_free(addrs);
    }

    /* If there is no IPv6 "listenaddress" it listens to all IPv6 addresses */
    if( ! found_listen_ipv6 )
    {
        addrs = g_strdup_printf("::");
        utf8 = g_locale_to_utf8(addrs, strlen(addrs), NULL, NULL, NULL);
        gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[1]), utf8);
        if( utf8!=NULL )
            g_free(utf8);
        if( addrs!=NULL )
            g_free(addrs);
    }

    /* If no port is specified it listens to port 22 */
    if( ! found_port )
        gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[0]), 22);

}
