/* GAdmin-SSHD - An easy to use GTK+ frontend for the openssh server.
 * Copyright (C) 2009 - 2010 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include "../config.h"
#include <gtk/gtk.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <sys/wait.h>
#include <unistd.h>
#include "gettext.h"
#include "widgets.h"
#include "allocate.h"
#include "show_info.h"
#include "commands.h"
#include "reread_conf.h"
#include "generate_keys.h"



void generate_keys(struct w *widgets)
{
    gchar *cmd;
    gdouble val = 0.0;

    val = 0.0;
    gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(widgets->gen_keys_progressbar), val);
    while(gtk_events_pending())
        gtk_main_iteration();

    val = 0.2;
    gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(widgets->gen_keys_progressbar), val);
    while(gtk_events_pending())
        gtk_main_iteration();

    val = 0.3;
    gtk_progress_bar_set_text(GTK_PROGRESS_BAR(widgets->gen_keys_progressbar), _("Generating RSA1 host key"));
    gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(widgets->gen_keys_progressbar), val);
    while(gtk_events_pending())
        gtk_main_iteration();

    /* ### Protocol 1 ###
       yes | ssh-keygen -t rsa1 -f /etc/ssh/ssh_host_key -N "" */
    cmd = g_strdup_printf("yes | %s -t rsa1 -f %s/ssh_host_key -N \"\"", SSH_KEYGEN_BINARY, SSHD_SYSCONF_DIR);
    if( ! run_command(cmd) )
    {
        printf("Error: Could not create RSA1 key.\n");
        g_free(cmd);
        return;
    }
    g_free(cmd);


    val = 0.4;
    gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(widgets->gen_keys_progressbar), val);
    while(gtk_events_pending())
        gtk_main_iteration();

    val = 0.5;
    gtk_progress_bar_set_text(GTK_PROGRESS_BAR(widgets->gen_keys_progressbar), "Generating DSA key");
    gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(widgets->gen_keys_progressbar), val);
    while(gtk_events_pending())
        gtk_main_iteration();

    /* ### Protocol 2 ###
       yes | ssh-keygen -t dsa -f /etc/ssh/ssh_host_dsa_key -N "" */
    cmd = g_strdup_printf("yes | %s -t dsa -f %s/ssh_host_dsa_key -N \"\"", SSH_KEYGEN_BINARY, SSHD_SYSCONF_DIR);
    if( ! run_command(cmd) )
    {
        printf("Error: Could not create DSA key.\n");
        g_free(cmd);
        return;
    }
    g_free(cmd);


    val = 0.6;
    gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(widgets->gen_keys_progressbar), val);
    while(gtk_events_pending())
        gtk_main_iteration();

    val = 0.7;
    gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(widgets->gen_keys_progressbar), val);
    while(gtk_events_pending())
        gtk_main_iteration();

    val = 0.8;
    gtk_progress_bar_set_text(GTK_PROGRESS_BAR(widgets->gen_keys_progressbar), "Generating RSA key");
    gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(widgets->gen_keys_progressbar), val);
    while(gtk_events_pending())
        gtk_main_iteration();

    /* ### Protocol 2 ###
       yes | ssh-keygen -t rsa -f /etc/ssh/ssh_host_rsa_key -N "" */
    cmd = g_strdup_printf("yes | %s -t rsa -f %s/ssh_host_rsa_key -N \"\"", SSH_KEYGEN_BINARY, SSHD_SYSCONF_DIR);
    if( ! run_command(cmd) )
    {
        printf("Error: Could not create RSA key.\n");
        g_free(cmd);
        return;
    }
    g_free(cmd);


    val = 0.9;
    gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(widgets->gen_keys_progressbar), val);
    while(gtk_events_pending())
        gtk_main_iteration();

    val = 1.0;
    gtk_progress_bar_set_text(GTK_PROGRESS_BAR(widgets->gen_keys_progressbar), "Key creation successful");
    gtk_progress_bar_set_fraction(GTK_PROGRESS_BAR(widgets->gen_keys_progressbar), val);
    while(gtk_events_pending())
        gtk_main_iteration();

    reread_conf(widgets);
}
