/* GAdmin-SSHD - An easy to use GTK+ frontend for the openssh server.
 * Copyright (C) 2009 - 2010 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/




#include "../config.h"
#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "widgets.h"
#include "gettext.h"
#include "allocate.h"
#include "commands.h"
#include "show_info.h"
#include "delete_user.h"
#include "functions.h"
#include "system_defines.h"
#include "create_del_system_user_question.h"
#include "populate_users.h"
#include "populate_user_settings.h"
#include "populate_conf_tab.h"
#include "select_first_user.h"
#include "reread_conf.h"


#ifdef USE_DARWIN
#include "osx_functions.h"
#endif



extern char global_server_address[1024];
extern char global_server_port[1024];
extern char global_server_type[1024];
extern char global_user_name[1024];

extern int activated;



void delete_user(struct w *widgets)
{
    int length=0;
    G_CONST_RETURN gchar *username;
    gchar *info;

    username = gtk_entry_get_text(GTK_ENTRY(widgets->user_set_entry[0]));

    /* If the namefield in username is empty inform that we refuse to do anything */
    length = strlen(username);
    if( length == 0 ) 
    {
        info = g_strdup_printf(_("Could not delete the user, select a user first.\n"));
        show_info(info);
        g_free(info);
        return;
    }

    /* Dont ever delete the root user, it cant be added in the gui but could be added by the user */
    if( username[0]=='r' && username[1]=='o' && username[2]=='o' && username[3]=='t' && strlen(username)==4 ) 
    {
        info = g_strdup_printf(_("User root can not be deleted.\n"));
        show_info(info);
        g_free(info);
        return;
    }


    if( user_exists(username) )
    {
        create_del_system_user_question(widgets);
        gtk_widget_show_all(widgets->del_system_user_question_window);
    }
    else
    {
        /* Update the user list and the user settings */
        populate_users(widgets);

        select_first_user(widgets);

        populate_user_settings(widgets);

        populate_conf_tab(widgets);
    }

    /* Update the server */
    reread_conf(widgets);
}


void dont_delete_system_user(struct w *widgets)
{
    gtk_widget_destroy(widgets->del_system_user_question_window);

    /* Update the user list and the user settings */
    populate_users(widgets);

    select_first_user(widgets);

    populate_user_settings(widgets);
    
    populate_conf_tab(widgets);

    /* Update the server */
    reread_conf(widgets);
}


void do_delete_system_user(GtkButton *button, struct w *widgets)
{
    /* Deletes the system user */

#ifndef USE_DARWIN
    /* Avoid unused warning */
    char *command;
#endif

    int deleted = 0;
    int length  = 0;
    gchar *utf8 = NULL;
    gchar *info;
    char *username;

    gtk_widget_destroy(widgets->del_system_user_question_window);


    username = allocate(1024);
    snprintf(username, 1000, "%s", global_user_name);

    if( username == NULL )
    {
        info = g_strdup_printf(_("No username specified.\n"));
        show_info(info);
        g_free(info);
        return;
    }


    /* If the username field is empty inform that this cant be done. */
    length = strlen(username);
    if( length == 0 ) 
    {
        info = g_strdup_printf(_("No username specified.\n"));
        show_info(info);
        g_free(info);
        return;
    }

    if( username[0]=='r' && username[1]=='o' && username[2]=='o' && username[3]=='t' && strlen(username) == 4 ) 
    {
        info = g_strdup_printf(_("The root user can not be deleted.\n"));
        show_info(info);
        g_free(info);
        return;
    }


#ifndef USE_DARWIN
    if( user_exists(username) )
    {
        command = allocate(4096);
        snprintf(command, 4000, "%s %s", DELUSER, username);
        if( run_command(command) )
            deleted = 1;

        free(command);
    }
#elif USE_DARWIN
    if( niutil_user_exists(username) )
    {
        if( niutil_userdel(username) )
            deleted = 1;
    }
#endif


    if( ! deleted )
    {
        info = g_strdup_printf(_("Failed deleting user: %s\n"), username);
        show_info(info);
        g_free(info);
    }

    if( utf8!=NULL )
        g_free(utf8);

    /* Update the user list and the user settings */
    populate_users(widgets);

    select_first_user(widgets);

    populate_user_settings(widgets);
    
    populate_conf_tab(widgets);

    /* Update the server */
    reread_conf(widgets);
}
