/* GAdmin-SSHD - An easy to use GTK+ frontend for the openssh server.
 * Copyright (C) 2009 - 2010 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/


#include "../config.h"
#include <gtk/gtk.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <unistd.h>
#include "gettext.h"
#include "widgets.h"
#include "clear_log_tab.h"
#include "show_info.h"
#include "allocate.h"
#include "populate_log_tab.h"



/* Clears the security log entries for sshd */
void clear_log_tab(struct w *widgets)
{
    FILE *fp;
    char *line, *new_log;
    long file_size = 0;
    gchar *info;

    /* Collect every line in syslog thats not referring to sshd */    
    if((fp=fopen(SECURE_LOG, "r"))==NULL)
    {
        info = g_strdup_printf(_("Could not open secure log here: %s\n"), SECURE_LOG);
        show_info(info);
        g_free(info);
        return;
    }

    fseek(fp, 0, SEEK_END);
    file_size = ftell(fp);
    rewind(fp);

    line = allocate(file_size+16384);
    new_log = allocate(file_size+16384);

    if( file_size > 1 )
    while(fgets(line, file_size, fp)!=NULL)
        if( ! strstr(line, "sshd") )
            strcat(new_log, line);

    fclose(fp);    

    /* Write the modified security log */
    if((fp=fopen(SECURE_LOG, "w+"))==NULL)
    {
        info = g_strdup_printf(_("Could not write secure log here: %s\n"), SECURE_LOG);
        show_info(info);
        g_free(info);
        free(line);
        free(new_log);
        return;
    }
    fputs(new_log, fp);
    free(line);
    free(new_log);
    fclose(fp);

    populate_log_tab(widgets);
}

