/* GAdmin-Sendmail - An easy to use GTK+ frontend for the sendmail mailserver.
 * Copyright (C) 2008 - 2009 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/




#include "../config.h"
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include "allocate.h"
#include <gtk/gtk.h>
#include "gettext.h"
#include "widgets.h"
#include "functions.h"
#include "commented.h"
#include "get_option_pos.h"
#include "standard_conf.h"
#include "system_defines.h"
#include "populate_gadmin_sendmail.h"
#include "show_info.h"



int conf_ok(gchar *file_path)
{
    FILE *fp;
    long file_size;
    char *line;
    int retval   = 0;
    int new_conf = 0;

    if((fp=fopen(file_path, "r"))==NULL)
      return retval;

    fseek(fp, 0, SEEK_END);
    file_size = ftell(fp);
    rewind(fp);

    /* Conf too small to be ok */
    if( file_size < 30 )
    {
	fclose(fp);
	return retval;
    }

    line = allocate(file_size+1);

    if( file_size > 1 )
    while(fgets(line, file_size, fp)!=NULL)
    {
	if( commented(line) )
	  continue;

	// if( something is bad... )
	//  new_conf = 1;
    }
    fclose(fp);
    free(line);
    
    if( ! new_conf )
      retval = 1;

    return retval;
}


// Not used, no need
void add_standard_conf(struct w *widgets)
{
    /* Adds a default sendmail.mc */
    FILE *fp;
    gchar *info, *conf;

    if((fp=fopen(SENDMAIL_MC_CONF, "w+"))==NULL)
    {
	info = g_strdup_printf(_("Cant write a new sendmail.mc conf here:\n%s\n"), SENDMAIL_MC_CONF);
	show_info(info);
	g_free(info);
	return;
    }


    conf = g_strconcat("",
    "dnl ### GADMIN-SENDMAIL Configuration ###\n",
    "divert(-1)dnl\n",

    // Requires path
    "include(`/usr/share/sendmail-cf/m4/cf.m4')dnl\n",

    "VERSIONID(`setup for linux')dnl\n",
    "OSTYPE(`linux')dnl\n",

    "define(`confDEF_USER_ID', ``8:12'')dnl\n",
    "define(`confTO_CONNECT', `1m')dnl\n",
    "define(`confTRY_NULL_MX_LIST', `True')dnl\n",
    "define(`confDONT_PROBE_INTERFACES', `True')dnl\n",

    // Paths
    "define(`PROCMAIL_MAILER_PATH', `/usr/bin/procmail')dnl\n",
    "define(`ALIAS_FILE', `", SENDMAIL_ALIASES_CONF, "')dnl\n",
    "define(`STATUS_FILE', `/var/log/mail/statistics')dnl\n",

    "define(`UUCP_MAILER_MAX', `2000000')dnl\n",

    // Path
    "define(`confUSERDB_SPEC', `/etc/mail/userdb.db')dnl\n",

    "define(`confPRIVACY_FLAGS', `authwarnings,novrfy,noexpn,restrictqrun')dnl\n",
    "define(`confAUTH_OPTIONS', `A')dnl\n",
    "define(`confTO_IDENT', `0')dnl\n",

    "FEATURE(`no_default_msa', `dnl')dnl\n",
    
    // Path
    "FEATURE(`smrsh', `/usr/sbin/smrsh')dnl\n",
    "FEATURE(`mailertable', `hash -o ", SENDMAIL_MAILER_TABLE_CONF, ".db')dnl\n",
    "FEATURE(`virtusertable', `hash -o ", SENDMAIL_VIRT_USER_TABLE_CONF, ".db')dnl\n",

    "FEATURE(redirect)dnl\n",
    "FEATURE(always_add_domain)dnl\n",
    "FEATURE(use_cw_file)dnl\n",
    "FEATURE(use_ct_file)dnl\n",

    // Maybe use MAILER_PROGRAM...
    "FEATURE(local_procmail, `', `procmail -t -Y -a $h -d $u')dnl\n",
    
    "FEATURE(`access_db', `hash -T<TMPF> -o ", SENDMAIL_ACCESS_CONF, ".db')dnl\n",
    "FEATURE(`blacklist_recipients')dnl\n",
    "EXPOSED_USER(`root')dnl\n",

    /* Only listen to 127.0.0.1 */
    "DAEMON_OPTIONS(`Port=smtp,Addr=127.0.0.1, Name=MTA')dnl\n",

    /* Listen to both IPv4 and IPv6 */
    "dnl DAEMON_OPTIONS(`Name=MTA-v4, Family=inet, Name=MTA-v6, Family=inet6')\n",

    "LOCAL_DOMAIN(`localhost.localdomain')dnl\n",

    // Hmm...
    "MASQUERADE_AS(`example.org')dnl\n",

    "FEATURE(masquerade_envelope)dnl\n",
    "FEATURE(masquerade_entire_domain)dnl\n",

    "MAILER(local)dnl\n"
    "MAILER(smtp)dnl\n",
    "MAILER(procmail)dnl\n",

    // Requires clamav-milter socket path
    "INPUT_MAIL_FILTER(`clamav', `S=local:/var/run/clamav-milter/clamav.sock, F=T, T=S:4m;R:4m')\n",

    NULL);

    fputs(conf, fp);
    fclose(fp);

    g_free(conf);

    if( GTK_IS_WINDOW(widgets->default_conf_question_window) )
      gtk_widget_destroy(widgets->default_conf_question_window);

    populate_gadmin_sendmail(widgets);
}


/* This should probably also write a ~"dont_ask_again=1" to the settings file */
void dont_add_standard_conf(struct w *widgets)
{
    gtk_widget_destroy(widgets->default_conf_question_window);
    populate_gadmin_sendmail(widgets);
}


void create_standard_conf_question(struct w *widgets)
{
  GtkWidget *vbox18, *label182;
  GtkWidget *scrolledwindow18;
  GtkWidget *default_question_textview;
  GtkWidget *hbuttonbox11;
  GtkWidget *yes_default_question_button;
  GtkWidget *alignment44, *hbox98;
  GtkWidget *image44, *label184;
  GtkWidget *no_default_question_button;
  GtkWidget *alignment45, *hbox99;
  GtkWidget *image45, *label185;

  widgets->default_conf_question_window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_size_request(widgets->default_conf_question_window, 500, 340);
  gtk_window_set_title(GTK_WINDOW(widgets->default_conf_question_window), _("GADMIN-SENDMAIL question"));
  gtk_window_set_position(GTK_WINDOW(widgets->default_conf_question_window), GTK_WIN_POS_CENTER);

  vbox18 = gtk_vbox_new(FALSE, 0);
  gtk_container_add(GTK_CONTAINER(widgets->default_conf_question_window), vbox18);

  label182 = gtk_label_new ("");
  gtk_box_pack_start(GTK_BOX(vbox18), label182, FALSE, FALSE, 0);
  gtk_widget_set_size_request(label182, -1, 20);
  gtk_label_set_justify(GTK_LABEL(label182), GTK_JUSTIFY_LEFT);

  scrolledwindow18 = gtk_scrolled_window_new(NULL, NULL);
  gtk_box_pack_start(GTK_BOX(vbox18), scrolledwindow18, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledwindow18), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);

  default_question_textview = gtk_text_view_new();
  gtk_container_add(GTK_CONTAINER(scrolledwindow18), default_question_textview);
  gtk_widget_set_size_request(default_question_textview, 156, 260);
  gtk_text_view_set_editable(GTK_TEXT_VIEW(default_question_textview), FALSE);
  gtk_text_view_set_cursor_visible(GTK_TEXT_VIEW(default_question_textview), FALSE);
  gtk_text_view_set_pixels_above_lines(GTK_TEXT_VIEW(default_question_textview), 3);
  gtk_text_view_set_left_margin(GTK_TEXT_VIEW(default_question_textview), 30);

  gtk_text_buffer_set_text(gtk_text_view_get_buffer(GTK_TEXT_VIEW(default_question_textview)),
  _("GAdmin-Sendmail has detected that your current configuration\nfile is lacking required options or is missing.\n\nDo you want to write a new configuration ?\n\n\t\t\t(If you dont know then press yes)\n"), -1);

  hbuttonbox11 = gtk_hbutton_box_new();
  gtk_box_pack_start(GTK_BOX(vbox18), hbuttonbox11, FALSE, FALSE, 0);
  gtk_widget_set_size_request(hbuttonbox11, -1, 40);
  gtk_button_box_set_layout(GTK_BUTTON_BOX(hbuttonbox11), GTK_BUTTONBOX_SPREAD);

  yes_default_question_button = gtk_button_new();
  gtk_container_add(GTK_CONTAINER(hbuttonbox11), yes_default_question_button);
  GTK_WIDGET_SET_FLAGS(yes_default_question_button, GTK_CAN_DEFAULT);

  alignment44 = gtk_alignment_new(0.5, 0.5, 0, 0);
  gtk_container_add(GTK_CONTAINER(yes_default_question_button), alignment44);

  hbox98 = gtk_hbox_new(FALSE, 2);
  gtk_container_add(GTK_CONTAINER(alignment44), hbox98);

  image44 = gtk_image_new_from_stock("gtk-yes", GTK_ICON_SIZE_BUTTON);
  gtk_box_pack_start(GTK_BOX(hbox98), image44, FALSE, FALSE, 0);

  label184 = gtk_label_new_with_mnemonic(_("Yes"));
  gtk_box_pack_start(GTK_BOX(hbox98), label184, FALSE, FALSE, 0);
  gtk_label_set_justify(GTK_LABEL(label184), GTK_JUSTIFY_LEFT);

  no_default_question_button = gtk_button_new();
  gtk_container_add(GTK_CONTAINER(hbuttonbox11), no_default_question_button);
  GTK_WIDGET_SET_FLAGS(no_default_question_button, GTK_CAN_DEFAULT);

  alignment45 = gtk_alignment_new(0.5, 0.5, 0, 0);
  gtk_container_add(GTK_CONTAINER(no_default_question_button), alignment45);

  hbox99 = gtk_hbox_new(FALSE, 2);
  gtk_container_add(GTK_CONTAINER(alignment45), hbox99);

  image45 = gtk_image_new_from_stock("gtk-no", GTK_ICON_SIZE_BUTTON);
  gtk_box_pack_start(GTK_BOX(hbox99), image45, FALSE, FALSE, 0);

  label185 = gtk_label_new_with_mnemonic(_("No"));
  gtk_box_pack_start(GTK_BOX(hbox99), label185, FALSE, FALSE, 0);
  gtk_label_set_justify(GTK_LABEL(label185), GTK_JUSTIFY_LEFT);

  g_signal_connect_swapped(G_OBJECT(yes_default_question_button), "clicked",
                              G_CALLBACK(add_standard_conf), widgets);

  g_signal_connect_swapped(G_OBJECT(no_default_question_button), "clicked",
                           G_CALLBACK(dont_add_standard_conf), widgets);

  gtk_widget_show_all(widgets->default_conf_question_window);
}
