/* GAdmin-Sendmail - An easy to use GTK+ frontend for the sendmail mailserver.
 * Copyright (C) 2008 - 2009 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/


#include "../config.h"
#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include "widgets.h"
#include "gettext.h"
#include "commands.h"

extern int activated;



void reread_conf(struct w *widgets)
{
    /* Update configurations and reread with a HUP. Show any errors */
    gchar *cmd, *test;

    if( ! activated )
      return;

// Run: make -C /etc/mail
// Run: newaliases > /dev/null 2>&1

// Fedora uses: make all -C /etc/mail -s > /dev/null

    cmd = g_strdup_printf("%s -C %s", MAKE_BINARY, SENDMAIL_SYSCONF_PATH);
    if( ! run_command(cmd) )
    {
        printf("Reconfiguring sendmail failed\n");
        test = g_strdup_printf("%s -C %s 2>&1", MAKE_BINARY, SENDMAIL_SYSCONF_PATH);
	run_command_show_err(test);
	g_free(test);
    }
    g_free(cmd);


    cmd = g_strdup_printf("%s > /dev/null 2>&1", NEWALIASES_BINARY);
    if( ! run_command(cmd) )
    {
        printf("Reconfiguring newaliases failed\n");
        test = g_strdup_printf("%s > /dev/null 2>&1", NEWALIASES_BINARY);
	run_command_show_err(test);
	g_free(test);
    }
    g_free(cmd);


    cmd = g_strdup_printf("killall -HUP %s", SENDMAIL_BINARY);
    if( ! run_command(cmd) )
    {
        printf("Restarting sendmail failed\n");
        test = g_strdup_printf("killall -HUP %s 2>&1", SENDMAIL_BINARY);
	run_command_show_err(test);
	g_free(test);
    }
    g_free(cmd);
}
