/* GAdmin-Sendmail - An easy to use GTK+ frontend for the sendmail mailserver.
 * Copyright (C) 2008 - 2009 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include "../config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include "gettext.h"
#include "widgets.h"
#include "show_info.h"
#include "allocate.h"
#include "chars_are_digits.h"
#include "populate_server_settings.h"
#include "commented.h"
#include "functions.h"

#include "get_option_pos.h"

extern char global_server_address[1024];
extern char global_server_port[1024];
extern char global_server_name[1024];
extern char global_server_type[1024];

extern int use_tls;


void populate_server_settings(struct w *widgets)
{
    /* Lists the values for the selected server in the server tab */
    FILE *fp;
    int i = 0, count = 0;
    long file_size = 0;
    char *line, *tmp;
    gchar *info, *utf8   = NULL;
    int found_listen_to  = 0;
//    int open_relay       = 0;
    int have_encryption = 0, have_no_encryption = 0;
    const gchar *tmp_txt;
    gchar *addrs;

    /* Clear all entries. */
    for(i=0; i<4; i++)
      gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[i]), "");

    /* Insert sendmail.mc values */
    if((fp=fopen(SENDMAIL_MC_CONF, "r"))==NULL)
    {
	info = g_strdup_printf("%s %s", _("Error: Cant open:\n"), SENDMAIL_MC_CONF);
        show_info(info);
        g_free(info);
        return;
    }
    fseek(fp, 0, SEEK_END);
    file_size = ftell(fp);
    rewind(fp);

    line = allocate(file_size);
    tmp  = allocate(1024);

    if( file_size > 1 )
    while(fgets(line, file_size, fp)!=NULL)
    {
        if( line==NULL || strlen(line) < 4 || commented(line) )
          continue;

	/* Insert all IPv4 and IPv6 listen to addresses:
    	   "DAEMON_OPTIONS(`Port=smtp,Addr=127.0.0.1, Name=MTA')dnl" 
           And "DAEMON_OPTIONS(`port=smtp,Addr=::1, Name=MTA-v6, Family=inet6')dnl" */
	if( cmplowercase(line, "daemon_options")
	&&  cmplowercase(line, "port=smtp")
	&&  cmplowercase(line, "addr=")
	&&  cmplowercase(line, "name=mta") )
	{
	    found_listen_to = 1;
	    
	    for(i=0; line[i]!='\0'; i++)
	    if( (line[i]=='a' || line[i]=='A')
	    &&  (line[i+1]=='d' && line[i+2]=='d'
	    &&   line[i+3]=='r' && line[i+4]=='=') )
	    {
		snprintf(tmp, 1000, "%s", &line[i+5]);
		break;
	    }

	    /* Skip spaces */
	    for(i=0; tmp[i]!='\0'; i++)
	      if( tmp[i]!=' ' )
	        break;
	    
	    for(i=i; tmp[i]!='\0'; i++)
	    if( tmp[i]==' ' || tmp[i]==',' || tmp[i]=='\'' )
	      tmp[i]='\0';
	      
	    if( cmplowercase(line, "name=mta-v6") )
    	      tmp_txt = gtk_entry_get_text(GTK_ENTRY(widgets->server_set_entry[1]));
    	    else
    	      tmp_txt = gtk_entry_get_text(GTK_ENTRY(widgets->server_set_entry[0]));
	    
    	    if( strlen(tmp_txt) > 2 )
	      addrs = g_strdup_printf("%s %s", tmp_txt, tmp);
	    else
	      addrs = g_strdup_printf("%s", tmp);
	    
	    utf8 = g_locale_to_utf8(addrs, strlen(addrs), NULL, NULL, NULL);

	    if( cmplowercase(line, "name=mta-v6") )
    	      gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[1]), utf8);
	    else
    	      gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[0]), utf8);
    	    
    	    if( utf8!=NULL )
    	      g_free(utf8);
    	    if( addrs!=NULL )
    	      g_free(addrs);
	}

	/* Smart host */
	if( cmplowercase(line, "smart_host") )
	{
	    /* Skip spaces */
	    for(i=0; line[i]!='\0'; i++)
	      if( line[i]!=' ' )
	        break;
	    
	    count = 0;
	    for(i=i; line[i]!='\0'; i++)
	    if( line[i]=='`' )
	    {
		count++;
		if( count == 2 )
		{
		    snprintf(tmp, 1000, "%s", &line[i+1]);
		    break;
		}
	    }

	    for(i=0; tmp[i]!='\0'; i++)
	      if( tmp[i]=='\'' )
		break;
		
	    tmp[i]='\0';
	    utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
    	    gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[3]), utf8);
    	    if( utf8!=NULL )
    	      g_free(utf8);
	}

	/* Max connections */
	if( cmplowercase(line, "confmax_daemon_children") )
	{
	    /* Skip spaces */
	    for(i=0; line[i]!='\0'; i++)
	      if( line[i]!=' ' )
	        break;
	    
	    count = 0;
	    for(i=i; line[i]!='\0'; i++)
	    if( line[i]=='`' )
	    {
		count++;
		if( count == 2 )
		{
		    snprintf(tmp, 1000, "%s", &line[i+1]);
		    break;
		}
	    }

	    for(i=0; tmp[i]!='\0'; i++)
	      if( tmp[i]=='\'' )
		break;
		
	    tmp[i]='\0';
	    if( chars_are_digits(tmp) )
	    {
		i = atoi(tmp);
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[0]), i);
	    }
	}

	/* Max connection rate */
	if( cmplowercase(line, "confconnection_rate_throttle") )
	{
	    /* Skip spaces */
	    for(i=0; line[i]!='\0'; i++)
	      if( line[i]!=' ' )
	        break;
	    
	    count = 0;
	    for(i=i; line[i]!='\0'; i++)
	    if( line[i]=='`' )
	    {
		count++;
		if( count == 2 )
		{
		    snprintf(tmp, 1000, "%s", &line[i+1]);
		    break;
		}
	    }

	    for(i=0; tmp[i]!='\0'; i++)
	      if( tmp[i]=='\'' )
		break;
		
	    tmp[i]='\0';

	    tmp[i]='\0';
	    if( chars_are_digits(tmp) )
	    {
		i = atoi(tmp);
		gtk_spin_button_set_value(GTK_SPIN_BUTTON(widgets->server_set_spinbutton[1]), i);
	    }
	}


	/*  Set Authentication type in the combo.

	    define(`confAUTH_OPTIONS', `A')dnl
	    Can contain characters: a, c, d, f, p, and y.
	    Can be space or comma delimited .              */

// Fix: Can be used in any order pacyfd etc.
	if( cmplowercase(line, "confauth_options") )
	{
	    /* No authentication required */
	    if( cmplowercase(line, "`a'") )
	    {
		gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[0]), 0);
	    }
	    else /* Authentication required */
	    if( cmplowercase(line, "`ap'") || cmplowercase(line, "`a p'") )
	    {
		gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[0]), 1);
	    }
	    else
	    {
		printf("Populate_server_settings.c: I have no choise for confauth_options:\n");
		printf("%s\n", line);
	    
	    }
	}
	
	/* Get the Encryption type used. */
	if( cmplowercase(line, "daemon_options")
	&&  cmplowercase(line, "port=smtps")
//	&&  cmplowercase(line, "addr=")
	&&  cmplowercase(line, "name=tlsmta") )
	{
	    have_encryption = 1;
	}
	else
	if( cmplowercase(line, "daemon_options")
	&&  cmplowercase(line, "port=smtp")
	&&  cmplowercase(line, "addr=")
	&&  cmplowercase(line, "name=mta") )
	{
	    have_no_encryption = 1;
	}



    }
    fclose(fp);
    free(line);
    free(tmp);


    /* Set the Encryption type in the combo. Dont use else if's here. */
    if( ! have_encryption )
    {
	/* No encryption is used */
	gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[1]), 0);
    }
    if( have_encryption )
    {
	/* Encryption is used */
	gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[1]), 1);
    }
    if( have_encryption && have_no_encryption )
    {
	/* Both Encryption and no encryption is used */
	gtk_combo_box_set_active(GTK_COMBO_BOX(widgets->server_set_combo[1]), 2);
    }


    /* If there are no "listen to" adresses it listens to all IPv4 interfaces */
    if( ! found_listen_to )
    {
	addrs = g_strdup_printf("0.0.0.0"); /* Default for sendmail, verify that. */
	    
	utf8 = g_locale_to_utf8(addrs, strlen(addrs), NULL, NULL, NULL);
    	gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[0]), utf8);
    	if( utf8!=NULL )
    	  g_free(utf8);
    	if( addrs!=NULL )
    	  g_free(addrs);
    }


    /* File: local-host-names. A listing of hostnames for this mail server */
    if((fp=fopen(SENDMAIL_LOCAL_HOST_NAMES_CONF, "r"))==NULL)
    {
	info = g_strdup_printf("%s %s", _("Error: Cant open: %s\n"), SENDMAIL_LOCAL_HOST_NAMES_CONF);
        show_info(info);
        g_free(info);
        return;
    }
    fseek(fp, 0, SEEK_END);
    file_size = ftell(fp);
    rewind(fp);

    line = allocate(file_size);
    tmp  = allocate(1024);

    if( file_size > 1 )
    while(fgets(line, file_size, fp)!=NULL)
    {
        if( line == NULL || strlen(line) < 3 || commented(line) )
          continue;

	snprintf(tmp, 1000, "%s", line);

	/* Skip spaces */
	for(i=0; tmp[i]!='\0'; i++)
	  if( tmp[i]!=' ' )
	    break;

	for(i=i; tmp[i]!='\0'; i++)
	if( tmp[i]==' ' || tmp[i]=='\t' || tmp[i]=='\n' )
	{
	    tmp[i]='\0';
	    break;
	}  
    	tmp_txt = gtk_entry_get_text(GTK_ENTRY(widgets->server_set_entry[2]));
    	    
    	if( strlen(tmp_txt) > 2 )
	  addrs = g_strdup_printf("%s %s", tmp_txt, tmp);
	else
	  addrs = g_strdup_printf("%s", tmp);
	    
	utf8 = g_locale_to_utf8(addrs, strlen(addrs), NULL, NULL, NULL);
    	gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[2]), utf8);

    	if( utf8!=NULL )
    	  g_free(utf8);
    	if( addrs!=NULL )
    	  g_free(addrs);
    }
    fclose(fp);
    free(line);
    free(tmp);

    /* If there are no local host names we insert "localhost" */
    tmp_txt = gtk_entry_get_text(GTK_ENTRY(widgets->server_set_entry[2]));
    if( strlen(tmp_txt) < 3 )
      gtk_entry_set_text(GTK_ENTRY(widgets->server_set_entry[2]), "localhost");
      
    



    /* Notify about this server beeing an open relay...
       ... if user and pass auth isnt activated... */ 
/*
    if( strstr(addrs, "0.0.0.0") || strstr(addrs, "*") )
    {
        open_relay = 1;
    }

    if( open_relay )
    {
	info = g_strdup_printf(("Warning: This server is an open relay.\n"));
        show_info(info);
        g_free(info);
    }
*/
}
