/* GAdmin-Sendmail - An easy to use GTK+ frontend for the sendmail mailserver.
 * Copyright (C) 2008 - 2009 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/


#include "../config.h"
#include <gtk/gtk.h>
#include "support.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "allocate.h"
#include "widgets.h"
#include "populate_maillog_tab.h"
#include "show_info.h"


void populate_maillog_tab(struct w *widgets)
{
    /* Populates the email log tab */
    FILE *fp;
    long file_size;
    char *line;
    GtkTreeIter iter;
    GtkTreePath *path;
    gboolean edit=0;
    int found = 0;
    gchar *utf8=NULL, *info=NULL, *mail_log;

    gtk_list_store_clear(widgets->maillog_store);
    
    /* Default to the configured email log */
    mail_log = g_strdup_printf("%s", SENDMAIL_MAIL_LOG);

    if((fp=fopen(mail_log, "r"))==NULL) 
    {
        info = g_strdup_printf(_("Cant open the email log here:\n%s\n"), mail_log);
	show_info(info);
	g_free(info);
	g_free(mail_log);
        return;
    }
    fseek(fp, 0, SEEK_END);
    file_size = ftell(fp);
    rewind(fp);

    line = allocate(file_size+1);

    if( file_size > 1 )
    while(fgets(line, file_size, fp)!=NULL)
    {
	found = 1;

    	gtk_list_store_append(GTK_LIST_STORE(widgets->maillog_store), &iter);
    	utf8 = g_locale_to_utf8(line, strlen(line)-1, NULL, NULL, NULL);
    	gtk_list_store_set(GTK_LIST_STORE(widgets->maillog_store), &iter, 0, utf8, -1);
    }
    fclose(fp);
    free(line);
    g_free(mail_log);

    if(utf8!=NULL)
      g_free(utf8);

    /* Cant set treepath if there arent any rows, then itll crash */
    if( ! found )
      return;

    path = gtk_tree_path_new_first();
    gtk_tree_view_set_cursor(GTK_TREE_VIEW(widgets->maillog_treeview), path, NULL, edit);
    gtk_tree_path_free(path);
}
