/* GAdmin-Sendmail - An easy to use GTK+ frontend for the sendmail mailserver.
 * Copyright (C) 2008 - 2009 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include "../config.h"
#include <gtk/gtk.h>
#include "support.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "allocate.h"
#include "widgets.h"
#include "populate_access_tab.h"
#include "show_info.h"
#include "commented.h"
#include "functions.h"
#include "get_option_pos.h"

extern char global_server_address[1024];
extern char global_server_port[1024];
extern char global_server_name[1024];
extern char global_server_type[1024];



/* Populates the access treeview */
void populate_access_tab(struct w *widgets)
{
    FILE *fp;
    GtkTreeIter iter;
    GtkTreePath *path;
    gboolean edit=0;
    char *line, *tmp, *new_buffer;
    long file_size=0; //, old_pos=0, opt_pos=0;
    int i=0, access_line_found=0;
//    gchar *address_line, *name_line;
    gchar *utf8=NULL, *info=NULL;

    gtk_list_store_clear(widgets->access_store);


    if((fp=fopen(SENDMAIL_ACCESS_CONF, "r"))==NULL)
    {
	/* We just show this popup here too many windows looks bad */
	info = g_strdup_printf("%s %s", _("Error: Can not open access file here:\n"), SENDMAIL_ACCESS_CONF);
        show_info(info);
        g_free(info);
        return;
    }
    fseek(fp, 0, SEEK_END);
    file_size = ftell(fp);
    rewind(fp);

    line = allocate(file_size);
    new_buffer = allocate(file_size);               

    if( file_size > 1 )
    while(fgets(line, file_size, fp)!=NULL)
    {
        if( commented(line) || strlen(line) < 5 || ! strstr(line, ":") )
          continue;

	gtk_list_store_append(GTK_LIST_STORE(widgets->access_store), &iter);

	access_line_found = 1;

	/* Set the selected combo items */
	if( cmplowercase(line, "connect:") )
	  gtk_list_store_set(GTK_LIST_STORE(widgets->access_store), &iter, 0, "Connect", -1); 
	if( cmplowercase(line, "from:") )
	  gtk_list_store_set(GTK_LIST_STORE(widgets->access_store), &iter, 0, "From", -1); 
	if( cmplowercase(line, "to:") )
	  gtk_list_store_set(GTK_LIST_STORE(widgets->access_store), &iter, 0, "To", -1); 
	if( cmplowercase(line, "spam:") )
	  gtk_list_store_set(GTK_LIST_STORE(widgets->access_store), &iter, 0, "Spam", -1); 

	/* Insert the /hostname/domainname or email 
	   Locate the first char after the first ":" char */
	for(i=0; line[i]!='\0'; i++)
	   if( line[i]==':' )
	      break;

	i++;
	
	/* There should not be any spaces after the ":"
	   If so, scroll past it */
	if( line[i]==' ' || line[i]=='\t' )
	{
	    for(i=0; line[i]!='\0'; i++)
	       if( line[i]!=' ' && line[i]!='\t' )
		 break;
	}

	/* We have located the first char or word after ":" */
	tmp = allocate(strlen(line)+1);
	snprintf(tmp, strlen(line), "%s", &line[i]); 

	/* Cut away anything after this char or word */
	for(i=0; tmp[i]!='\0'; i++)
	   if( tmp[i]==' ' || tmp[i]=='\t' || tmp[i]=='\n' || tmp[i]=='\r'  )
	      break;
	tmp[i]='\0';
	
	utf8 = g_locale_to_utf8(tmp, strlen(tmp), NULL, NULL, NULL);
	gtk_list_store_set(GTK_LIST_STORE(widgets->access_store), &iter, 1, utf8, -1);
	free(tmp);
	if( utf8 !=NULL )
          g_free(utf8);

	/* Set the selected combo items for access type */
// double check: must be a space or tab after the words...
	if( cmplowercase(line, "\trelay") || cmplowercase(line, " relay") )
	  gtk_list_store_set(GTK_LIST_STORE(widgets->access_store), &iter, 2, "RELAY", -1); 
	if( cmplowercase(line, "\tok") || cmplowercase(line, " ok") )
	  gtk_list_store_set(GTK_LIST_STORE(widgets->access_store), &iter, 2, "OK", -1); 
	if( cmplowercase(line, "\tfriend") || cmplowercase(line, " friend") )
	  gtk_list_store_set(GTK_LIST_STORE(widgets->access_store), &iter, 2, "FRIEND", -1); 
	if( cmplowercase(line, "\treject") || cmplowercase(line, " reject") )
	  gtk_list_store_set(GTK_LIST_STORE(widgets->access_store), &iter, 2, "REJECT", -1); 
	if( cmplowercase(line, "\tdiscard") || cmplowercase(line, " discard") )
	  gtk_list_store_set(GTK_LIST_STORE(widgets->access_store), &iter, 2, "DISCARD", -1); 
    }
    fclose(fp);
    free(line);
    free(new_buffer);

    if( access_line_found )
    {
	path = gtk_tree_path_new_first();
	gtk_tree_view_set_cursor(GTK_TREE_VIEW(widgets->access_treeview), path, NULL, edit);
	gtk_tree_path_free(path);
    }
}
