/* GAdmin-Sendmail - An easy to use GTK+ frontend for the sendmail mailserver.
 * Copyright (C) 2008 - 2009 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/


#include "../config.h"
#include <gtk/gtk.h>
#include "gettext.h"
#include "support.h"
#include "create_main_window.h"
#include "gadmin-sendmail.h"
#include "widgets.h"
#include "commands.h"
#include "functions.h"
#include "status_update.h"
#include "set_version.h"
#include "standard_conf.h"

/* For getuid */
#include <stdio.h>
#include <unistd.h>
#include <sys/types.h>


#include "create_server_tab.h"
#include "create_server_settings.h"
#include "create_user_tab.h"
#include "create_user_settings.h"
#include "create_client_tab.h"
#include "create_disc_tab.h"
#include "create_access_tab.h"
#include "create_maillog_tab.h"
#include "create_conf_tab.h"
#include "populate_gadmin_sendmail.h"
#include "show_info.h"

int MAX_READ_POPEN = 16384;
int activated = 0;
int use_tls = 0;

int info_window_exit_main = 0;

// Unused
int sendmail_mayor_version = 0;

char global_server_address[1024]="";
char global_server_port[1024]="";
char global_server_name[1024]="";
char global_server_type[1024]="";
char global_user_name[1024]="";



int main(int argc, char *argv[])
{
    int i = 0;
    gchar *info;

#ifdef ENABLE_NLS
    bindtextdomain(GETTEXT_PACKAGE, PACKAGE_LOCALE_DIR);
    bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
    textdomain(GETTEXT_PACKAGE);
#endif

    gtk_set_locale();
    gtk_init(&argc, &argv);

    wid* widgets = g_malloc(sizeof(wid));

    /* Non root usage */
    if( ! getuid() == 0 )
    {
	/* For setting a different exit method in the info window */
	info_window_exit_main = 1;

        info = g_strdup_printf("You must be root to run: %s\nThis window will close in 10 seconds.\n", PACKAGE);
        show_info(info);
        g_free(info);

	/* Users can close the info window earlier then the timeout */
	for(i=0; i<10; i++)
	{
    	    while(gtk_events_pending())
                  gtk_main_iteration();

	    /* Set when close info window is clicked */
	    if( info_window_exit_main == 2 )
	      break;

    	    usleep(100000*10);
    	}

	g_free(widgets);
	return 0;
    }

    
    /* Create the main window */
    create_main_window(widgets);
    
    /* Set Sendmail version */
    set_version(widgets);

    /* If sendmail has the mod_tls module we 
       create, show and use the TLS widgets */
    use_tls = using_tls();

    /* Create the server tab */
    create_server_tab(widgets);

    /* Create the server settings */
    create_server_settings(widgets);

    /* Create the access tab */
    create_access_tab(widgets);

    /* Create the user tab */
    create_user_tab(widgets);

    /* Create the user settings */
    create_user_settings(widgets);

    /* Create the client tab */
    create_client_tab(widgets);

    /* Create the disc tab */
    create_disc_tab(widgets);

    /* Create the email log tab */
    create_maillog_tab(widgets);

    /* Create the conf tab */
    create_conf_tab(widgets);


    /* Remove all sendmail.mc comments */
    remove_sendmail_mc_comments();

    /* Check for sendmail-cf dir here: SHAREDSTATEDIR/sendmail-cf */
    // Or dont because itll show when launching the app...
//    conf_path = g_strdup_printf("%s", SENDMAIL_CF_DIR);
//    if( ! file_exists(conf_path) )

      /* The conf is ok, populate the entire gui */
      populate_gadmin_sendmail(widgets);
//    g_free(conf_path);


    /* Window close button (x) */   
    g_signal_connect(GTK_OBJECT(widgets->main_window), "destroy",
	             GTK_SIGNAL_FUNC(gtk_main_quit), NULL);


    gtk_timeout_add(1000, (GtkFunction) status_update, widgets);

    gtk_main();

    g_free(widgets);


    return 0;    
}
