/* GAdmin-Sendmail - An easy to use GTK+ frontend for the sendmail mailserver.
 * Copyright (C) 2008 - 2009 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/


#include "../config.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include "gettext.h"
#include "widgets.h"
#include "make_settings_entries.h"
#include "make_settings_combos.h"
#include "make_settings_spinbuttons.h"
#include "make_settings_progressbars.h"
#include "make_settings_labels.h"
#include "make_settings_hseparators.h"
#include "generate_cert.h"
#include "create_server_settings.h"

extern int use_tls;



void create_server_settings(struct w *widgets)
{
    GtkTooltips *tooltips;
//    GtkWidget *gen_cert_button;
    gchar *utf8 = NULL;
//    gdouble progress_val = 1.0;
    gchar *combo_text;
    gchar *text;

    /* Counters for the widgets and positions in the table */
    int a = 0;
    int b = 1;
    int ent  = 0;
    int spin = 0;
    int comb = 0;

    /* Max lengths and input */
    int entry_size = 100;

    tooltips = gtk_tooltips_new();


    /* Listen to IPv4 addresses */
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table),
    _(" Listen to IPv4 addresses: "), 0,1,a,b,entry_size);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], 
    _("IE: localhost 127.0.0.1 192.168.0.100 ?mail.example.org?\nAn empty line or 0.0.0.0 means listen to all interfaces"), NULL);
    a++; b++; ent++;

    /* Listen to IPv6 addresses */
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table),
    _(" Listen to IPv6 addresses: "), 0,1,a,b,entry_size);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], 
    _("IE: localhost ::1 ?mail.example.org?\nAn empty line means dont use IPv6"), NULL);
    a++; b++; ent++;


    /* File: local-host-names */
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table),
    _(" Local host names: "), 0,1,a,b,entry_size);
    
    text = g_strconcat("",
    _("Add all local host names for the mail server here.\n"),
    _("IE: localhost 127.0.0.1 192.168.0.100 mail.example.org\n"),
    NULL);
    utf8 = g_locale_to_utf8(text, strlen(text), NULL, NULL, NULL);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], utf8, NULL);

    g_free(text);
    if( utf8!=NULL )
      g_free(utf8);

    a++; b++; ent++;


    /* Smart host */
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table),
    _(" Smart host: "), 0,1,a,b,entry_size);
    
    text = g_strconcat("",
    _("Some ISPs block outgoing SMTP traffic (port 25) and require their users "),
    _("to send all outgoing mail through their mail servers. "),
    _("Insert your ISPs mail server here if this is required.\n"),
    NULL);
    utf8 = g_locale_to_utf8(text, strlen(text), NULL, NULL, NULL);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], utf8, NULL);
    a++; b++; ent++;

    g_free(text);
    if( utf8!=NULL )
      g_free(utf8);
    
    /* Max connections (confMAX_DAEMON_CHILDREN) */
    widgets->server_set_spinbutton[spin] = make_short_spinbutton_with_label(GTK_TABLE(widgets->srv_set_table),
    _(" Max connections: "), 0,1,a,b,50);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_spinbutton[spin],
    _("Limits the amount of concurrent connections. 0 means no limit."), NULL);
    a++; b++; spin++;

    /* Max connection rate (confCONNECTION_RATE_THROTTLE) */
    widgets->server_set_spinbutton[spin] = make_short_spinbutton_with_label(GTK_TABLE(widgets->srv_set_table),
    _(" Max connection rate: "), 0,1,a,b,50);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_spinbutton[spin],
    _("Limits the amount of new connections per second. 0 means no limit."), NULL);
    a++; b++; spin++;


    /* Authentication */
    widgets->server_set_combo[comb] = make_short_combo_with_label(GTK_TABLE(widgets->srv_set_table),
    _(" Authentication: "), 0,1,a,b,50);
    combo_text = g_strdup_printf(_("Not required"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    combo_text = g_strdup_printf(_("User and password"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    a++; b++; comb++;


    /* Encryption */
    widgets->server_set_combo[comb] = make_short_combo_with_label(GTK_TABLE(widgets->srv_set_table),
    _(" Encryption: "), 0,1,a,b,50);
    combo_text = g_strdup_printf(_("No encryption"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    combo_text = g_strdup_printf(_("Encryption"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    combo_text = g_strdup_printf(_("Both"));
    utf8 = g_locale_to_utf8(combo_text, strlen(combo_text), NULL, NULL, NULL);
    gtk_combo_box_append_text(GTK_COMBO_BOX(widgets->server_set_combo[comb]), utf8);
    g_free(combo_text); g_free(utf8);
    a++; b++; comb++;



    /* Checkbox Listen to submission port 587 */


    /* Server user */
/*
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" The server runs as this user: "), 0,1,a,b,200);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], _("The server drops root privileges and runs as this user"), NULL);
    a++; b++; ent++;
*/

    /* Server group */
/*
    widgets->server_set_entry[ent] = make_long_entry_with_label(GTK_TABLE(widgets->srv_set_table), _(" The server runs as this group: "), 0,1,a,b,200);
    gtk_tooltips_set_tip(tooltips, widgets->server_set_entry[ent], _("The server drops root privileges and runs as this group"), NULL);
    a++; b++; ent++;
*/

    gtk_widget_show_all(widgets->main_window);
}
