/* GAdmin-Sendmail - An easy to use GTK+ frontend for the sendmail mailserver.
 * Copyright (C) 2008 - 2009 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include "../config.h"
#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include "widgets.h"
#include "gettext.h"
#include "allocate.h"
#include "make_settings_entries.h"
#include "make_settings_buttons.h"
#include "create_client_tab.h"



void send_email(struct w *widgets)
{
    FILE *fp;
    char *line, *output;
    gchar *cmd, *utf8, *text;
    GtkTextBuffer *textbuffer;
    G_CONST_RETURN gchar *from, *to, *subject, *message;
    
    from    = gtk_entry_get_text(GTK_ENTRY(widgets->client_from_entry));
    to      = gtk_entry_get_text(GTK_ENTRY(widgets->client_to_entry));
    subject = gtk_entry_get_text(GTK_ENTRY(widgets->client_subject_entry));
    message = gtk_entry_get_text(GTK_ENTRY(widgets->client_message_entry));

    if( from == NULL || strlen(from) < 1 )
    {
	printf("The from field cannot be empty.\n");
	return;
    }
    if( to == NULL || strlen(to) < 1 )
    {
	printf("The from field cannot be empty.\n");
	return;
    }
    if( subject == NULL || strlen(subject) < 1 )
    {
	printf("The subject field cannot be empty.\n");
	return;
    }
    if( message == NULL || strlen(message) < 1 )
    {
	printf("The message field cannot be empty.\n");
	return;
    }

    /* echo "Hello, sending a test mail" | mailx -s "Subject 1" -r root@localhost root@localhost */

    cmd = g_strdup_printf("echo \"%s\" | mailx -v -s \"%s\" -r %s %s", message, subject, from, to);
    if((fp=popen(cmd, "r"))==NULL)
    {
	// Fixme, add error text to the text view.

	if( cmd!=NULL )
          g_free(cmd);
	return;
    }

    /* Insert the output into the textview */    
    line = allocate(1024);
    output = allocate(16384);
    strcpy(output, ""); /* Initialize it with non null */
    while(fgets(line, 1024, fp)!=NULL)
    {
	if( output!=NULL && strlen(output) < (16384-1024) )
	  strcat(output, line);

//	printf("Line: %s\n", line);    
    }

    textbuffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(widgets->client_textview));
    text = g_strdup_printf("%s", output);
    utf8 = g_locale_to_utf8(text, strlen(text), NULL, NULL, NULL);
    gtk_text_buffer_set_text(textbuffer, utf8, strlen(utf8));

    free(line);
    free(output);
    fclose(fp);

    if( cmd!=NULL )
      g_free(cmd);
}



void create_client_tab(struct w *widgets)
{
    GtkWidget *hbox;
    GtkWidget *frame;
    gchar *text, *utf8=NULL;
    GtkTextBuffer *textbuffer;
    int ent = 0;    
    int a   = 0;
    int b   = 1;

    GtkTooltips *tooltips;
    tooltips = gtk_tooltips_new();

    /* Add a frame */
    frame = gtk_frame_new(_("Email client for testing sendmail configuration:"));

    /* Add a table with for the settings with 3 columns */
    widgets->client_set_table = gtk_table_new(NUM_SERVERTAB_ENTRIES+NUM_SERVERTAB_SPINBUTTONS+NUM_SERVERTAB_COMBOS, 3, FALSE);
    gtk_box_pack_start(GTK_BOX(widgets->notebook_vbox4), frame, FALSE, TRUE, 1);
    gtk_container_add(GTK_CONTAINER(frame), widgets->client_set_table);

    /* A scrolled window with the client output textview */
    hbox = gtk_hbox_new(TRUE, 0);
    gtk_box_pack_start(GTK_BOX(widgets->notebook_vbox4), hbox, TRUE, TRUE, 0);

    widgets->client_scrolled_window = gtk_scrolled_window_new(NULL, NULL);
    gtk_box_pack_start(GTK_BOX(hbox), widgets->client_scrolled_window, TRUE, TRUE, 0);

    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(widgets->client_scrolled_window),
                                                                   GTK_POLICY_AUTOMATIC,
                                                                       GTK_POLICY_ALWAYS);
    /* Must set a larger size or it wont scroll */
    gtk_widget_set_size_request(widgets->client_scrolled_window, -1, 140);

    widgets->client_textview = gtk_text_view_new();
    gtk_container_add(GTK_CONTAINER(widgets->client_scrolled_window), widgets->client_textview);

    /* Add some text to the debug and output window */
    textbuffer = gtk_text_view_get_buffer(GTK_TEXT_VIEW(widgets->client_textview));
    text = g_strdup_printf(_("\n\n\n\t\t\t\tOutput from sent emails will be shown here."));
    utf8 = g_locale_to_utf8(text, strlen(text), NULL, NULL, NULL);
    gtk_text_buffer_set_text(textbuffer, utf8, strlen(utf8));

    /* Mail from entry */
    widgets->client_from_entry = make_long_entry_with_label(GTK_TABLE(widgets->client_set_table),
    _(" Send mail from: "), 0,1,a,b, 128);
    gtk_tooltips_set_tip(tooltips, widgets->client_from_entry, _("user@example.org or user@localhost"), NULL);
    text = g_strdup_printf(_("root@localhost"));
    utf8 = g_locale_to_utf8(text, strlen(text), NULL, NULL, NULL);
    gtk_entry_set_text(GTK_ENTRY(widgets->client_from_entry), utf8);
    a++; b++; ent++;

    /* Mail to entry */
    widgets->client_to_entry = make_long_entry_with_label(GTK_TABLE(widgets->client_set_table),
    _(" Send mail to: "), 0,1,a,b, 128);
    gtk_tooltips_set_tip(tooltips, widgets->client_to_entry, _("user@example.org or user@localhost"), NULL);
    text = g_strdup_printf(_("root@localhost"));
    utf8 = g_locale_to_utf8(text, strlen(text), NULL, NULL, NULL);
    gtk_entry_set_text(GTK_ENTRY(widgets->client_to_entry), utf8);
    a++; b++; ent++;

    /* Subject entry */
    widgets->client_subject_entry = make_long_entry_with_label(GTK_TABLE(widgets->client_set_table),
    _(" Subject: "), 0,1,a,b, 128);
    gtk_tooltips_set_tip(tooltips, widgets->client_subject_entry, _("A message subject"), NULL);
    text = g_strdup_printf(_("Im testing Sendmail."));
    utf8 = g_locale_to_utf8(text, strlen(text), NULL, NULL, NULL);
    gtk_entry_set_text(GTK_ENTRY(widgets->client_subject_entry), utf8);
    a++; b++; ent++;

    /* Send email button and message entry */
    GtkWidget *send_button;
    widgets->client_message_entry = gtk_entry_new();
    send_button = make_button_with_entry(GTK_TABLE(widgets->client_set_table),
    widgets->client_message_entry, "gtk-refresh",
    _("Send message:"), _("Send the email"), 0,1,a,b,350);

    text = g_strdup_printf(_("This is a test message."));
    utf8 = g_locale_to_utf8(text, strlen(text), NULL, NULL, NULL);
    gtk_entry_set_text(GTK_ENTRY(widgets->client_message_entry), utf8);

    gtk_tooltips_set_tip(tooltips, widgets->client_message_entry, _("Write the message to send here"), NULL);
    a++; b++;

    if( text!=NULL )
      g_free(text);
    if( utf8!=NULL )
      g_free(utf8);

    g_signal_connect_swapped(G_OBJECT(send_button), "clicked", 
                                 G_CALLBACK(send_email), widgets);
                                 
    gtk_widget_show_all(widgets->main_window);
}
