/* GAdmin-Sendmail - An easy to use GTK+ frontend for the sendmail mailserver.
 * Copyright (C) 2008 - 2009 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include "widgets.h"
#include "gettext.h"
#include "show_info.h"
#include "apply_server_settings.h"
#include "create_import_window.h"

/* Wether to let the access sections expand */
#define EXPAND_ACCESS_SECTION FALSE

#define NUM_HBOXES 2


char access_type[1024]="";

void set_access_type(char *type, struct w *widgets)
{
    snprintf(access_type, 1000, "%s", type);
}

void scroll_to_last_row(GtkTreeView *treeview, GtkTreeIter iter)
{
    /* Scroll to the last row */
    GtkTreeModel *model;
    GtkTreePath *path;
    GtkTreeSelection *selection;

    model = gtk_tree_view_get_model(GTK_TREE_VIEW(treeview));
    path = gtk_tree_model_get_path(GTK_TREE_MODEL(model), &iter);
    selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(treeview));
    gtk_tree_selection_select_path(GTK_TREE_SELECTION(selection), path);
    gtk_tree_view_set_cursor(GTK_TREE_VIEW(treeview), path, 0, TRUE);
    gtk_tree_path_free(path);
}


void add_access(struct w *widgets)
{
    GtkTreeIter iter;
    gchar *info;

    if( ! strcmp(access_type, "access") )
    {
	gtk_list_store_append(GTK_LIST_STORE(widgets->access_store), &iter);
	scroll_to_last_row(GTK_TREE_VIEW(widgets->access_treeview), iter);
    }

    info = g_strdup_printf("%s",
    _("A new row has been added for this option type.\nClick the cells in this row to write a new option specification.\n"));
    show_info(info);
    g_free(info);
}


void del_access(struct w *widgets)
{
    GtkTreeIter iter;
    gboolean val;

    if( ! strcmp(access_type, "access") )
    {
	val = gtk_list_store_remove(GTK_LIST_STORE(widgets->access_store), &iter);
    }
}


void access_cell_edited(GtkCellRendererText *cell, gchar *path_string,
			gchar *new_text, GtkListStore *store)
{
    /* Changes the edited cells text */
    GtkTreeIter iter;
    GtkTreePath *path = NULL;

    int column = (int) g_object_get_data(G_OBJECT(cell), "column");

    path = gtk_tree_path_new_from_string(path_string);
    gtk_tree_model_get_iter(GTK_TREE_MODEL(store), &iter, path);

    if( path!=NULL )
      gtk_tree_path_free(path);

    gtk_list_store_set(GTK_LIST_STORE(store), &iter, column, new_text, -1);
}


void delete_row_clicked(gpointer data, GtkTreeView *treeview)
{
    /* Deletes the selected treeview row */
    GtkTreeModel *model;
    GtkTreeStore *model_store;
    GtkTreeSelection *select;
    GtkTreeIter iter;
    gboolean val;
		
    model_store = (GtkTreeStore *) gtk_tree_view_get_model(treeview);
    select = gtk_tree_view_get_selection(GTK_TREE_VIEW(treeview));
				
    if( gtk_tree_selection_get_selected(select, &model, &iter) )
    {
	val = gtk_list_store_remove(GTK_LIST_STORE(model_store), &iter);
    }
}

void create_access_tab(struct w *widgets)
{
    GtkWidget *main_vbox;
    GtkWidget *hbox[NUM_HBOXES];
    GtkTreeIter combo_iter;
    GtkTooltips *tooltips;
    gchar *utf8=NULL;
    int i = 0;

    /* The treeview has 3 columns [combo] [entry] [combo] */

    GtkWidget *access_scrolled_window;

    tooltips = gtk_tooltips_new();

    /* Create a main vbox in notebook_vbox2 */
    main_vbox = gtk_vbox_new(FALSE, 0);
    gtk_box_pack_start(GTK_BOX(widgets->notebook_vbox2), main_vbox, TRUE, TRUE, 0);

    /* Pack hboxes into the main vbox */
    for(i=0; i<NUM_HBOXES; i++)
    {
	hbox[i] = gtk_hbox_new(TRUE, 0);
	gtk_container_add(GTK_CONTAINER(main_vbox), hbox[i]);
    }  

    /* Create the cell renderers [combo] [entry] [combo] and make the entry editable */

    /* Combo in a cell with a column number */	
    widgets->access_cell[0] = gtk_cell_renderer_combo_new();
    g_object_set(widgets->access_cell[0], "editable", TRUE, NULL);
    g_object_set(G_OBJECT(widgets->access_cell[0]), "text-column", 0, NULL);
    g_object_set_data(G_OBJECT(widgets->access_cell[0]), "column", (void*)(0));
	

    widgets->access_cell[1] = gtk_cell_renderer_text_new();
    g_object_set(widgets->access_cell[1], "editable", TRUE, NULL);
    g_object_set_data(G_OBJECT(widgets->access_cell[1]), "column", (void*)(1));


    /* Combo in a cell with a column number */
    widgets->access_cell[2] = gtk_cell_renderer_combo_new();
    g_object_set(widgets->access_cell[2], "editable", TRUE, NULL);
    g_object_set(G_OBJECT(widgets->access_cell[2]), "text-column", 0, NULL);
    g_object_set_data(G_OBJECT(widgets->access_cell[2]), "column", (void*)(2));


    /* Create the combos and their contents */    
    widgets->access_combo_list[0] = gtk_list_store_new(1, G_TYPE_STRING);
    gtk_list_store_append(widgets->access_combo_list[0], &combo_iter);
    gtk_list_store_set(widgets->access_combo_list[0], &combo_iter, 0, "Connect", -1);
    gtk_list_store_append(widgets->access_combo_list[0], &combo_iter);
    gtk_list_store_set(widgets->access_combo_list[0], &combo_iter, 0, "From", -1);
    gtk_list_store_append(widgets->access_combo_list[0], &combo_iter);
    gtk_list_store_set(widgets->access_combo_list[0], &combo_iter, 0, "To", -1);
    gtk_list_store_append(widgets->access_combo_list[0], &combo_iter);
    gtk_list_store_set(widgets->access_combo_list[0], &combo_iter, 0, "Spam", -1);

    /* Add combo list 0 to the first access combo cell */
    g_object_set(G_OBJECT(widgets->access_cell[0]), "model", widgets->access_combo_list[0], "editable", TRUE, NULL);
	    

    widgets->access_combo_list[1] = gtk_list_store_new(1, G_TYPE_STRING);
    gtk_list_store_append(widgets->access_combo_list[1], &combo_iter);
    gtk_list_store_set(widgets->access_combo_list[1], &combo_iter, 0, "RELAY", -1);
    gtk_list_store_append(widgets->access_combo_list[1], &combo_iter);
    gtk_list_store_set(widgets->access_combo_list[1], &combo_iter, 0, "OK", -1);
    gtk_list_store_append(widgets->access_combo_list[1], &combo_iter);
    gtk_list_store_set(widgets->access_combo_list[1], &combo_iter, 0, "FRIEND", -1);
    gtk_list_store_append(widgets->access_combo_list[1], &combo_iter);
    gtk_list_store_set(widgets->access_combo_list[1], &combo_iter, 0, "REJECT", -1);
    gtk_list_store_append(widgets->access_combo_list[1], &combo_iter);
    gtk_list_store_set(widgets->access_combo_list[1], &combo_iter, 0, "DISCARD", -1);
    
    /* Add combo list 1 to the second access combo cell */
    g_object_set(G_OBJECT(widgets->access_cell[2]), "model", widgets->access_combo_list[1], "editable", TRUE, NULL);


    /* Access treeview */
    access_scrolled_window = gtk_scrolled_window_new(NULL, NULL);
    gtk_box_pack_start(GTK_BOX(hbox[0]), access_scrolled_window, TRUE, TRUE, 0);
    gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(access_scrolled_window), 
						    GTK_POLICY_AUTOMATIC, 
						    GTK_POLICY_ALWAYS);
    /* Must set a larger size or it wont scroll */
    gtk_widget_set_size_request(access_scrolled_window, -1, 250);

    widgets->access_store = gtk_list_store_new(3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
    widgets->access_treeview = gtk_tree_view_new();
    gtk_tree_view_set_model(GTK_TREE_VIEW(widgets->access_treeview), GTK_TREE_MODEL(widgets->access_store));
    gtk_container_add(GTK_CONTAINER(access_scrolled_window), widgets->access_treeview);
    gtk_tree_view_set_rules_hint(GTK_TREE_VIEW(widgets->access_treeview), TRUE);

    /* Set the column labels in the treeview */
    GtkTreeViewColumn *access_criteria_col = gtk_tree_view_column_new_with_attributes(_("Access criteria"), widgets->access_cell[0], "text", 0, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->access_treeview), GTK_TREE_VIEW_COLUMN(access_criteria_col));

    GtkTreeViewColumn *access_for_col = gtk_tree_view_column_new_with_attributes(_("Access for"), widgets->access_cell[1], "text", 1, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->access_treeview), GTK_TREE_VIEW_COLUMN(access_for_col));

    GtkTreeViewColumn *access_type_col = gtk_tree_view_column_new_with_attributes(_("Access type"), widgets->access_cell[2], "text", 2, NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(widgets->access_treeview), GTK_TREE_VIEW_COLUMN(access_type_col));

    /* A button box */
    GtkWidget *access_button_box = gtk_hbutton_box_new();
    gtk_box_pack_start(GTK_BOX(hbox[1]), access_button_box, FALSE, FALSE, 0);
    gtk_button_box_set_layout(GTK_BUTTON_BOX(access_button_box), GTK_BUTTONBOX_SPREAD);

    /* Delete button */
    GtkWidget *delete_access_button = gtk_button_new_from_stock(GTK_STOCK_DELETE);
    gtk_box_pack_start(GTK_BOX(access_button_box), delete_access_button, FALSE, FALSE, 0);
    g_signal_connect(delete_access_button, "clicked",  
	      G_CALLBACK(delete_row_clicked), widgets->access_treeview);
    /* Add button */
    GtkWidget *add_access_button = gtk_button_new_from_stock(GTK_STOCK_ADD);
    gtk_box_pack_start(GTK_BOX(access_button_box), add_access_button, FALSE, FALSE, 0);

    g_signal_connect_swapped(G_OBJECT(add_access_button), "clicked", 
                             G_CALLBACK(set_access_type), "access");

    g_signal_connect_swapped(G_OBJECT(add_access_button), "clicked", 
                             G_CALLBACK(add_access), widgets);

    /* Apply button, saves all access settings */
    GtkWidget *apply_access_button = gtk_button_new_from_stock(GTK_STOCK_APPLY);
    gtk_box_pack_start(GTK_BOX(access_button_box), apply_access_button, FALSE, FALSE, 0);

    g_signal_connect_swapped(G_OBJECT(apply_access_button), "clicked", 
                             G_CALLBACK(apply_server_settings), widgets);

    /* Callback signals for the access cells */
    g_signal_connect(widgets->access_cell[0], "edited", G_CALLBACK(access_cell_edited), widgets->access_store);
    g_signal_connect(widgets->access_cell[1], "edited", G_CALLBACK(access_cell_edited), widgets->access_store);
    g_signal_connect(widgets->access_cell[2], "edited", G_CALLBACK(access_cell_edited), widgets->access_store);


    gtk_widget_show_all(widgets->main_window);

    if( utf8 != NULL )
      g_free(utf8);
}
