/* GAdmin-Sendmail - An easy to use GTK+ frontend for the sendmail mailserver.
 * Copyright (C) 2008 - 2009 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include "widgets.h"
#include "gettext.h"
#include "reread_conf.h"
#include "show_info.h"
#include "functions.h"
#include "apply_server_settings.h"
#include "allocate.h"
#include "commented.h"
#include "get_option_pos.h"
#include "populate_server_settings.h"
#include "populate_access_tab.h"
#include "populate_conf_tab.h"


extern char global_server_address[1024];
extern char global_server_port[1024];
extern char global_server_name[1024];
extern char global_server_type[1024];

extern int use_tls;

extern int activated;



int has_value(gchar *input)
{
    int have_value = 0;

    if( input!=NULL && strlen(input) > 1 )
      have_value = 1;

    return have_value;
}



/* Removes all lines that contains matches for "rmatch1" to "rmatch3".
   All supplied rmatches must match or the line is not removed. */
void lowercase_remove_sendmail_mc_option(gchar *rmatch1, gchar *rmatch2, gchar *rmatch3)
{
    FILE *fp;
    long file_size = 0;
    char *line, *new_conf;
    gchar *info;

    if( ! has_value(rmatch1) )
    {
	printf("Error: No value supplied for rmatch1\n");
        return;
    }

    if((fp=fopen(SENDMAIL_MC_CONF, "r"))==NULL)
    {
	info = g_strdup_printf(_("Can not read sendmail configuration file here: \n%s\n"), SENDMAIL_MC_CONF);
	show_info(info);
	g_free(info);
        return;
    }
    fseek(fp, 0, SEEK_END);
    file_size = ftell(fp);
    rewind(fp);

    line     = allocate(file_size+1);
    new_conf = allocate(file_size+1);

    if( file_size > 1 )
    while(fgets(line, file_size, fp)!=NULL)
    {
	if( has_value(rmatch1) )
	{
	    if( ! cmplowercase(line, rmatch1) )
	    {
		strcat(new_conf, line);
		continue;
	    }
	}
	
	if( has_value(rmatch2) )
	{
	    if( ! cmplowercase(line, rmatch2) )
	    {
	        strcat(new_conf, line);
	        continue;
	    }
	}
	
	if( has_value(rmatch3) )
	{
	    if( ! cmplowercase(line, rmatch3) )
	    {
		strcat(new_conf, line);
		continue;
	    }
	}

	/* The supplied options matches this line, dump it */
    }
    free(line);
    fclose(fp);

    /* Write the new conf */
    if((fp=fopen(SENDMAIL_MC_CONF, "w+"))==NULL)
    {
	info = g_strdup_printf(_("Can not write sendmail configuration file here: \n%s\n"), SENDMAIL_MC_CONF);
	show_info(info);
	g_free(info);
        return;
    }
    fputs(new_conf, fp);
    fclose(fp);
    free(new_conf);
}


/* Append lines to sendmail mc configuration */
void append_sendmail_mc_option(gchar *option_line)
{
    FILE *fp;
    gchar *info;

    if((fp=fopen(SENDMAIL_MC_CONF, "a+"))==NULL)
    {
	info = g_strdup_printf(_("Can not append sendmail configuration file here: \n%s\n"), SENDMAIL_MC_CONF);
	show_info(info);
	g_free(info);
        return;
    }
    fputs(option_line, fp);
    fclose(fp);
}


int write_access_file(GtkTreeModel *model, GtkTreePath *path,
	                 GtkTreeIter *iter, struct w *widgets)
{
    FILE *fp;
    gchar *conf_line, *info;
    gchar *option1, *option2, *option3;

    gtk_tree_model_get(model, iter, 0, &option1, -1);
    gtk_tree_model_get(model, iter, 1, &option2, -1);
    gtk_tree_model_get(model, iter, 2, &option3, -1);

    /* The input must be complete. */
    if( ! has_value(option1) || ! has_value(option2) || ! has_value(option3) ) 
    {
	if( has_value(option2) )
	{
	    info = g_strdup_printf(_("Missing value for an access tab option, skipping [%s]\n"), option2);
	    show_info(info);
	    g_free(info);
	}
	else
	{
	    info = g_strdup_printf(_("Missing value for an access tab option, skipping it.\n"));
	    show_info(info);
	    g_free(info);
	}
	
	/* Return false to continue iteration */
    	return FALSE;
    }
    
    /* Create the conf line to add */
    conf_line = g_strdup_printf("%s:%s\t\t\t%s\n", option1, option2, option3);

    /* Create the access file if missing and append conf lines */
    if((fp=fopen(SENDMAIL_ACCESS_CONF, "a+"))==NULL)
    {
	info = g_strdup_printf(_("Cant write access file here: \n%s\n"), SENDMAIL_ACCESS_CONF);
	show_info(info);
	g_free(info);
	
	/* Dont continue iteration */
        return TRUE;
    }
    fputs(conf_line, fp);
    fclose(fp);

    g_free(conf_line);
    
    if( option1!=NULL )
      g_free(option1);
    if( option2!=NULL )
      g_free(option2);
    if( option3!=NULL )
      g_free(option3);

    /* Return false to continue iteration */
    return FALSE; 
}


void apply_server_settings(struct w *widgets)
{
    /* Change the server configuration. */
    FILE *fp;
//    long file_size=0;
    gint active_index;
    gchar *info, *new_line, *opt_line;
//    char *line, *tmp, *config;
    char *tmp;
    /* For the access tab handling */
    GtkTreeModel *model;

    G_CONST_RETURN gchar *ipv4_addresses;
    G_CONST_RETURN gchar *ipv6_addresses;
    G_CONST_RETURN gchar *local_host_names;
    G_CONST_RETURN gchar *smart_host;
    G_CONST_RETURN gchar *max_daemon_children;
    G_CONST_RETURN gchar *connection_rate_throttle;

    ipv4_addresses   = gtk_entry_get_text(GTK_ENTRY(widgets->server_set_entry[0]));
    ipv6_addresses   = gtk_entry_get_text(GTK_ENTRY(widgets->server_set_entry[1]));
    local_host_names = gtk_entry_get_text(GTK_ENTRY(widgets->server_set_entry[2]));
    smart_host       = gtk_entry_get_text(GTK_ENTRY(widgets->server_set_entry[3]));

    max_daemon_children      = gtk_entry_get_text(GTK_ENTRY(widgets->server_set_spinbutton[0]));
    connection_rate_throttle = gtk_entry_get_text(GTK_ENTRY(widgets->server_set_spinbutton[1]));


    /* Save the access tab to the access file, remove the file first */
    if( strlen(SENDMAIL_ACCESS_CONF) > 5 )
       unlink(SENDMAIL_ACCESS_CONF);
    
    /* Call foreach on the access treeview and append to the access file */
    model = gtk_tree_view_get_model(GTK_TREE_VIEW(widgets->access_treeview));
    gtk_tree_model_foreach(GTK_TREE_MODEL(model),
                          (GtkTreeModelForeachFunc) &write_access_file, widgets);
    /* End of saving the access file */


    /* Save the local-host-names */
    if((fp=fopen(SENDMAIL_LOCAL_HOST_NAMES_CONF, "w+"))==NULL)
    {
	info = g_strdup_printf(_("Cant write a new local-host-names file here: \n%s\n"), SENDMAIL_LOCAL_HOST_NAMES_CONF);
	show_info(info);
	g_free(info);
        return;
    }
    /* There must be an extra whitespace in the beginning and at the end for strtok */
    new_line = g_strdup_printf(" %s ", local_host_names);

    tmp = strtok(new_line, " ");
    while( tmp != NULL )
    {
	fputs(tmp, fp);
	fputs("\n", fp);

	/* We pass NULL to strtok to get the next token in the string */
	tmp = strtok(NULL, " ");
    }
    fclose(fp);
    g_free(new_line);
    /* End of saving local-host-names */





    /* Remove the sendmail mc configuration values that we handle... */

    /* Listen to IPv4 addresses:
       DAEMON_OPTIONS(`Port=smtp,Addr=127.0.0.1, Name=MTA')dnl */
    lowercase_remove_sendmail_mc_option("daemon_options(`port=smtp", "addr=", "name=mta'");

    /* Listen to IPv6 addresses:
       DAEMON_OPTIONS(`Port=smtp,Addr=::1, Name=MTA-v6, Family=inet6')dnl */
    lowercase_remove_sendmail_mc_option("daemon_options(`port=smtp", "addr=", "name=mta-v6");

    /* Use IPv6 addresses:
       DAEMON_OPTIONS(`Name=MTA-v4, Family=inet, Name=MTA-v6, Family=inet6')dnl */
    lowercase_remove_sendmail_mc_option("daemon_options(`name=mta-v4", "name=mta-v6", "family=inet6'");

    

    /* Listen to Encryption options */
    lowercase_remove_sendmail_mc_option("daemon_options(`port=smtps", "m=s", "name=tlsmta'");
    
    

    /* Smart host:
       define(`SMART_HOST', `smtp.your.provider')dnl */
    lowercase_remove_sendmail_mc_option("define(", "smart_host", "");

    /* Max connections:
       define(`confMAX_DAEMON_CHILDREN', `20')dnl */
    lowercase_remove_sendmail_mc_option("confmax_daemon_children", "", "");

    /* Throttle connection rate:
       define(`confCONNECTION_RATE_THROTTLE', `3')dnl */
    lowercase_remove_sendmail_mc_option("confconnection_rate_throttle", "", "");



    /* Remove all certificate paths */
    lowercase_remove_sendmail_mc_option("confcacert_path", "", "");
    lowercase_remove_sendmail_mc_option("confcacert", "", "");
    lowercase_remove_sendmail_mc_option("confserver_cert", "", "");
    lowercase_remove_sendmail_mc_option("confserver_key", "", "");

    
    /* Remove authentication option
       define(`confAUTH_OPTIONS', `A p')dnl */
    lowercase_remove_sendmail_mc_option("confauth_options", "", "");

    /* Remove authentication mechanism options
       TRUST_AUTH_MECH(`EXTERNAL DIGEST-MD5 CRAM-MD5 LOGIN PLAIN')dnl
       define(`confAUTH_MECHANISMS', `EXTERNAL GSSAPI DIGEST-MD5 CRAM-MD5 LOGIN PLAIN')dnl */
    lowercase_remove_sendmail_mc_option("trust_auth_mech", "", "");
    lowercase_remove_sendmail_mc_option("confauth_mechanisms", "", "");

    /* Remove encryption required option
     DAEMON_OPTIONS(`Port=smtps, Name=TLSMTA, M=s')dnl */
    lowercase_remove_sendmail_mc_option("daemon_options", "port=smtps", "name=tlsmta");
    

/* DONE !!!
# Allows relaying without user/pass.
define(`confAUTH_OPTIONS', `A')dnl
# Allows relaying if the user authenticates, and disallows plaintext authentication.
dnl define(`confAUTH_OPTIONS', `A p')dnl
*/

/* DONE !!!... But should be used with the combo but before that have 1 "Auth Mechanism Entry"...
# Please remember that saslauthd needs to be running for AUTH. 
dnl TRUST_AUTH_MECH(`EXTERNAL DIGEST-MD5 CRAM-MD5 LOGIN PLAIN')dnl
dnl define(`confAUTH_MECHANISMS', `EXTERNAL GSSAPI DIGEST-MD5 CRAM-MD5 LOGIN PLAIN')dnl
*/

/* DONE !!!
# The following causes sendmail to additionally listen to port 465, and
# starts immediately in TLS mode upon connecting. Port 25 or 587 followed
# by STARTTLS is preferred, but roaming clients using Outlook Express can't
# do STARTTLS on ports other than 25. Mozilla Mail can ONLY use STARTTLS
# and doesn't support the deprecated smtps; Evolution <1.1.1 uses smtps
# when SSL is enabled. For this to work your OpenSSL certificates must be configured.
dnl DAEMON_OPTIONS(`Port=smtps, Name=TLSMTA, M=s')dnl
*/


/*
# The following causes sendmail to additionally listen to port 587 for mail from clients.
dnl DAEMON_OPTIONS(`Port=submission, Name=MSA, M=Ea')dnl
*/


    /* Add sendmail mc configuration values according to the gui settings... */


    /* Get the encryption type to determine what to add */
    



    /* Listen to IPv4 addresses: */
    new_line = g_strdup_printf(" %s ", ipv4_addresses);
    tmp = strtok(new_line, " ");
    while( tmp != NULL )
    {
	opt_line = g_strdup_printf("DAEMON_OPTIONS(`Port=smtp,Addr=%s, Name=MTA')dnl\n", tmp);
	append_sendmail_mc_option(opt_line);
	g_free(opt_line);

	/* We pass NULL to strtok to get the next token in the string */
	tmp = strtok(NULL, " ");

	// Can be max 10 of these. Count and break.
    }
    g_free(new_line);

    /* Listen to IPv6 addresses and use IPv6: */
    if( ipv6_addresses!=NULL && strlen(ipv6_addresses) > 2 )
    {
	/* Add the "use IPv6" line first */
	opt_line = g_strdup_printf("DAEMON_OPTIONS(`Name=MTA-v4, Family=inet, Name=MTA-v6, Family=inet6')dnl\n");
	append_sendmail_mc_option(opt_line);
	g_free(opt_line);
	
	/* Listen to IPv6 addresses: */
	new_line = g_strdup_printf(" %s ", ipv6_addresses);
	tmp = strtok(new_line, " ");
	while( tmp != NULL )
	{
	    opt_line = g_strdup_printf("DAEMON_OPTIONS(`Port=smtp,Addr=%s, Name=MTA-v6, Family=inet6')dnl\n", tmp);
	    append_sendmail_mc_option(opt_line);
	    g_free(opt_line);

	    /* We pass NULL to strtok to get the next token in the string */
	    tmp = strtok(NULL, " ");

	    // Max 10 or num_IPv4 + numIPv6 == max 10 ?
	}
	g_free(new_line);
    }


    /* Smart_host: Tokenize if it can handle more then one */
    if( has_value((gchar *)smart_host) )
    {
	opt_line = g_strdup_printf("define(`SMART_HOST', `%s')dnl\n", smart_host);
	append_sendmail_mc_option(opt_line);
	g_free(opt_line);
    }

    /* Max_daemon_children */    
    opt_line = g_strdup_printf("define(`confMAX_DAEMON_CHILDREN', `%s')dnl\n", max_daemon_children);
    append_sendmail_mc_option(opt_line);
    g_free(opt_line);

    /* Connection_rate_throttle */
    opt_line = g_strdup_printf("define(`confCONNECTION_RATE_THROTTLE', `%s')dnl\n", connection_rate_throttle);
    append_sendmail_mc_option(opt_line);
    g_free(opt_line);


    /* Add options for Authentication type according to what has been selected in the combo */
    active_index = gtk_combo_box_get_active(GTK_COMBO_BOX(widgets->server_set_combo[0]));
    if( active_index == 0 )
    {
	/* Add no user/pass required */    
	opt_line = g_strdup_printf("define(`confAUTH_OPTIONS', `A')dnl\n");
	append_sendmail_mc_option(opt_line);
	g_free(opt_line);
    }
    if( active_index == 1 )
    {
	/* Add user/pass required */
	opt_line = g_strdup_printf("define(`confAUTH_OPTIONS', `A p')dnl\n");
	append_sendmail_mc_option(opt_line);
	g_free(opt_line);

	/* Add the authentication mechanisms. Get from the auth mechanism entry...
	   TRUST_AUTH_MECH(`EXTERNAL DIGEST-MD5 CRAM-MD5 LOGIN PLAIN')dnl */
	opt_line = g_strdup_printf("TRUST_AUTH_MECH(`EXTERNAL DIGEST-MD5 CRAM-MD5 LOGIN PLAIN')dnl\n");
	append_sendmail_mc_option(opt_line);
	g_free(opt_line);
	
	/* define(`confAUTH_MECHANISMS', `EXTERNAL GSSAPI DIGEST-MD5 CRAM-MD5 LOG PLAIN')dnl */
	opt_line = g_strdup_printf("define(`confAUTH_MECHANISMS', `EXTERNAL GSSAPI DIGEST-MD5 CRAM-MD5 LOGIN PLAIN')dnl\n");
	append_sendmail_mc_option(opt_line);
	g_free(opt_line);
    }


    /* Add options for Encryption type according to what has been selected in the combo */
    active_index = gtk_combo_box_get_active(GTK_COMBO_BOX(widgets->server_set_combo[1]));
    if( active_index == 0 )
    {
	/* No encryption selected.
	   Means nothing at all in the conf or with
	   the specified "smtp" addresses and hostnames */

	/* "No encryption" lines have already been added and 
	    Encryption lines have already been removed. */
    }
    else
    if( active_index == 1 )
    {
	/* Only encrytion is used.
	   Add encryption required options. */
	opt_line = g_strdup_printf("DAEMON_OPTIONS(`Port=smtps, Name=TLSMTA, M=s')dnl\n");
	append_sendmail_mc_option(opt_line);
	g_free(opt_line);

	/* Remove all "smtp" options, not "smtps" */
	lowercase_remove_sendmail_mc_option("daemon_options(`port=smtp", "addr=", "name=mta'");
	lowercase_remove_sendmail_mc_option("daemon_options(`port=smtp", "addr=", "name=mta-v6");

	/* FIX: Looks odd because the first 2 entries will be empty... */

	// FIX: Also use addr= in smtps line additions.
	//      And populate the listen to combos with that.

    }
    else
    if( active_index == 2 )
    {
	/* Add both "no encryption" and "encryption" options */

	/* No encryption lines have already been added */

	/* Get the listen to addresses. */
	

	/* Add encryption required options */
//	opt_line = g_strdup_printf("DAEMON_OPTIONS(`Port=smtps, Addr=%s Name=TLSMTA, M=s')dnl\n", address);
//	append_sendmail_mc_option(opt_line);
//	g_free(opt_line);
    }

    /* Both encryption and no encryption is used, add cert paths */    
    if( active_index == 1 || active_index == 2 )
    {
	/* Add certificate paths */
	opt_line = g_strdup_printf("define(`confCACERT_PATH', `%s/certs')dnl\n", APPCONFDIR);
	append_sendmail_mc_option(opt_line);
	g_free(opt_line);

	opt_line = g_strdup_printf("define(`confCACERT', `%s/certs/ca-bundle.crt')dnl\n", APPCONFDIR);
	append_sendmail_mc_option(opt_line);
	g_free(opt_line);

	opt_line = g_strdup_printf("define(`confSERVER_CERT', `%s/certs/sendmail.pem')dnl\n", APPCONFDIR);
	append_sendmail_mc_option(opt_line);
	g_free(opt_line);

	opt_line = g_strdup_printf("define(`confSERVER_KEY', `%s/certs/sendmail.pem')dnl\n", APPCONFDIR);
	append_sendmail_mc_option(opt_line);
	g_free(opt_line);
    }






    /* Populate the server settings */    
    populate_server_settings(widgets);

    /* Populate the configuration tab */
    populate_conf_tab(widgets);

    if( activated )
      reread_conf(widgets);
}
