/* GAdmin-Sendmail - An easy to use GTK+ frontend for the sendmail mailserver.
 * Copyright (C) 2008 - 2009 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/


#include "../config.h"
#include <gtk/gtk.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include "widgets.h"
#include "commands.h"
#include "activate_button_clicked.h"

extern int activated;



void activate_button_clicked(struct w *widgets)
{
    gchar *start, *cmd, *test;

    if( activated )
      return;

    cmd = g_strdup_printf("%s -C %s", MAKE_BINARY, SENDMAIL_SYSCONF_PATH);
    if( ! run_command(cmd) )
    {
        printf("Reconfiguring sendmail failed\n");
        test = g_strdup_printf("%s -C %s 2>&1", MAKE_BINARY, SENDMAIL_SYSCONF_PATH);
        run_command_show_err(test);
        g_free(test);
    }
    g_free(cmd);

    cmd = g_strdup_printf("%s > /dev/null 2>&1", NEWALIASES_BINARY);
    if( ! run_command(cmd) )
    {
        printf("Reconfiguring newaliases failed\n");
        test = g_strdup_printf("%s > /dev/null 2>&1", NEWALIASES_BINARY);
	run_command_show_err(test);
        g_free(test);
    }
    g_free(cmd);


    /* Start the server */
    start = g_strdup_printf("%s -bd", SENDMAIL_BINARY);
    if( ! run_command(start) )
    {
        printf("Starting sendmail failed using this command: %s\n", start);
        test = g_strdup_printf("%s -bd 2>&1", SENDMAIL_BINARY);
	run_command_show_err(test);
	g_free(test);

	/* No sence in starting a malfunctioning server at system boot */
	init_stop(widgets);
    }
    else
      init_start(widgets);

    g_free(start);
}
