/* GAdmin-Rsync - An easy to use GTK+ frontend for the rsync backup client and server.
 * Copyright (C) 2007 - 2014 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include <gtk/gtk.h>
#include "../config.h"
#include "support.h"
#include "gettext.h"
#include "widgets.h"



void show_help()
{
  gchar *help_text; 
  GtkWidget *help_window, *vbox15, *scrolledwindow16;
  GtkWidget *help_textview, *close_help_button;
  GtkWidget *alignment19, *hbox52, *image19, *label109;

  help_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_name (help_window, "help_window");
  gtk_widget_set_size_request (help_window, 650, 350);
  gtk_window_set_title (GTK_WINDOW (help_window), _("Gadmin-Rsync Help"));
  gtk_window_set_position (GTK_WINDOW (help_window), GTK_WIN_POS_CENTER);

  vbox15 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox15, "vbox15");
  gtk_widget_show (vbox15);
  gtk_container_add (GTK_CONTAINER (help_window), vbox15);

  scrolledwindow16 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_name (scrolledwindow16, "scrolledwindow16");
  gtk_widget_show (scrolledwindow16);
  gtk_box_pack_start (GTK_BOX (vbox15), scrolledwindow16, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow16), GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);

  help_textview = gtk_text_view_new ();
  gtk_widget_set_name (help_textview, "help_textview");
  gtk_widget_show (help_textview);
  gtk_container_add (GTK_CONTAINER (scrolledwindow16), help_textview);
  gtk_text_view_set_editable (GTK_TEXT_VIEW (help_textview), FALSE);
  gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (help_textview), FALSE);
  gtk_text_view_set_left_margin (GTK_TEXT_VIEW (help_textview), 30);
  gtk_text_view_set_right_margin (GTK_TEXT_VIEW (help_textview), 10);

  help_text = g_strconcat(
  _("\n\n\t\tHow to backup and restore using GAdmin-Rsync.\n\n\n"),

  _("1. Backing up data:\n\n"),

  _("Pressing the \"Create new backup\" button creates and adds a new backup.\n"),
  _("When this is done the \"Add backup data\" button can be used to\n"),
  _("specify what type of backups to include in the new backup, such as:\n"),
  _("remote to local, local to remote or local to local backups.\n"),
  _("The backups can be started manually with \"Run selected backup.\"\n"),
  _("The progress of the backup can be viewed in the progress tab.\n\n"),

  _("When everything is working as expected the backups can be\n"),
  _("scheduled to run at specific times using cron.\n"),
  _("Backups can also be scheduled to run at system shutdown.\n"),
  _("The backups will not be run if the system is rebooted.\n\n"),

  _("Logs and extended logs are kept for all backups.\n"),
  _("They can be viewed by clicking on \"Show backup log\" for each backup.\n\n\n"),


  _("2. Restoring data:\n\n"),

  _("Pressing the \"Restore from selection\" button shows a restore menu that\n"),
  _("contains relevant source and destination paths depending on the restore type.\n"),
  _("The paths shown are the reverse of the backups.\n"),
  _("Local source and destination paths can be browsed and re-selected.\n"),
  _("A slash last in source paths means transfer the content of\n"),
  _("the directory, IE: \"/path/\" means \"/path/*\".\n"),
  _("Press the \"Forward\" button when satisfied with the restore selection.\n"),
  _("The progress of the restore can be viewed in the progress tab.\n\n\n"),


  _("3. Technical specifications for backing up and restoring data:\n\n"),

  _("Remote backups and restores are differential and encrypted.\n"),
  _("This is achieved by using rsync over ssh.\n"),
  _("Keys are automatically created and installed on\n"),
  _("remote hosts using ssh-keygen, scp and ssh.\n"),
  _("For this to work the remote hosts must be running ssh servers.\n"),
  _("The data is backed up or restored as the selected username.\n"),

  NULL);

  gtk_text_buffer_set_text(gtk_text_view_get_buffer(GTK_TEXT_VIEW(help_textview)), help_text, -1);

  if( help_text!=NULL )
    g_free(help_text);

  close_help_button = gtk_button_new ();
  gtk_widget_set_name (close_help_button, "close_help_button");
  gtk_widget_show (close_help_button);
  gtk_box_pack_start (GTK_BOX (vbox15), close_help_button, FALSE, FALSE, 0);

  alignment19 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alignment19, "alignment19");
  gtk_widget_show (alignment19);
  gtk_container_add (GTK_CONTAINER (close_help_button), alignment19);

  hbox52 = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbox52, "hbox52");
  gtk_widget_show (hbox52);
  gtk_container_add (GTK_CONTAINER (alignment19), hbox52);

  image19 = gtk_image_new_from_stock ("gtk-close", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (image19, "image19");
  gtk_widget_show (image19);
  gtk_box_pack_start (GTK_BOX (hbox52), image19, FALSE, FALSE, 0);

  label109 = gtk_label_new_with_mnemonic (_("Close"));
  gtk_widget_set_name (label109, "label109");
  gtk_widget_show (label109);
  gtk_box_pack_start (GTK_BOX (hbox52), label109, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label109), GTK_JUSTIFY_LEFT);

  g_signal_connect_swapped(close_help_button, "clicked",
                           G_CALLBACK (gtk_widget_destroy),
                           GTK_OBJECT (help_window));

  gtk_widget_show_all(help_window);
}
