/* GAdmin-Rsync - An easy to use GTK+ frontend for the rsync backup client and server.
 * Copyright (C) 2007 - 2014 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/


#include "../config.h"
#include <gtk/gtk.h>
#include "support.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "widgets.h"

/* Save the selected file chooser path (file or directory) */
gchar *global_file_chooser_path;


void file_chooser_changed(GtkWidget *chooser)
{
    global_file_chooser_path = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(chooser));

    if( global_file_chooser_path == NULL )
        global_file_chooser_path = gtk_file_chooser_get_current_folder(GTK_FILE_CHOOSER(chooser));
}


gchar * get_local_dialog_path_selection(gchar *path)
{
    GtkWidget *dialog;
    gboolean ret = 0;
    int dlg_ret  = 0;

    /* We must use the cancel signal for the ok button so the dlg exists */
    dialog = gtk_file_chooser_dialog_new("Select directory",
    NULL,
    GTK_FILE_CHOOSER_ACTION_OPEN,
    GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL,
    GTK_STOCK_OK, GTK_RESPONSE_CANCEL,
    NULL);

    g_signal_connect(dialog, "current-folder-changed",
                  G_CALLBACK(file_chooser_changed), dialog);

    g_signal_connect(dialog, "file-activated",
                  G_CALLBACK(file_chooser_changed), dialog);

    /* Set initial directory. If it doesnt exist "/" is used. */
    /* FIX: dirname() if its a file. */
    ret = gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER(dialog), path);
    if( ! ret )
        ret = gtk_file_chooser_set_current_folder(GTK_FILE_CHOOSER(dialog), "/");

    dlg_ret = gtk_dialog_run(GTK_DIALOG(dialog));

    if( dlg_ret == GTK_RESPONSE_CANCEL )
    {
        //  printf("Path selection: Canceled.\n");
        //  path = NULL;
    }

    gtk_widget_destroy(dialog);

    return global_file_chooser_path;
}
