/* GAdmin-OpenVPN - An easy to use GTK+ frontend for the openvpn server.
 * Copyright (C) 2008 - 2011 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/


#include "../config.h"
#include <gtk/gtk.h>
#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>
#include "widgets.h"
#include "gettext.h"
#include "show_info.h"
#include "commands.h"
#include "export_window.h"
#include "export_button_clicked.h"


/* Copy server certs and keys to the client directory. */
int copy_to_client_dir(gchar *filename)
{
    gchar *info, *cmd, *path;

    if( filename == NULL || strlen(filename) < 3 )
    {
        info = g_strdup_printf(_("Error: Could not copy cert or key. Filename too short.\n"));
        show_info(info);
        g_free(info);
        g_free(cmd);
        return 0;
    }

    cmd = g_strdup_printf("cp %s/server/certs/%s %s/server/client/certs/",
                        OPENVPN_SYSCONF_DIR, filename, OPENVPN_SYSCONF_DIR);
    if( ! run_command(cmd) )
    {
        info = g_strdup_printf(_("Error: Could not copy cert or key with command: %s\n"), cmd);
        show_info(info);
        g_free(info);
        g_free(cmd);
        return 0;
    }
    g_free(cmd);

    /* Remove dh.pem if it exists in the client dir */
    path = g_strdup_printf("%s/server/client/certs/dh.pem", OPENVPN_SYSCONF_DIR);
    if( file_exists(path) )
        unlink(path);
    g_free(path);

    return 1;
}


/* Main GUI export button clicked */
void export_button_clicked(struct w *widgets)
{
    gchar *info, *filename = NULL;
    gchar *path = NULL;
    int i = 0;

    /* See if we have required things such as certs and client conf */
    path = g_strdup_printf("%s/server/certs/cert.pem", OPENVPN_SYSCONF_DIR);
    if( ! file_exists(path) )
    {
        info = g_strdup_printf(_("Generate new certificates in the server settings tab first.\n"));
        show_info(info);
        g_free(info);
        g_free(path);
        return;
    }
    g_free(path);

    /* See if we have a client configuration */
    path = g_strdup_printf("%s/server/client/gadmin-openvpn-client.conf", OPENVPN_SYSCONF_DIR);
    if( ! file_exists(path) )
    {
        info = g_strdup_printf(_("No client configuration has been created. You need to press apply first.\n"));
        show_info(info);
        g_free(info);
        g_free(path);
        return;
    }
    g_free(path);

    /* Copy server certs and keys to the client directory */
    for(i=0; i<4; i++)
    {
        if( i == 0 )
            filename = g_strdup_printf("cacert.pem");
        if( i == 1 )
            filename = g_strdup_printf("cert.pem");
        if( i == 2 )
            filename = g_strdup_printf("key.pem");
        if( i == 3 )
            filename = g_strdup_printf("ta.key");

        if( ! copy_to_client_dir(filename) )
        {
            g_free(filename);
            break;
        }
        g_free(filename);
    }

    /* Show the export window */
    show_export_window(widgets);
}
