/* GADMIN-HTTPD - An easy to use GTK+ frontend for Apache HTTPD webserver.
 * Copyright (C) 2006 - 2011 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include <gtk/gtk.h>

/* Make sure we have enough of these or itll borrow from the next widget-type and fail */
#define NUM_SERVERTAB_ENTRIES 25
#define NUM_SERVERTAB_SPINBUTTONS 13
#define NUM_SERVERTAB_COMBOS 16


#define NUM_USERTAB_ENTRIES 7
#define NUM_USERTAB_SPINBUTTONS 1
#define NUM_USERTAB_CHECKBUTTONS 3
#define NUM_USERTAB_COMBOS 1


typedef struct w
{
  GtkWidget *main_window;
  GtkWidget *main_vbox;

  GtkWidget *notebook_vbox1;
  GtkWidget *notebook_vbox2;
  GtkWidget *notebook_vbox3;
  GtkWidget *notebook_vbox4;
  GtkWidget *notebook_vbox5;
  GtkWidget *notebook_vbox6;
  GtkWidget *notebook_vbox7;
  GtkWidget *notebook_vbox8;

  GtkWidget *status_label;
  GtkWidget *version_label;

  /* The server tab's widgets */
  GtkWidget *server_treeview;
  GtkListStore *server_store;
  GtkWidget *server_settings_vbox;
  GtkWidget *server_settings_scrolled_window;

  GtkWidget *server_set_entry[NUM_SERVERTAB_ENTRIES];
  GtkWidget *server_set_spinbutton[NUM_SERVERTAB_SPINBUTTONS];
  GtkWidget *server_set_combo[NUM_SERVERTAB_COMBOS];
  GtkWidget *srv_set_table;

  /* The module tab's widgets... */
  /* Module list */
  GtkWidget *module_treeview;
  GtkListStore *module_store;

  /* AddType list */
  GtkWidget *addtype_treeview;
  GtkListStore *addtype_store;

  /* AddHandler list */
  GtkWidget *addhandler_treeview;
  GtkListStore *addhandler_store;

  /* AddEncoding list */
  GtkWidget *addencoding_treeview;
  GtkListStore *addencoding_store;

  /* AddLanguage list */
  GtkWidget *addlanguage_treeview;
  GtkListStore *addlanguage_store;

  /* AddDescription list */
  GtkWidget *adddescription_treeview;
  GtkListStore *adddescription_store;

  /* AddIcon list */
  GtkWidget *addicon_treeview;
  GtkListStore *addicon_store;

  /* AddIconByType list */
  GtkWidget *addiconbytype_treeview;
  GtkListStore *addiconbytype_store;

  /* AddIconByEncoding list */
  GtkWidget *addiconbyencoding_treeview;
  GtkListStore *addiconbyencoding_store;

  /* Alias list */
  GtkWidget *alias_treeview;
  GtkListStore *alias_store;

  /* ScriptAlias list */
  GtkWidget *scriptalias_treeview;
  GtkListStore *scriptalias_store;


  /* The Directory access tab's widgets */
  GtkWidget *virtual_usr_table;
  GtkWidget *virtual_user_treeview;
  GtkListStore *virtual_user_store;

  GtkWidget *htacc_usr_table;
  GtkWidget *htacc_user_treeview;
  GtkListStore *htacc_user_store;

  GtkWidget *user_set_entry[NUM_USERTAB_ENTRIES];

  GtkWidget *htacc_dir_sel;

  GtkWidget *gen_cert_progressbar;

  /* The add default configuration question window */
  GtkWidget *default_conf_question_window;

  /* The transfer tabs widgets */
  GtkWidget *transfer_treeview;
  GtkListStore *transfer_store;
  GtkWidget *total_bandwidth_label;
  GtkWidget *total_incoming_label;
  GtkWidget *total_outgoing_label;
  GtkWidget *kick_entry;
  GtkWidget *transfer_pid_checkbutton;

  /* The disc tabs widgets */
  GtkWidget *disc_treeview;
  GtkListStore *disc_store;

  /* The access/file treeview */
  GtkWidget *file_treeview;
  GtkListStore *file_store;

  /* The error tabs widgets */
  GtkWidget *error_treeview;
  GtkListStore *error_store;

  /* The conf tabs textview */
  GtkWidget *conf_textview;

  /* The import windows widgets */
  GtkWidget *import_window;
  GtkWidget *import_treeview;
  GtkListStore *import_store;
  GtkWidget *import_home_entry;
  GtkWidget *import_upload_entry;
  GtkWidget *import_namebased_checkbutton;
  GtkWidget *import_upload_checkbutton;

}wid;
