/* GADMIN-HTTPD - An easy to use GTK+ frontend for Apache HTTPD webserver.
 * Copyright (C) 2006 - 2011 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include <gtk/gtk.h>
#include "../config.h"
#include "support.h"
#include "gettext.h"
#include "widgets.h"



void show_help()
{
  gchar *help_text; 
  GtkWidget *help_window, *vbox15, *scrolledwindow16;
  GtkWidget *help_textview, *close_help_button;
  GtkWidget *alignment19, *hbox52, *image19, *label109;

  help_window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_widget_set_name (help_window, "help_window");
  gtk_widget_set_size_request (help_window, 650, 350);
  gtk_window_set_title (GTK_WINDOW (help_window), _("GADMIN HTTPD help"));
  gtk_window_set_position (GTK_WINDOW (help_window), GTK_WIN_POS_CENTER);

  vbox15 = gtk_vbox_new (FALSE, 0);
  gtk_widget_set_name (vbox15, "vbox15");
  gtk_widget_show (vbox15);
  gtk_container_add (GTK_CONTAINER (help_window), vbox15);

  scrolledwindow16 = gtk_scrolled_window_new (NULL, NULL);
  gtk_widget_set_name (scrolledwindow16, "scrolledwindow16");
  gtk_widget_show (scrolledwindow16);
  gtk_box_pack_start (GTK_BOX (vbox15), scrolledwindow16, TRUE, TRUE, 0);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolledwindow16), GTK_POLICY_AUTOMATIC, GTK_POLICY_ALWAYS);

  help_textview = gtk_text_view_new ();
  gtk_widget_set_name (help_textview, "help_textview");
  gtk_widget_show (help_textview);
  gtk_container_add (GTK_CONTAINER (scrolledwindow16), help_textview);
  gtk_text_view_set_editable (GTK_TEXT_VIEW (help_textview), FALSE);
  gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (help_textview), FALSE);
  gtk_text_view_set_left_margin (GTK_TEXT_VIEW (help_textview), 30);
  gtk_text_view_set_right_margin (GTK_TEXT_VIEW (help_textview), 10);

  help_text = g_strconcat(
  
  _("\n\nThis help is currently incomplete.\n\n"),


  _("\n\nServers and server settings.\n\n"),


  _("\n\nModules and addons.\n\n"),


  _("\n\nVirtual hosts and virtual hosting:\n\n"),


  _("\n\nAccess privileges and users:\n\n"),
  _("When adding a user you can randomize its username and password or use your own.\n"),
  _("You can also select its login shell, group, comment and home directory.\n"),
  _("Press add when you are satisfied with the users settings.\n\n"),



  _("For more detailed information about the server and its configuration directives visit:\n"),
  _("http://www.apache.org\n"), NULL);
  gtk_text_buffer_set_text(gtk_text_view_get_buffer(GTK_TEXT_VIEW(help_textview)), help_text, -1);

  if( help_text!=NULL )
    g_free(help_text);

  close_help_button = gtk_button_new ();
  gtk_widget_set_name (close_help_button, "close_help_button");
  gtk_widget_show (close_help_button);
  gtk_box_pack_start (GTK_BOX (vbox15), close_help_button, FALSE, FALSE, 0);

  alignment19 = gtk_alignment_new (0.5, 0.5, 0, 0);
  gtk_widget_set_name (alignment19, "alignment19");
  gtk_widget_show (alignment19);
  gtk_container_add (GTK_CONTAINER (close_help_button), alignment19);

  hbox52 = gtk_hbox_new (FALSE, 2);
  gtk_widget_set_name (hbox52, "hbox52");
  gtk_widget_show (hbox52);
  gtk_container_add (GTK_CONTAINER (alignment19), hbox52);

  image19 = gtk_image_new_from_stock ("gtk-close", GTK_ICON_SIZE_BUTTON);
  gtk_widget_set_name (image19, "image19");
  gtk_widget_show (image19);
  gtk_box_pack_start (GTK_BOX (hbox52), image19, FALSE, FALSE, 0);

  label109 = gtk_label_new_with_mnemonic (_("Close"));
  gtk_widget_set_name (label109, "label109");
  gtk_widget_show (label109);
  gtk_box_pack_start (GTK_BOX (hbox52), label109, FALSE, FALSE, 0);
  gtk_label_set_justify (GTK_LABEL (label109), GTK_JUSTIFY_LEFT);

  g_signal_connect_swapped(close_help_button, "clicked",
                           G_CALLBACK (gtk_widget_destroy),
                           GTK_OBJECT (help_window));

  gtk_widget_show_all(help_window);
}
