/* GADMIN-HTTPD - An easy to use GTK+ frontend for Apache HTTPD webserver.
 * Copyright (C) 2006 - 2011 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include "../config.h"
#include <gtk/gtk.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "widgets.h"
#include "gettext.h"
#include "allocate.h"
#include "show_info.h"
#include "chars_are_digits.h"

extern int MAX_READ_POPEN;
extern int httpd_mayor_version;


void set_version(struct w *widgets)
{
    FILE *fp;
    char *version, *p;
    int i=0, ver_found=0;
    gchar *command;
    gchar *ver=NULL;
    gchar *utf8=NULL;
    gchar *info;
    GdkColor color;

    command = g_strdup_printf("%s -v 2>&1", HTTPD_BINARY);
    if((fp=popen(command, "r"))==NULL)
    {
        info = g_strdup_printf(_("Set version failed\n"));
        show_info(info);
        g_free(info);
        g_free(command);
        return;
    }

    version = allocate(MAX_READ_POPEN);

    while(fgets(version, MAX_READ_POPEN, fp)!=NULL)
    {
        if( strstr(version, "version") && strlen(version) < 100 )
          break;
    }
    pclose(fp);
    g_free(command);    
    
    /* We cut out the first 16 chars and change '/' to '-' if any */
    ver = g_strdup_printf(_(" Information: %s"), &version[16]);
    for(i=0; ver[i]!='\0'; i++)
    if( ver[i]=='/' )
        ver[i]='-';

    /* Snip away the (OS) */
    for(i=0; ver[i]!='\0'; i++)
    if( ver[i]=='(' )
        ver[i]='\0';

    utf8 = g_locale_to_utf8(ver, strlen(ver)-1, NULL, NULL, NULL);
    gtk_label_set_text(GTK_LABEL(widgets->version_label), utf8);
    g_free(utf8);
    ver_found = 1;

    /* Set httpd_mayor_version globally for use with standard confs */
    p = allocate(3);
    for(i=0; ver[i]!='\0'; i++)
    {
        snprintf(p, 2, "%s", &ver[i]);

        if( p[0]=='1' || p[0]=='2' || p[0]=='3'
        ||  p[0]=='4' || p[0]=='5' || p[0]=='6' )
        {
            httpd_mayor_version = atoi(p);
            break;
        }
    }
    free(p);
    free(version);

    if( ! ver_found )
    {
        ver = g_strdup_printf(_(" Apache HTTPD is not installed or not in your path."));
        utf8 = g_locale_to_utf8(ver, strlen(ver), NULL, NULL, NULL);
        gtk_label_set_text(GTK_LABEL(widgets->version_label), utf8);
        g_free(utf8);

        /* Set status color */
        gdk_color_parse("red", &color);
        gtk_widget_modify_fg(widgets->version_label, GTK_STATE_NORMAL, &color);
    }
    g_free(ver);
}
