/* GADMIN-HTTPD - An easy to use GTK+ frontend for Apache HTTPD webserver.
 * Copyright (C) 2006 - 2011 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/


#include "../config.h"
#include <gtk/gtk.h>
#include "support.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "allocate.h"
#include "functions.h"
#include "widgets.h"
#include "populate_disc_tab.h"
#include "show_info.h"

#define MAXR 16384


void populate_transfers(struct w *widgets)
{
    /* Lists transfers in the transfer treeview */
    FILE *fp;
    GtkTreeIter iter;
    GtkTreePath *path;
    gboolean edit=0;
    long x = 0;
    int have_transfer = 0;
    gchar *cmd, *utf8=NULL;

    char line[MAXR]="";
    char line1[MAXR*2]="";

    char a0[MAXR]="", a1[MAXR]="", a2[MAXR]="", a3[MAXR]="", a4[MAXR]="";
    char a5[MAXR]="", a6[MAXR]="", a7[MAXR]="", a8[MAXR]="", a9[MAXR]="";
    char a10[MAXR]="", a11[MAXR]="", a12[MAXR]="";

    gtk_list_store_clear(widgets->transfer_store);

    gtk_entry_set_text(GTK_ENTRY(widgets->kick_entry), "");

/*
    cmd = g_strdup_printf("%s fullstatus", "apachectl");
    cmd = g_strdup_printf("%s -nomargins -dump http://localhost:80/server-status", "lynx");
    cmd = g_strdup_printf("%s -dump http://localhost:80/server-status", "elinks");

    Atleast 4 different commands can be used:
    apachectl [status | fullstatus] (GET and HTTP/1.1 are not shown on the same line and it differs)
    lynx -nomargins -dump http://localhost:80/server-status
    elinks -dump http://localhost:80/server-status
    This seems to give the most reliable output for our purposes...
    wget --output-document=- http://localhost:80/server-status
*/

    cmd = g_strdup_printf("%s --output-document=- http://localhost:80/server-status", "wget");

    if((fp=popen(cmd, "r"))==NULL)
    {
        printf("Error running command %s\n", cmd);
        g_free(cmd);
        return;
    }
    fflush(fp);

    g_free(cmd);

    /* Scroll to the beginning of the input */
    while(fgets(line, MAXR, fp)!=NULL)
    {
        if( strlen(line) < 3 )
            continue;

        if( cmplowercase(line, "req</th><th>conn</th><th>child</th><th>slot</th><th>client</th><th>vhost</th><th>request<") )
            break;
    }

    while(fgets(line, MAXR, fp)!=NULL)
    {
        if( strlen(line) < 3 )
          continue;

        /* Break at the end */
        if( cmplowercase(line, "child server number - generation") )
            break;

        x++;

        /* Collect 3 lines per client transfer */
        if( x == 1 )
        {
            strcpy(line1, line);
        }
        if( x == 2 )
        {
            strcat(line1, line);
        }

        if( line1[strlen(line1)-1]=='\n' )
            line1[strlen(line1)-1]='\0';

        if( x < 3 )
          continue;

        strcat(line1, line);
        if( line1[strlen(line1)-1]=='\n' )
            line1[strlen(line1)-1]='\0';

        /* Remove all <Brackety things> */
        for(x=0; line1[x]!='\0'; x++)
        {
            if( line1[x]!='<' )
              continue;

            line1[x]=' ';

            for(x=x; line1[x]!='\0'; x++)
            {
	            if( line1[x]=='>' )
	            {
	                line1[x]=' ';
	                break;
	            }
	            line1[x]=' ';
            }
        }

        sscanf(line1, "%s %s %s %s %s %s %s %s %s %s %s %s %s",
            a0, a1, a2, a3, a4, a5, a6, a7, a8, a9, a10, a11, a12);

        /* Also append everything after GET ... */
        for(x=0; line1[x+4]!='\0'; x++)
        {
            if( (line1[x]=='G' && line1[x+1]=='E' && line1[x+2]=='T')
            ||  (line1[x]=='H' && line1[x+1]=='T' && line1[x+2]=='T'
            &&   line1[x+3]=='P' && line1[x+4]=='/') )
            {
	        strcat(a12, " ");
	        strcat(a12, &line1[x+4]);
	        break;
            }
        }

        x = 0;

        have_transfer = 1;

        gtk_list_store_append(GTK_LIST_STORE(widgets->transfer_store), &iter);

        utf8 = g_locale_to_utf8(a0, strlen(a0), NULL, NULL, NULL);
        gtk_list_store_set(GTK_LIST_STORE(widgets->transfer_store), &iter, 0, utf8, -1);

        utf8 = g_locale_to_utf8(a1, strlen(a1), NULL, NULL, NULL);
        gtk_list_store_set(GTK_LIST_STORE(widgets->transfer_store), &iter, 1, utf8, -1);

        utf8 = g_locale_to_utf8(a2, strlen(a2), NULL, NULL, NULL);
        gtk_list_store_set(GTK_LIST_STORE(widgets->transfer_store), &iter, 2, utf8, -1);

        utf8 = g_locale_to_utf8(a3, strlen(a3), NULL, NULL, NULL);
        gtk_list_store_set(GTK_LIST_STORE(widgets->transfer_store), &iter, 3, utf8, -1);

        utf8 = g_locale_to_utf8(a4, strlen(a4), NULL, NULL, NULL);
        gtk_list_store_set(GTK_LIST_STORE(widgets->transfer_store), &iter, 4, utf8, -1);

        utf8 = g_locale_to_utf8(a5, strlen(a5), NULL, NULL, NULL);
        gtk_list_store_set(GTK_LIST_STORE(widgets->transfer_store), &iter, 5, utf8, -1);

        utf8 = g_locale_to_utf8(a6, strlen(a6), NULL, NULL, NULL);
        gtk_list_store_set(GTK_LIST_STORE(widgets->transfer_store), &iter, 6, utf8, -1);

        utf8 = g_locale_to_utf8(a7, strlen(a7), NULL, NULL, NULL);
        gtk_list_store_set(GTK_LIST_STORE(widgets->transfer_store), &iter, 7, utf8, -1);

        utf8 = g_locale_to_utf8(a8, strlen(a8), NULL, NULL, NULL);
        gtk_list_store_set(GTK_LIST_STORE(widgets->transfer_store), &iter, 8, utf8, -1);

        utf8 = g_locale_to_utf8(a9, strlen(a9), NULL, NULL, NULL);
        gtk_list_store_set(GTK_LIST_STORE(widgets->transfer_store), &iter, 9, utf8, -1);

        utf8 = g_locale_to_utf8(a10, strlen(a10), NULL, NULL, NULL);
        gtk_list_store_set(GTK_LIST_STORE(widgets->transfer_store), &iter, 10, utf8, -1);

        utf8 = g_locale_to_utf8(a11, strlen(a11), NULL, NULL, NULL);
        gtk_list_store_set(GTK_LIST_STORE(widgets->transfer_store), &iter, 11, utf8, -1);

        utf8 = g_locale_to_utf8(a12, strlen(a12), NULL, NULL, NULL);
        gtk_list_store_set(GTK_LIST_STORE(widgets->transfer_store), &iter, 12, utf8, -1);
    }
    pclose(fp);

    if( utf8!=NULL )
        g_free(utf8);

    if( ! have_transfer )
    {
        gtk_list_store_append(GTK_LIST_STORE(widgets->transfer_store), &iter);
        strcpy(a0, _("The server must be activated to view transfers.\n"));
        strcat(a0, _("To view transfers <Location /server-status> must allow\n"));
        strcat(a0, _("localhost and sometimes also localhost.localdomain.\n"));
        strcat(a0, _("Edit this in the configuration tab if needed.\n"));
        utf8 = g_locale_to_utf8(a0, strlen(a0), NULL, NULL, NULL);
        gtk_list_store_set(GTK_LIST_STORE(widgets->transfer_store), &iter, 0, utf8, -1);
        return;
    }

    path = gtk_tree_path_new_first();
    gtk_tree_view_set_cursor(GTK_TREE_VIEW(widgets->transfer_treeview), path, NULL, edit);
    gtk_tree_path_free(path);
}
