/* GADMIN-HTTPD - An easy to use GTK+ frontend for Apache HTTPD webserver.
 * Copyright (C) 2006 - 2011 Magnus Loef <magnus-swe@telia.com> 
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
*/



#include "../config.h"
#include <gtk/gtk.h>
#include "support.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include "allocate.h"
#include "widgets.h"
#include "populate_servers.h"
#include "show_info.h"
#include "commented.h"
#include "functions.h"

extern char global_server_port[1024];
extern char global_server_name[1024];
extern char global_server_type[1024];



/* Lists servers in the serverlist */
void populate_servers(struct w *widgets)
{
    FILE *fp;
    GtkTreeIter iter;
    GtkTreePath *path;
    char *line, *new_buffer;
    long conf_size;
    gboolean edit=0;
    int i=0, x=0, once=0, found=0;
    gchar *utf8=NULL;

    gtk_list_store_clear(widgets->server_store);

    /* Populate the serverlist */
    if((fp=fopen(HTTPD_CONF, "r"))==NULL)
    {
        /* Dont show annoying popup */
        return;
    }
    fseek(fp, 0, SEEK_END);
    conf_size = ftell(fp);
    rewind(fp);

    line = allocate(conf_size);
    new_buffer = allocate(conf_size);

    /* Add a row and insert values for the standard server */
    gtk_list_store_append(GTK_LIST_STORE(widgets->server_store), &iter);
    /* Insert the type */
    utf8 = g_locale_to_utf8("Default server", 14, NULL, NULL, NULL);
    gtk_list_store_set(GTK_LIST_STORE(widgets->server_store), &iter, 3, utf8, -1);

    /* List the default server */
    if( conf_size > 1 )
    while(fgets(line, conf_size, fp)!=NULL)
    {
	    if( commented(line) )
	      continue;

	    if( cmplowercase(line, "<virtualhost ") )
	      break;
	
	    new_buffer[0]='\0';

	    if( cmplowercase(line, "listen ") && ! once )
	    {
	        once = 1;
	
	        /* Scroll to the option "ip:port" or just "port" */
	        for(x=0; line[x]!='\0'; x++)
	          if( line[x]!=' ' )
	        	break;

	        for(x=x; line[x]!='\0'; x++)
	          if( line[x]==' ' && line[x+1]!=' ' )
	        	break;
	        x++; /* We are at the beginning of the option */
	        
	        snprintf(new_buffer, 500, "%s", &line[x]);

            /* The syntax here should be address:port */
            if( cmplowercase(line, ":") && cmplowercase(line, ".") )
            {
                /* Cut away the port ":2468" */
                for(x=0; new_buffer[x]!='\0'; x++)
                  if( new_buffer[x]==':' )
	                break;
                new_buffer[x]='\0';
            }
            else
            {   /* The syntax here is Listen PORT.
                   Address is always 0.0.0.0 then */
                snprintf(new_buffer, 500, "%s", "0.0.0.0");
	        }

            if( new_buffer[strlen(new_buffer)-1]=='\n' )
                new_buffer[strlen(new_buffer)-1]='\0';

	        /* Insert the address */
            utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_list_store_set(GTK_LIST_STORE(widgets->server_store), &iter, 0, utf8, -1);

	        /* Insert the server port... */
	        if( cmplowercase(line, ":") && cmplowercase(line, ".") )
	        {
		        /* Scroll to the server port */
		        for(x=0; line[x]!='\0'; x++)
                  if( line[x]==':' )
            	    break;
                x++;
	        }

	        for(x=x; line[x]!='\0'; x++)
	          if( line[x]!=' ' )
	        	break;

	        snprintf(new_buffer, 500, "%s", &line[x]);

	        if( new_buffer[strlen(new_buffer)-1]=='\n' )
	          new_buffer[strlen(new_buffer)-1]='\0';

	        /* Insert the port */
        	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
        	    gtk_list_store_set(GTK_LIST_STORE(widgets->server_store), &iter, 1, utf8, -1);
	    }

        if( cmplowercase(line, "servername ") )
        {
            /* Scroll to the server name */
            for(x=0; line[x]!='\0'; x++)
              if( line[x]!=' ' )
            	break;

            for(x=x; line[x]!='\0'; x++)
              if( line[x]!=' ' && line[x+1]==' ' )
            	break;

            x=x+2;
            snprintf(new_buffer, 500, "%s", &line[x]);
            if( new_buffer[strlen(new_buffer)-1]=='\n' )
              new_buffer[strlen(new_buffer)-1]='\0';
	            
            utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
            gtk_list_store_set(GTK_LIST_STORE(widgets->server_store), &iter, 2, utf8, -1);
    	}
    }		    
    /* End of listing the default server */


    /* List the VirtualHosts */
    found = 0;
    rewind(fp);

    if( conf_size > 1 )
    while(fgets(line, conf_size, fp)!=NULL)
    {
	if( commented(line) )
	  continue;

	/* List vhosts */
	if( cmplowercase(line, "<virtualhost ") )
	{
	    /* Add a row */
    	    gtk_list_store_append(GTK_LIST_STORE(widgets->server_store), &iter);
	    
	    /* Scroll to the beginning of the address */
	    for(x=0; line[x]!='\0'; x++)
	      if( line[x]!=' ' )
	        break;

	    for(x=x; line[x]!='\0'; x++)
	      if( line[x]==' ' && line[x+1]!=' ' )
	        break;

	    /* Scroll past any whitespace after the option */
	    for(x=x; line[x]!='\0'; x++)
	      if( line[x]!=' ' )
	        break;
	    
	    /* Get the beginning of the address */
	    snprintf(new_buffer, conf_size, "%s", &line[x]);

	    /* Get the end of the address ':' */
	    for(i=0; new_buffer[i]!='\0'; i++)
	      if( new_buffer[i]==':' || new_buffer[i]==' ' )
		break;

	    /* Cut the last ':portnr>' */
	    new_buffer[i]='\0';

	    /* Insert address */
    	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
    	    gtk_list_store_set(GTK_LIST_STORE(widgets->server_store), &iter, 0, utf8, -1);

	    /* Insert the vhost type identifier, uncool for utf-8 xlations  */
    	    utf8 = g_locale_to_utf8("Virtualhost", 11, NULL, NULL, NULL);
    	    gtk_list_store_set(GTK_LIST_STORE(widgets->server_store), &iter, 3, utf8, -1);
	    found = 1;

	    /* Port */
	    for(x=strlen(line)-1; line[x]!='\0'; x--)
	       if( line[x-1]==':')
	         break;
	    snprintf(new_buffer, 500, "%s", &line[x]);
	    new_buffer[strlen(new_buffer)-2]='\0'; // cut "> "
	    
    	    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
    	    gtk_list_store_set(GTK_LIST_STORE(widgets->server_store), &iter, 1, utf8, -1);

	    /* Insert server name */
	    while(fgets(line, conf_size, fp)!=NULL)
	    {
		if( commented(line) )
		    continue;

		/* Break at vhost end */
		if( cmplowercase(line, "</virtualhost>") )
		    break;

		if( cmplowercase(line, "servername ") )
		{
		    /* Scroll to the server name */
		    for(x=0; line[x]!='\0'; x++)
	    	      if( line[x]!=' ' )
	        	break;

		    for(x=x; line[x]!='\0'; x++)
	    	      if( line[x]!=' ' && line[x+1]==' ' )
	        	break;

	    	    x=x+2;
		    snprintf(new_buffer, 500, "%s", &line[x]);
		    if( new_buffer[strlen(new_buffer)-1]=='\n' )
		      new_buffer[strlen(new_buffer)-1]='\0';
		    
    		    utf8 = g_locale_to_utf8(new_buffer, strlen(new_buffer), NULL, NULL, NULL);
    		    gtk_list_store_set(GTK_LIST_STORE(widgets->server_store), &iter, 2, utf8, -1);
    		}
	    }
	}
    }
    fclose(fp);
    free(line);
    free(new_buffer);

    if( utf8 !=NULL )
      g_free(utf8);

    /* We always append a line for the default server first, so this wont crash */
    path = gtk_tree_path_new_first();
    gtk_tree_view_set_cursor(GTK_TREE_VIEW(widgets->server_treeview), path, NULL, edit);
    gtk_tree_path_free(path);
}
